/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "autorelabel.h"

#include <iostream>
using namespace std;

//default constructor
AutoRelabel::AutoRelabel(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Autorelabel Process"));
/*
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(0,254,100));
*/

	timeButtonGroup = new Q3ButtonGroup(this);
	timeButtonGroup->resize( 200, 200 );
	nowRadioButton = new QRadioButton(tr("now"), timeButtonGroup);
	nextbootRadioButton = new QRadioButton(tr("nextboot"), timeButtonGroup);
	nowRadioButton->setGeometry( 10, 10, 100, 20 );
	nextbootRadioButton->setGeometry( 10, 30, 100, 20 );
	nextbootRadioButton->setChecked(true);

	autorelabelButton = new QPushButton(tr("Autorelabel"), this);
	autorelabelButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(autorelabelButton, SIGNAL(clicked()), this, SLOT(autorelabel_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//autorelabel_base_process();

	mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
/*
	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);
*/
	middleLayout = new Q3VBoxLayout;
	rightLayout = new Q3HBoxLayout;
	leftLayout = new Q3HBoxLayout;
	//thirdLayout = new QHBoxLayout;
	
	//rightLayout->addStretch();
	rightLayout->addWidget(timeButtonGroup);
	leftLayout->addStretch();
	leftLayout->addWidget(autorelabelButton);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	//middleLayout->addLayout(thirdLayout);

	footLayout = new Q3HBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	//mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(300,200);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void AutoRelabel::autorelabel_button_clicked()
{
	autorelabel_button_clicked_process();
}
/* this slot does just make .pp file */
void AutoRelabel::autorelabel_button_clicked_process()
{
	if(nowRadioButton->isChecked()){
		#define PWD_BUF 8600
		const char* autorelabel_touch_file="/usr/share/segatex/autorelabel_touch";
		semanageEditLineEdit_str_pp = "touch /.autorelabel";
		ofstream os_relabel_touch;
		os_relabel_touch.open(autorelabel_touch_file);
		if(os_relabel_touch){
			FILE *read_fp;
			#define SIZE_TMP 8600
			char buffer[SIZE_TMP];
			int chars_read;
			memset(buffer, '\0', sizeof(buffer));
			read_fp = popen(semanageEditLineEdit_str_pp, "r");
			if(read_fp != NULL){
				chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				while(chars_read>0){
					buffer[chars_read -1] = '\0';
					//os << "Reading:-" << endl;
					os_relabel_touch << buffer << endl;
					chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				}
				pclose(read_fp);
			}
		}
		os_relabel_touch.close();

		#define PWD_BUF 8600
		const char* autorelabel_shutdown_r_now_file="/usr/share/segatex/autorelabel_shutdown_r_now";
		semanageEditLineEdit_str_pp = "shutdown -r now";
		ofstream os_relabel_shutdown_r_now;
		os_relabel_shutdown_r_now.open(autorelabel_shutdown_r_now_file);
		if(os_relabel_shutdown_r_now){
			FILE *read_fp;
			#define SIZE_TMP 8600
			char buffer[SIZE_TMP];
			int chars_read;
			memset(buffer, '\0', sizeof(buffer));
			read_fp = popen(semanageEditLineEdit_str_pp, "r");
			if(read_fp != NULL){
				chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				while(chars_read>0){
					buffer[chars_read -1] = '\0';
					//os << "Reading:-" << endl;
					os_relabel_shutdown_r_now << buffer << endl;
					chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				}
				pclose(read_fp);
			}
		}
		os_relabel_shutdown_r_now.close();
	}

	if(nextbootRadioButton->isChecked()){
		#define PWD_BUF 8600
		const char* autorelabel_touch_file="/usr/share/segatex/autorelabel_touch";
		semanageEditLineEdit_str_pp = "touch /.autorelabel";
		ofstream os_relabel_touch;
		os_relabel_touch.open(autorelabel_touch_file);
		if(os_relabel_touch){
			FILE *read_fp;
			#define SIZE_TMP 8600
			char buffer[SIZE_TMP];
			int chars_read;
			memset(buffer, '\0', sizeof(buffer));
			read_fp = popen(semanageEditLineEdit_str_pp, "r");
			if(read_fp != NULL){
				chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				while(chars_read>0){
					buffer[chars_read -1] = '\0';
					//os << "Reading:-" << endl;
					os_relabel_touch << buffer << endl;
					chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				}
				pclose(read_fp);
			}
		}
		os_relabel_touch.close();
	}


	//autorelabel_base_process();
}
void AutoRelabel::autorelabel_base_process()
{
        #define PWD_BUF 8600
        const char* semanage_boolean_list_file="/usr/share/segatex/autorelabel_text";
        ofstream os_test;
        os_test.open(semanage_boolean_list_file);
        if(os_test){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                //read_fp = popen("man restorecon", "r");
                read_fp = popen("less /usr/share/segatex/autorelabel_text", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_test << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os_test.close();
	readFromOutputFile();
}

//this slot should be called from above slot
void AutoRelabel::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*autorelabel_text");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			/*
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			*/
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########About relabeling the system#########");
					textEdit1->append("");
				/*
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				*/
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					/*
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
					*/
                                        //if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					//}else{
						textEdit1->append(line_analized);
					//}
				}
				//file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
			file.close();
		}
}
