/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ausearch.h"
#include "ausearch_process.h"

#include <iostream>
using namespace std;

//default constructor
Ausearch::Ausearch(QWidget *parent, const char *name): QDialog(parent, name)
{
	ausearch_process_o = 0;

	ausearchLabel = new QLabel(tr("Search about"),this);
	startdayLabel = new QLabel(tr("start-day ex.(1/1/2014)"),this);
	starttimeLabel = new QLabel(tr("start-time"),this);
	enddayLabel = new QLabel(tr("end-day"),this);
	endtimeLabel = new QLabel(tr("end-time"),this);

	ausearchEditLineEdit = new QLineEdit( this );
        ausearchEditLineEdit->setText("");
        ausearchEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	startdayEditLineEdit = new QLineEdit( this );
        startdayEditLineEdit->setText("this-year");
        startdayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	starttimeEditLineEdit = new QLineEdit( this );
        starttimeEditLineEdit->setText("04:00:00");
        starttimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	enddayEditLineEdit = new QLineEdit( this );
        enddayEditLineEdit->setText("today");
        enddayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	endtimeEditLineEdit = new QLineEdit( this );
        endtimeEditLineEdit->setText("");
        endtimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	interpretCheckBox = new QCheckBox(tr("Interpret numeric entities into text"), this);
	ausearchButton = new QPushButton(tr("Search"), this);
	ausearchButton->setPaletteBackgroundColor(QColor(250,180,200));
	connect(ausearchButton, SIGNAL(clicked()), this, SLOT(ausearch_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QHBoxLayout;
	rightLayout = new QVBoxLayout;
	leftLayout = new QVBoxLayout;


	leftLayout->addWidget(ausearchLabel);
	leftLayout->addWidget(createFirstExclusiveGroup());
	leftLayout->addWidget(ausearchEditLineEdit);

	rightLayout->addWidget(startdayLabel);
	rightLayout->addWidget(startdayEditLineEdit);
	rightLayout->addWidget(starttimeLabel);
	rightLayout->addWidget(starttimeEditLineEdit);
	//rightLayout->addStretch();

	rightLayout->addWidget(enddayLabel);
	rightLayout->addWidget(enddayEditLineEdit);
	rightLayout->addWidget(endtimeLabel);
	rightLayout->addWidget(endtimeEditLineEdit);

	rightLayout->addWidget(interpretCheckBox);

	rightLayout->addWidget(ausearchButton);

	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);

	setLayout(mainLayout);
	setWindowTitle(tr("Ausearch"));

	ausearch_process_o = 0;
}

QGroupBox *Ausearch::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("test"));
        eventRadioButton = new QRadioButton(tr("events (audit-event-id)"));
        commnameRadioButton = new QRadioButton(tr("come name (comm-name)"));
        filenameRadioButton = new QRadioButton(tr("filename (file-name)"));
        allgroupidRadioButton = new QRadioButton(tr("group ID (all-group-id)"));
        effectivegroupidRadioButton = new QRadioButton(tr("effective group ID (effective-group-id)"));
        groupidRadioButton = new QRadioButton(tr("group ID (group-id)"));
        helpRadioButton = new QRadioButton(tr("help"));
        hostnameRadioButton = new QRadioButton(tr("host name (host-name)"));
        keystringRadioButton = new QRadioButton(tr("key string (key-string)"));
        nodenameRadioButton = new QRadioButton(tr("node (node-name)"));
        objectRadioButton = new QRadioButton(tr("object (SE-Linux-context-string)"));
        inputRadioButton = new QRadioButton(tr("input (file-name)"));
        processidRadioButton = new QRadioButton(tr("pid (process-id)"));
        syscallRadioButton = new QRadioButton(tr("syscall (syscall-name-or-value)"));

	eventRadioButton->setChecked(true);

	vbox = new QVBoxLayout;
	vbox->addWidget(eventRadioButton);
	vbox->addWidget(commnameRadioButton);
	vbox->addWidget(filenameRadioButton);
	vbox->addWidget(allgroupidRadioButton);
	vbox->addWidget(effectivegroupidRadioButton);
	vbox->addWidget(groupidRadioButton);
	vbox->addWidget(helpRadioButton);
	vbox->addWidget(hostnameRadioButton);
	vbox->addWidget(keystringRadioButton);
	vbox->addWidget(nodenameRadioButton);
	vbox->addWidget(objectRadioButton);
	vbox->addWidget(inputRadioButton);
	vbox->addWidget(processidRadioButton);
	vbox->addWidget(syscallRadioButton);

	optionButtonGroupBox->setLayout(vbox);

	return optionButtonGroupBox;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Ausearch::ausearch_button_clicked()
{
        if(eventRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch -a " + ausearchEditLineEdit_str;
	}
        if(commnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --comm " + ausearchEditLineEdit_str;
	}
        if(filenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --file " + ausearchEditLineEdit_str;
	}
        if(allgroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-all " + ausearchEditLineEdit_str;
	}
        if(effectivegroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-effective " + ausearchEditLineEdit_str;
	}
        if(groupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid " + ausearchEditLineEdit_str;
	}
        if(helpRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --help";
	}
        if(hostnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --host " + ausearchEditLineEdit_str;
	}
        if(keystringRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --key " + ausearchEditLineEdit_str;
	}
        if(nodenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --node " + ausearchEditLineEdit_str;
	}
        if(objectRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --object " + ausearchEditLineEdit_str;
	}
        if(inputRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --input " + ausearchEditLineEdit_str;
	}
        if(processidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --pid " + ausearchEditLineEdit_str;
	}
        if(syscallRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --syscall " + ausearchEditLineEdit_str;
	}

	//for checkbox
        if(interpretCheckBox->isChecked()){
                ausearch_str_pp_str = ausearch_str_pp_str + " -i";
	}
	//set start-day and start-time
	startdayEditLineEdit_str = startdayEditLineEdit->text();
	starttimeEditLineEdit_str = starttimeEditLineEdit->text();
        if(startdayEditLineEdit_str != ""){
		ausearch_str_pp_str = ausearch_str_pp_str + " --start " + startdayEditLineEdit_str + " " + starttimeEditLineEdit_str;
	}
	//set end-day and end-time
	enddayEditLineEdit_str = enddayEditLineEdit->text();
	endtimeEditLineEdit_str = endtimeEditLineEdit->text();
        if(enddayEditLineEdit_str != ""){
		ausearch_str_pp_str = ausearch_str_pp_str + " --end " + enddayEditLineEdit_str + " " + endtimeEditLineEdit_str;
	}

	ausearch_process_o = new AusearchProcess(ausearch_str_pp_str,this);
	connect(closeButton, SIGNAL(clicked()), ausearch_process_o, SLOT(close()));

	ausearch_process_o->setCaption(tr(ausearch_str_pp_str));
	ausearch_process_o->show();
	ausearch_process_o->raise();
	ausearch_process_o->setActiveWindow();

}
