/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QLineEdit>
#include <QPushButton>
#include <QRadioButton>
#include <QTextEdit>
#include <QMessageBox>
#include <Q3TextStream>
#include <fstream>

#include "breakte.h"

#include <iostream>
using namespace std;

// constructor
BreakTe::BreakTe(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("break .te files"));
		textEdit1 = new QTextEdit(this);
		textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
		closeButton = new QPushButton(tr("&Close"), this);
		breakteButton = new QPushButton(tr("break .te files"), this);
		breakteButton->setPaletteBackgroundColor(QColor(255, 155, 155));
		breakteButton->setDefault(true);

		connect(breakteButton, SIGNAL(clicked()), this, SLOT(breakte_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		firstLayout = new QVBoxLayout;
		leftLayout = new QHBoxLayout;

		rightLayout = new QVBoxLayout;
		rightLayout->addWidget(breakteButton);
		rightLayout->addWidget(closeButton);

		firstLayout->addLayout(leftLayout);
		firstLayout->addWidget(textEdit1);

		mainLayout = new QHBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(firstLayout);
		mainLayout->addLayout(rightLayout);

		resize(1000,600);
}
void BreakTe::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		textEdit1->append(tr("breakte  process ended !"));
		textEdit1->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}
void BreakTe::breakte_clicked()
{
		breakte_base_process();
}
////////////////////////////////////////////
void BreakTe::readFromStdout()
{
        QByteArray data = process->readAllStandardOutput();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void BreakTe::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void BreakTe::breakte_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);

	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	process->start("/bin/bash", QStringList() << "-c" << "export LANG=C;/usr/share/segatex/raw_te_files/breakte.sh");
}
