/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>

#include "downloader_process.h"

#include <iostream>
using namespace std;

DownloaderProcess::DownloaderProcess(QUrl &url_for_fedora, QString version,QWidget *parent, const char *name): QDialog(parent, name)
{

        QString url_for_fedora_str=url_for_fedora; 

	setCaption(tr("Fedora Downloader Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,255,185));
	textEdit1->setText(tr("Download iso from " + url_for_fedora_str + " in your home directory."));
	textEdit1->append(tr("It will take a while please wait..."));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(300,200);

	downloader_base_process(url_for_fedora,version);
}
void DownloaderProcess::downloader_base_process(QUrl& url_for_fedora, QString version)
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
        QString url_str = "/usr/share/segatex/downloader_program " + url_for_fedora + " " + version;
    	//process->start("/bin/bash", QStringList() << "-c" << "export LANG=C;ls -la");
	process->start(url_str);
	//process->start("/bin/bash", QStringList() << "-c" << "export LANG=C;" + url_str);
}

void DownloaderProcess::close_button_clicked()
{
	emit downloader_process_close_button_clicked();

}
void DownloaderProcess::readFromStdout()
{
	QByteArray data = process->readAllStandardOutput();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void DownloaderProcess::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void DownloaderProcess::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		textEdit1->append(tr("Fedora downloader process ended!"));
		textEdit1->append(tr("\n"));
		textEdit1->append(tr("Please check iso and CHECKSUM file."));
		textEdit1->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}

