/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QLineEdit>
#include <QPushButton>
#include <QRadioButton>
#include <QTextEdit>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
//#####################
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>

#include "segatex_audit2allow.h"
#include "segatex_audit2allow_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexAudit2allow::SegatexAudit2allow(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("audit2allow"));
		readfromLabel = new QLabel(tr("Read from:"), this );
		writetoLabel = new QLabel(tr("Write to:"), this );
		optionLabel = new QLabel(tr("Other options:"), this );
		auditlogCheckBox = new QCheckBox(tr("/var/log/audit/audit.log"), this);
		messagesCheckBox = new QCheckBox(tr("/var/log/messages"), this);
		lastreloadCheckBox = new QCheckBox(tr("read input only after the last reload"), this);
		referenceCheckBox = new QCheckBox(tr("generate refpolicy style output"), this);
		verboseCheckBox = new QCheckBox(tr("explain genetated output"), this);
		explainCheckBox = new QCheckBox(tr("fully explain genetated output"), this);
		auditlogCheckBox->setChecked(true);
		moduleNameLabel = new QLabel(tr("Module Name( alphabet and numbers only \"_\" can't be used):"), this );
		moduleNameLineEdit = new QLineEdit( this );
		grepLabel = new QLabel(tr("grep(select either file)"), this );
		grepLineEdit = new QLineEdit( this );
		writetoLineEdit = new QLineEdit( this );
		moduleNameLineEdit->setText("local");
		writetoLineEdit->setText("local.te");
		audit2allowButton = new QPushButton(tr("&audit2allow"), this);
		audit2allowButton->setPaletteBackgroundColor(QColor(155, 155, 255));
		closeButton = new QPushButton(tr("&Close"), this);
		audit2allowButton->setDefault(true);

		connect(audit2allowButton, SIGNAL(clicked()), this, SLOT(audit2allow_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		leftLayout = new QVBoxLayout;
		leftLayout->addWidget(readfromLabel);
		leftLayout->addWidget(auditlogCheckBox);
		leftLayout->addWidget(messagesCheckBox);
		leftLayout->addWidget(writetoLabel);
		leftLayout->addWidget(writetoLineEdit);
		leftLayout->addWidget(moduleNameLabel);
		leftLayout->addWidget(moduleNameLineEdit);
		leftLayout->addWidget(grepLabel);
		leftLayout->addWidget(grepLineEdit);
		leftLayout->addWidget(optionLabel);
		leftLayout->addWidget(lastreloadCheckBox);
		leftLayout->addWidget(referenceCheckBox);
		leftLayout->addWidget(verboseCheckBox);
		leftLayout->addWidget(explainCheckBox);

		rightLayout = new QVBoxLayout;
		rightLayout->addWidget(audit2allowButton);
		rightLayout->addStretch(2);
		rightLayout->addWidget(closeButton);

		mainLayout = new QHBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(leftLayout);
		mainLayout->addLayout(rightLayout);
		//needs here to be declared for window newly opened unless segmentation fault occurs
		segatex_audit2allow_process = 0;
}
/*connects signal to close this window when process window's close button is clicked*/
void SegatexAudit2allow::audit2allow_clicked()
{
		//-l -R -v -e //1111
		//-l -R -v//1110
		//-l -R -e//1101
		//-l -R//1100
		//-l -v -e//1011
		//-l -v//1010
		//-l -e//1001	
		//-l//1000
		//-R -v -e//111
		//-R -v//110
		//-R -e//101
		//-R//100
		//-v -e//11
		//-v//10
		//-e//1
		//no_option//0
		moduleName_str = moduleNameLineEdit->text();
		outputfile_str = writetoLineEdit->text();
		moduleName_str_caption = "module " + moduleName_str + " 1.0";
		segatex_audit2allow_process = new SegatexAudit2allowProcess(this);
		connect(closeButton, SIGNAL(clicked()), segatex_audit2allow_process, SLOT(close()));
		segatex_audit2allow_process->setCaption(tr(moduleName_str_caption));
		segatex_audit2allow_process->show();
		segatex_audit2allow_process->raise();
		segatex_audit2allow_process->setActiveWindow();

	if(auditlogCheckBox->isOn()){
		if(messagesCheckBox->isOn()){
			log_file=3;
		}else{
			log_file=2;
		}
	}else{
		if(messagesCheckBox->isOn()){
			log_file=1;
		}else{
			//maybe popupmessage is needed something like "you should check either one."
		}
	}
	grepLineEdit_str = grepLineEdit->text();
	if(lastreloadCheckBox->isOn()){
		if(referenceCheckBox->isOn()){
			if(verboseCheckBox->isOn()){
				if(explainCheckBox->isOn()){
					//-l -R -v -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1111,moduleName_str,grepLineEdit_str);
				}else{
					//-l -R -v
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1110,moduleName_str,grepLineEdit_str);
				}
			}else{
				if(explainCheckBox->isOn()){
					//-l -R -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1101,moduleName_str,grepLineEdit_str);
				}else{
					//-l -R
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1100,moduleName_str,grepLineEdit_str);
				}	
			}
		}else{
			if(verboseCheckBox->isOn()){
				if(explainCheckBox->isOn()){
					//-l -v -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1011,moduleName_str,grepLineEdit_str);
				}else{
					//-l -v
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1010,moduleName_str,grepLineEdit_str);
				}
			}else{
				if(explainCheckBox->isOn()){
					//-l -e	
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1001,moduleName_str,grepLineEdit_str);
				}else{
					//-l
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1000,moduleName_str,grepLineEdit_str);
				}
			}
		}
	}else{
		if(referenceCheckBox->isOn()){
			if(verboseCheckBox->isOn()){
				if(explainCheckBox->isOn()){
					//-R -v -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,111,moduleName_str,grepLineEdit_str);
				}else{
					//-R -v
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,110,moduleName_str,grepLineEdit_str);
				}
			}else{
				if(explainCheckBox->isOn()){
					//-R -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,101,moduleName_str,grepLineEdit_str);
				}else{
					//-R
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,100,moduleName_str,grepLineEdit_str);
				}	
			}
		}else{
			if(verboseCheckBox->isOn()){
				if(explainCheckBox->isOn()){
					//-v -e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,11,moduleName_str,grepLineEdit_str);
				}else{
					//-v
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,10,moduleName_str,grepLineEdit_str);
				}
			}else{
				if(explainCheckBox->isOn()){
					//-e
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,1,moduleName_str,grepLineEdit_str);
				}else{
					//no_option
					segatex_audit2allow_process->audit2allow_base_process(log_file,outputfile_str,0,moduleName_str,grepLineEdit_str);
				}	
			}
		}
	}
}
/*unused*/
unsigned long  SegatexAudit2allow::getuid_uid_value()
{
	struct passwd *passwd; /* man getpwuid */
	unsigned long uid_value;
	passwd = getpwuid ( getuid()); /* Get the uid of the running processand use it to get a record from /etc/passwd */
	uid_value = (unsigned long) getpwuid(getuid())->pw_uid;
	/*
	printf("\n The Real User Name is %s ", passwd->pw_gecos);
        connect (selinux_audit2allow, SIGNAL(explainChecked()), this, SLOT(setX()));

	printf("\n The Login Name is %s ", passwd->pw_name);
	printf("\n The Home Directory is %s", passwd->pw_dir);
	printf("\n The Login Shell is %s ", passwd->pw_shell);
	printf("\n The Passwd is %s ", getpwuid(getuid()) >pw_passwd);
	printf("\n The uid is %lu ", (unsigned long) getpwuid(getuid())->pw_uid);
	printf("\n The gid is %lu \n\n", (unsigned long) getpwuid(getuid())->pw_gid);
	*/
	//cout << "getuid_uid_value" << uid_value << endl;

	return uid_value;
}
