/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QPushButton>
#include <QTextStream>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "seinfo_process.h"

#include <iostream>
using namespace std;

SeinfoProcess::SeinfoProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Seinfo Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));
        textEdit1->resize( 600, 100 );

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QVBoxLayout(this);
	upperLayout = new QVBoxLayout;
	footLayout = new QHBoxLayout;
	
	mainLayout->setMargin(11);
	upperLayout->addWidget(textEdit1);

	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,600);
}

void SeinfoProcess::seinfo_base_process(QString seinfo_str_pp_str)
{
        #define PWD_BUF 8600
        const char* seinfo_list_file="/usr/share/segatex/seinfo/seinfo";
        ofstream os;
        os.open(seinfo_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen(seinfo_str_pp_str, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	readFromOutputFile(seinfo_str_pp_str);
}

//this slot should be called from above slot
void SeinfoProcess::readFromOutputFile(QString seinfo_str_pp_str)
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex/seinfo";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*seinfo");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					seinfo_str_pp_str_echo = "################  " +seinfo_str_pp_str + "  #################";
                                        textEdit1->append(seinfo_str_pp_str_echo);
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				//textEdit1->setCursorPosition(0,0);
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
