/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QTextEdit>
#include <QLayout>
#include <QRadioButton>
#include <QMessageBox>
#include <QPushButton>
#include <QButtonGroup>
#include <QTextEdit>
#include <QTextStream>

#include "semodule_dontaudit.h"
#include "semodule_dontaudit_process.h"
#include "mainwindow.h"

//#include <iostream>
//using namespace std;

//default constructor
SemoduleDontaudit::SemoduleDontaudit(QWidget *parent, const char *name)
	: QDialog(parent, name)
{
	date_time_obj =new QDateTime;
	currentDateTime = date_time_obj->currentDateTime();
	currentDateTime_str = currentDateTime.toString();
	date_time_str = "system date time:" + currentDateTime_str;

	//first check whether or not dontaudit is enabled
	semodule_dontaudit_base_process();
	//end first check whether or not dontaudit is enabled

	//datetimeLabel = new QLabel(tr(date_time_str), this );
	dontauditButton = new QPushButton(tr("&Apply"), this);
	closeButton = new QPushButton(tr("&Close"), this);
	dontauditButton->setDefault(true);

	connect(dontauditButton, SIGNAL(clicked()), this, SLOT(dontaudit_clicked()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

	leftLayout = new QVBoxLayout;
	leftLayout->addWidget(createFirstExclusiveGroup());
	dontauditLabel = new QLabel(tr(dontaudit_present_state_str), this );

	leftLayout->addWidget(dontauditLabel);

	rightLayout = new QVBoxLayout;
	rightLayout->addWidget(dontauditButton);
	rightLayout->addWidget(closeButton);
	rightLayout->addStretch(1);

		mainLayout = new QHBoxLayout(this);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);
        setLayout(mainLayout);
        setWindowTitle(tr("dontaudit"));
	semodule_dontaudit_process = 0;
}
void SemoduleDontaudit::dontaudit_clicked()
{
	//std::cout << "dontaudit button is clicked !" << endl;

	if(auditAllRadioButton->isOn())
		semodule_dontaudit_common_int = 0;
	if(dontauditSomeRadioButton->isOn())
		semodule_dontaudit_common_int = 1;
	semodule_dontaudit_process = new SemoduleDontauditProcess(this,"",semodule_dontaudit_common_int);
	connect(semodule_dontaudit_process, SIGNAL(semodule_dontaudit_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), semodule_dontaudit_process, SLOT(close()));
	semodule_dontaudit_process->show();
	semodule_dontaudit_process->raise();
	semodule_dontaudit_process->setActiveWindow();
}
////////////////////////////////////////////
void SemoduleDontaudit::readFromStdout()
{
        QByteArray data = process->readAllStandardOutput();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void SemoduleDontaudit::processExited()
{
	if(process->exitStatus()==0){
		
		//for test to echo rightly
		semodule_dontaudit_base_process();
		y = readFromOutputFile_and_return_str();
		//end for test to echo rightly
		
	} else {
		textEdit1->append(tr("dontauditprocess had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void SemoduleDontaudit::semodule_dontaudit_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);
	y = readFromOutputFile_and_return_str();
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start("/usr/share/segatex/DONTAUDIT_STATE");
}

int SemoduleDontaudit::readFromOutputFile_and_return_str()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("dontaudit_state");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	while(it_d != files.end()){
		name = *it_d;
		file_interface_name = dir_name + forward_slash + name;
		QFile file( file_interface_name );
		if ( file.open( QIODevice::ReadOnly ) ) {
			QTextStream stream( &file );
			////////////////////////////////////////////
			check_int = 0;
			int lines = 1;
			while ( !stream.atEnd() ) {
				if(lines > 1)
					break;
				line_analized = stream.readLine(); // line of text excluding '\n'
				// test//
				// there should be cast from QString to int here
				/*
				if(line_analized == check_int){
					y = 0;
				}else{
					y = 1;
				}
				*/
				if(line_analized == "0"){
					y = 0;
				/*
				}else if(line_analized == "86423"){
					y = 1;
				*/
				}else{
					y = 1;
				}
				// end test//
				////////////textEdit1->append(line_analized);
				lines++;
			}
			file.close();
			++it_d;
		}else{
			//do nothing
		}
	}
/*
	int x = QString::compare("O", line_analized , Qt::CaseInsensitive); 
	int r = 0;
	if(x == r){
		y = 0;
	}else{
		y = 1;
	}
*/
	//std::cout << "line_analized is now" << line_analized << endl;
	//std::cout << "y is " << y << "!" << endl;
	return y;
}
QGroupBox *SemoduleDontaudit::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("select dontaudit state"));
	auditAllRadioButton = new QRadioButton(tr("Disable dontaudit"));

	dontauditSomeRadioButton = new QRadioButton(tr("Enable Dontaudit"));

	vbox = new QVBoxLayout;
        vbox->addWidget(auditAllRadioButton);
        vbox->addWidget(dontauditSomeRadioButton);

	if(y == 0){
		auditAllRadioButton->setChecked(true);
		dontaudit_present_state_str = "dontaudit is disabled(logs everything)";
	}else if(y == 1){
		dontauditSomeRadioButton->setChecked(true);
		dontaudit_present_state_str = "dontaudit is enabled(nomarl log)";
	}
	optionButtonGroupBox->setLayout(vbox);

	return optionButtonGroupBox;
}
