/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import net.jsunit.ArgumentsConfiguration;
import net.jsunit.ConfigurationException;
import net.jsunit.EnvironmentVariablesConfiguration;
import net.jsunit.JsUnitServer;
import net.jsunit.PropertiesFileConfiguration;
import net.jsunit.Utility;

public abstract class Configuration {
    public static final String PORT = "port";
    public static final String RESOURCE_BASE = "resourceBase";
    public static final String LOGS_DIRECTORY = "logsDirectory";
    public static final String URL = "url";
    public static final String BROWSER_FILE_NAMES = "browserFileNames";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_RESOURCE_BASE = ".";

    public static Configuration resolve(String[] stringArray) {
        if (stringArray.length > 0) {
            return new ArgumentsConfiguration(Arrays.asList(stringArray));
        }
        EnvironmentVariablesConfiguration environmentVariablesConfiguration = new EnvironmentVariablesConfiguration();
        if (environmentVariablesConfiguration.isAppropriate()) {
            return environmentVariablesConfiguration;
        }
        return new PropertiesFileConfiguration();
    }

    public void configure(JsUnitServer jsUnitServer) throws ConfigurationException {
        this.initialize();
        this.configureResourceBase(jsUnitServer);
        this.configurePort(jsUnitServer);
        this.configureLogsDirectory(jsUnitServer);
        this.configureBrowserFileNames(jsUnitServer);
        this.configureTestURL(jsUnitServer);
    }

    public void initialize() {
    }

    private void configureTestURL(JsUnitServer jsUnitServer) throws ConfigurationException {
        String string = this.url();
        try {
            jsUnitServer.setTestURL(new URL(string));
        }
        catch (Exception exception) {
            throw new ConfigurationException(URL, string, exception);
        }
    }

    private void configureBrowserFileNames(JsUnitServer jsUnitServer) throws ConfigurationException {
        String string = this.browserFileNames();
        try {
            List list = Utility.listFromCommaDelimitedString(string);
            jsUnitServer.setLocalBrowserFileNames(list);
        }
        catch (Exception exception) {
            throw new ConfigurationException(BROWSER_FILE_NAMES, string, exception);
        }
    }

    private void configureLogsDirectory(JsUnitServer jsUnitServer) throws ConfigurationException {
        String string = this.logsDirectory();
        try {
            File file;
            if (Utility.isEmpty(string)) {
                string = this.resourceBaseCheckForDefault() + File.separator + "logs";
            }
            if (!(file = new File(string)).exists()) {
                Utility.log("Creating logs directory " + file, false);
                file.mkdir();
            }
            jsUnitServer.setLogsDirectory(file);
        }
        catch (Exception exception) {
            throw new ConfigurationException(LOGS_DIRECTORY, string, exception);
        }
    }

    private void configurePort(JsUnitServer jsUnitServer) throws ConfigurationException {
        String string = this.port();
        try {
            int n = 0;
            n = Utility.isEmpty(string) ? 8080 : Integer.parseInt(string);
            jsUnitServer.setPort(n);
        }
        catch (Exception exception) {
            throw new ConfigurationException(PORT, string, exception);
        }
    }

    private void configureResourceBase(JsUnitServer jsUnitServer) throws ConfigurationException {
        String string = this.resourceBaseCheckForDefault();
        try {
            jsUnitServer.setResourceBase(new File(string));
        }
        catch (Exception exception) {
            throw new ConfigurationException(RESOURCE_BASE, string, exception);
        }
    }

    private String resourceBaseCheckForDefault() {
        String string = this.resourceBase();
        if (Utility.isEmpty(string)) {
            string = DEFAULT_RESOURCE_BASE;
        }
        return string;
    }

    public abstract String resourceBase();

    public abstract String port();

    public abstract String logsDirectory();

    public abstract String browserFileNames();

    public abstract String url();
}

