/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.JsUnitServer;
import net.jsunit.TestSuiteResult;
import net.jsunit.Utility;

public class StandaloneTest
extends TestCase {
    private boolean needToStopServer = false;
    public static final int MAX_SECONDS_TO_WAIT = 120;
    private JsUnitServer server;
    private Process process;

    public StandaloneTest(String string) {
        super(string);
    }

    public void setServer(JsUnitServer jsUnitServer) {
        this.server = jsUnitServer;
    }

    public void setUp() throws Exception {
        super.setUp();
        if (this.server == null) {
            this.server = new JsUnitServer();
            this.server.initialize();
            this.server.start();
            this.needToStopServer = true;
        }
    }

    public void tearDown() throws Exception {
        if (this.needToStopServer) {
            this.server.stop();
        }
        if (this.process != null) {
            this.process.destroy();
        }
        super.tearDown();
    }

    public void testStandaloneRun() throws Exception {
        Iterator iterator = this.server.getLocalBrowserFileNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = this.server.resultsCount();
            this.launchBrowser(string);
            this.waitForResultToBeSubmitted(string, n);
            this.process.destroy();
            this.verifyLastResult();
        }
    }

    private void launchBrowser(String string) {
        Utility.log("StandaloneTest: launching " + string);
        try {
            this.process = Runtime.getRuntime().exec(new String[]{string, this.server.getTestURL().toString()});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)("All browser processes should start, but the following did not: " + string));
        }
    }

    private void waitForResultToBeSubmitted(String string, int n) throws Exception {
        Utility.log("StandaloneTest: waiting for " + string + " to submit result");
        long l = 0L;
        while (this.server.getResults().size() == n) {
            Thread.sleep(1000L);
            if (++l <= 120L) continue;
            Assert.fail((String)("Waited more than 120 seconds for browser " + string));
        }
    }

    private void verifyLastResult() {
        TestSuiteResult testSuiteResult = this.server.lastResult();
        if (!testSuiteResult.hadSuccess()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Result with ID ");
            stringBuffer.append(testSuiteResult.getId());
            stringBuffer.append(" had problems: ");
            stringBuffer.append(testSuiteResult.errorCount() + " errors, ");
            stringBuffer.append(testSuiteResult.failureCount() + " failures ");
            Assert.fail((String)stringBuffer.toString());
        }
    }
}

