/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.jsunit.TestCaseResultBuilder;
import net.jsunit.TestCaseResultWriter;
import org.jdom.Element;

public class TestCaseResult {
    public static final String DELIMITER = "|";
    public static final String ERROR_INDICATOR = "E";
    public static final String FAILURE_INDICATOR = "F";
    private String name;
    private double time;
    private String failure;
    private String error;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String string) {
        this.error = string;
    }

    public String getFailure() {
        return this.failure;
    }

    public void setFailure(String string) {
        this.failure = string;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public boolean hadError() {
        return this.error != null;
    }

    public boolean hadFailure() {
        return this.failure != null;
    }

    public boolean hadSuccess() {
        return !this.hadError() && !this.hadFailure();
    }

    public static TestCaseResult fromString(String string) {
        TestCaseResult testCaseResult = new TestCaseResult();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        try {
            testCaseResult.setName(stringTokenizer.nextToken());
            testCaseResult.setTime(Double.parseDouble(stringTokenizer.nextToken()));
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(ERROR_INDICATOR)) {
                testCaseResult.setError(stringTokenizer.nextToken());
            } else if (string2.equals(FAILURE_INDICATOR)) {
                testCaseResult.setFailure(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            testCaseResult.setError("Incomplete test result: '" + string + "'.");
        }
        return testCaseResult;
    }

    public static TestCaseResult fromXmlElement(Element element) {
        return new TestCaseResultBuilder().build(element);
    }

    public String writeXmlFragment() {
        return new TestCaseResultWriter(this).writeXmlFragment();
    }

    public String writeProblemSummary() {
        return new TestCaseResultWriter(this).writeProblemSummary();
    }
}

