/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.jsunit.TestCaseResult;
import net.jsunit.TestSuiteResultBuilder;
import net.jsunit.TestSuiteResultWriter;
import net.jsunit.Utility;

public class TestSuiteResult {
    private String remoteAddress;
    private String id;
    private String jsUnitVersion;
    private String userAgent;
    private String baseURL;
    private List testCaseResults = new ArrayList();
    private double time;
    private String SEPARATOR = "---------------------";
    private File logsDirectory;

    public TestSuiteResult(File file) {
        this.id = String.valueOf(System.currentTimeMillis());
        this.logsDirectory = file;
    }

    public static File logFileForId(File file, String string) {
        return new File(file + File.separator + string + ".xml");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        if (string != null) {
            this.id = string;
        }
    }

    public boolean hasId(String string) {
        return this.id.equals(string);
    }

    public String getJsUnitVersion() {
        return this.jsUnitVersion;
    }

    public void setJsUnitVersion(String string) {
        this.jsUnitVersion = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public List getTestCaseResults() {
        return this.testCaseResults;
    }

    public void setTestCaseStrings(String[] stringArray) {
        this.buildTestCaseResults(stringArray);
    }

    public static TestSuiteResult fromRequest(HttpServletRequest httpServletRequest, File file) {
        TestSuiteResult testSuiteResult = new TestSuiteResult(file);
        String string = httpServletRequest.getParameter("id");
        if (!Utility.isEmpty(string)) {
            testSuiteResult.setId(string);
        }
        testSuiteResult.setRemoteAddress(httpServletRequest.getRemoteAddr());
        testSuiteResult.setUserAgent(httpServletRequest.getParameter("userAgent"));
        testSuiteResult.setBaseURL(httpServletRequest.getParameter("baseURL"));
        String string2 = httpServletRequest.getParameter("time");
        if (!Utility.isEmpty(string2)) {
            testSuiteResult.setTime(Double.parseDouble(string2));
        }
        testSuiteResult.setJsUnitVersion(httpServletRequest.getParameter("JsUnitVersion"));
        testSuiteResult.setTestCaseStrings(httpServletRequest.getParameterValues("testCases"));
        return testSuiteResult;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String string) {
        this.remoteAddress = string;
    }

    private void buildTestCaseResults(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.testCaseResults.add(TestCaseResult.fromString(stringArray[i]));
        }
    }

    public static TestSuiteResult findResultWithIdInResultLogs(File file, String string) {
        File file2 = TestSuiteResult.logFileForId(file, string);
        if (file2.exists()) {
            return TestSuiteResult.fromXmlFile(file2);
        }
        return null;
    }

    public int errorCount() {
        int n = 0;
        Iterator iterator = this.testCaseResults.iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            if (!testCaseResult.hadError()) continue;
            ++n;
        }
        return n;
    }

    public int failureCount() {
        int n = 0;
        Iterator iterator = this.testCaseResults.iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            if (!testCaseResult.hadFailure()) continue;
            ++n;
        }
        return n;
    }

    public int count() {
        return this.testCaseResults.size();
    }

    public String writeXml() {
        return new TestSuiteResultWriter(this).writeXml();
    }

    public String writeXmlFragment() {
        return new TestSuiteResultWriter(this).writeXmlFragment();
    }

    public void writeLog() {
        this.writeXmlToFile();
        this.logProblems();
    }

    private void logProblems() {
        String string = new TestSuiteResultWriter(this).writeProblems();
        if (!Utility.isEmpty(string)) {
            Utility.log("Problems:");
            Utility.log(this.SEPARATOR, false);
            Utility.log(string, false);
            Utility.log(this.SEPARATOR, false);
        }
    }

    private void writeXmlToFile() {
        String string = this.writeXml();
        Utility.writeFile(string, TestSuiteResult.logFileForId(this.logsDirectory, this.getId()));
    }

    public boolean hadSuccess() {
        Iterator iterator = this.testCaseResults.iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            if (testCaseResult.hadSuccess()) continue;
            return false;
        }
        return true;
    }

    public static TestSuiteResult fromXmlFile(File file) {
        return new TestSuiteResultBuilder(file.getParentFile()).build(file);
    }

    public void addTestCaseResult(TestCaseResult testCaseResult) {
        this.testCaseResults.add(testCaseResult);
    }
}

