/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.jsunit.TestCaseResultBuilder;
import net.jsunit.TestSuiteResult;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TestSuiteResultBuilder {
    private File logsDirectory;

    public TestSuiteResultBuilder(File file) {
        this.logsDirectory = file;
    }

    public TestSuiteResult build(File file) {
        try {
            Document document = new SAXBuilder().build(file);
            return this.build(document);
        }
        catch (Exception exception) {
            System.err.println("Failed to read file " + file + ": " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public TestSuiteResult build(Document document) {
        TestSuiteResult testSuiteResult = new TestSuiteResult(this.logsDirectory);
        Element element = document.getRootElement();
        this.updateWithHeaders(testSuiteResult, element);
        this.updateWithProperties(element.getChild("properties"), testSuiteResult);
        this.updateWithTestCaseResults(element.getChildren("testcase"), testSuiteResult);
        return testSuiteResult;
    }

    private void updateWithHeaders(TestSuiteResult testSuiteResult, Element element) {
        String string = element.getAttributeValue("id");
        double d = Double.parseDouble(element.getAttributeValue("time"));
        testSuiteResult.setId(string);
        testSuiteResult.setTime(d);
    }

    private void updateWithProperties(Element element, TestSuiteResult testSuiteResult) {
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if ("JsUnitVersion".equals(element2.getAttributeValue("name"))) {
                testSuiteResult.setJsUnitVersion(element2.getAttributeValue("value"));
                continue;
            }
            if ("userAgent".equals(element2.getAttributeValue("name"))) {
                testSuiteResult.setUserAgent(element2.getAttributeValue("value"));
                continue;
            }
            if ("remoteAddress".equals(element2.getAttributeValue("name"))) {
                testSuiteResult.setRemoteAddress(element2.getAttributeValue("value"));
                continue;
            }
            if (!"baseURL".equals(element2.getAttributeValue("name"))) continue;
            testSuiteResult.setBaseURL(element2.getAttributeValue("value"));
        }
    }

    private void updateWithTestCaseResults(List list, TestSuiteResult testSuiteResult) {
        TestCaseResultBuilder testCaseResultBuilder = new TestCaseResultBuilder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            testSuiteResult.addTestCaseResult(testCaseResultBuilder.build(element));
        }
    }
}

