/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.textui.TestRunner;
import net.jsunit.StandaloneTest;
import net.jsunit.Utility;
import net.jsunit.servlet.JsUnitServlet;

public class TestRunnerServlet
extends JsUnitServlet {
    protected synchronized void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Utility.log("TestRunnerServlet: Received request to run standalone test...");
        StandaloneTest standaloneTest = this.createTest();
        TestResult testResult = TestRunner.run((Test)standaloneTest);
        this.writeResponse(httpServletResponse, testResult);
        Utility.log("TestRunnerServlet: ...Done");
    }

    protected void writeResponse(HttpServletResponse httpServletResponse, TestResult testResult) throws IOException {
        httpServletResponse.setContentType("text/xml");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String string = testResult.wasSuccessful() ? "success" : "failure";
        servletOutputStream.write(("<result>" + string + "</result>").getBytes());
        servletOutputStream.close();
    }

    protected StandaloneTest createTest() {
        StandaloneTest standaloneTest = new StandaloneTest("testStandaloneRun");
        standaloneTest.setServer(JsUnitServlet.server);
        return standaloneTest;
    }
}

