/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.test;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.ArgumentsConfiguration;
import net.jsunit.JsUnitServer;
import net.jsunit.Utility;

public class ArgumentsConfigurationTest
extends TestCase {
    public ArgumentsConfigurationTest(String string) {
        super(string);
    }

    public void testSimple() throws Exception {
        List<String> list = Arrays.asList("-port", "12345", "-url", "http://www.jsunit.net/", "-resourceBase", "foo", "-logsDirectory", "bar", "-remoteMachineNames", "foo,bar", "-browserFileNames", "fu,bar");
        JsUnitServer jsUnitServer = new JsUnitServer();
        ArgumentsConfiguration argumentsConfiguration = new ArgumentsConfiguration(list);
        argumentsConfiguration.configure(jsUnitServer);
        Assert.assertEquals((int)12345, (int)jsUnitServer.getPort());
        Assert.assertEquals((Object)new File("foo"), (Object)jsUnitServer.getResourceBase());
        Assert.assertEquals((Object)new File("bar"), (Object)jsUnitServer.getLogsDirectory());
        Assert.assertEquals((Object)Utility.listWith("fu", "bar"), (Object)jsUnitServer.getLocalBrowserFileNames());
        Assert.assertEquals((String)"http://www.jsunit.net/", (String)jsUnitServer.getTestURL().toString());
    }

    public void tearDown() throws Exception {
        File file = new File("bar");
        if (file.exists()) {
            file.delete();
        }
        super.tearDown();
    }
}

