/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.TestCaseResult;
import net.jsunit.TestCaseResultWriter;
import org.jdom.Element;

public class TestCaseResultTest
extends TestCase {
    public TestCaseResultTest(String string) {
        super(string);
    }

    public void testBuildSuccessfulResultFromString() {
        TestCaseResult testCaseResult = TestCaseResult.fromString("file:///dummy/path/dummyPage.html:testFoo|1.3|S||");
        Assert.assertEquals((String)"file:///dummy/path/dummyPage.html:testFoo", (String)testCaseResult.getName());
        Assert.assertEquals((double)1.3, (double)testCaseResult.getTime(), (double)0.001);
        Assert.assertFalse((boolean)testCaseResult.hadError());
        Assert.assertFalse((boolean)testCaseResult.hadFailure());
        Assert.assertTrue((boolean)testCaseResult.hadSuccess());
        Assert.assertNull((Object)testCaseResult.getError());
        Assert.assertNull((Object)testCaseResult.getFailure());
        Assert.assertEquals((String)"<testcase name=\"file:///dummy/path/dummyPage.html:testFoo\" time=\"1.3\" />", (String)testCaseResult.writeXmlFragment());
    }

    public void testProblemSummary() {
        TestCaseResult testCaseResult = TestCaseResult.fromString("file:///dummy/path/dummyPage.html:testFoo|1.3|E|Test Error Message|");
        Assert.assertEquals((String)"file:///dummy/path/dummyPage.html:testFoo had an error:\nTest Error Message", (String)testCaseResult.writeProblemSummary());
    }

    public void testBuildErrorResultFromString() {
        TestCaseResult testCaseResult = TestCaseResult.fromString("file:///dummy/path/dummyPage.html:testFoo|1.3|E|Test Error Message|");
        Assert.assertEquals((String)"file:///dummy/path/dummyPage.html:testFoo", (String)testCaseResult.getName());
        Assert.assertEquals((double)1.3, (double)testCaseResult.getTime(), (double)0.001);
        Assert.assertTrue((boolean)testCaseResult.hadError());
        Assert.assertFalse((boolean)testCaseResult.hadFailure());
        Assert.assertFalse((boolean)testCaseResult.hadSuccess());
        Assert.assertEquals((String)"Test Error Message", (String)testCaseResult.getError());
        Assert.assertNull((Object)testCaseResult.getFailure());
        Assert.assertEquals((String)"<testcase name=\"file:///dummy/path/dummyPage.html:testFoo\" time=\"1.3\"><error message=\"Test Error Message\" /></testcase>", (String)testCaseResult.writeXmlFragment());
    }

    public void testBuildFailureResultFromString() {
        TestCaseResult testCaseResult = TestCaseResult.fromString("file:///dummy/path/dummyPage.html:testFoo|1.3|F|Test Failure Message|");
        Assert.assertEquals((String)"file:///dummy/path/dummyPage.html:testFoo", (String)testCaseResult.getName());
        Assert.assertEquals((double)1.3, (double)testCaseResult.getTime(), (double)0.001);
        Assert.assertFalse((boolean)testCaseResult.hadError());
        Assert.assertTrue((boolean)testCaseResult.hadFailure());
        Assert.assertFalse((boolean)testCaseResult.hadSuccess());
        Assert.assertNull((Object)testCaseResult.getError());
        Assert.assertEquals((String)"Test Failure Message", (String)testCaseResult.getFailure());
        Assert.assertEquals((String)"<testcase name=\"file:///dummy/path/dummyPage.html:testFoo\" time=\"1.3\"><failure message=\"Test Failure Message\" /></testcase>", (String)testCaseResult.writeXmlFragment());
    }

    public void testBuildFromXmlFragment() {
        TestCaseResult testCaseResult = TestCaseResult.fromString("file:///dummy/path/dummyPage.html:testFoo|1.3|F|Test Failure Message|");
        Element element = new TestCaseResultWriter(testCaseResult).createTestCaseElement();
        TestCaseResult testCaseResult2 = TestCaseResult.fromXmlElement(element);
        Assert.assertEquals((String)"file:///dummy/path/dummyPage.html:testFoo", (String)testCaseResult2.getName());
        Assert.assertEquals((double)1.3, (double)testCaseResult2.getTime(), (double)0.001);
        Assert.assertFalse((boolean)testCaseResult2.hadError());
        Assert.assertTrue((boolean)testCaseResult2.hadFailure());
        Assert.assertFalse((boolean)testCaseResult2.hadSuccess());
        Assert.assertNull((Object)testCaseResult2.getError());
        Assert.assertEquals((String)"Test Failure Message", (String)testCaseResult2.getFailure());
    }
}

