#!/bin/sh

echo "Installing SELinux userland rpms"
rpm -Uvh *.rpm

echo "patching mkinitrd"
patch -d /sbin < mkinitrd.patch

echo "adding selinuxfs entry to /etc/fstab"
mkdir /selinux
echo "none /selinux selinuxfs defaults 0 0">>/etc/fstab

echo "adding load_policy to /etc/rc.d/rc.sysinit"
patch -d /etc/rc.d <rc.sysinit.patch

echo "setting default runlevel 3"
sed s/id:[0-9]:initdefault:/id:3:initdefault:/ /etc/inittab >/etc/inittab.new
cat  /etc/inittab > /etc/inittab.orig
mv -f /etc/inittab.new /etc/inittab

echo "Done. Next,you must install SELinux enabled kernel."
