#!/bin/bash
# SELinux quick install script 
# Last update Nov 10 2003
# Yoichi Hirose <yhirose@users.sourceforge.jp>
# Yuichi Nakamura <ynakam@users.sourceforge.jp>
# parts of code are quoted from ftp://people.redhat.com/dwalsh/SELinux/selUpgrade

#check if required packages are installed
rpm --quiet -q patch m4
if [ $? != 0 ]; then 
    echo "m4 and patch packages are necessary.Please install them."
    exit
fi


if [ $UID -ne 0 ]
then
    echo Please change root.
    exit 1
fi 

echo " "
echo -n "Please input system administrator (except root): "
read SYSADMNAME
echo " "
echo "2.4-based SELinux install start!!"

echo "Installing SELinux userland rpms"
cd selinux-usr
#if X is installed then move X related packages to update
rpm --quiet -q gdm
if [ $? == 0 ]; then 
    mv graphical/update/* update/
#    mv graphical/install/* install/
fi
cd install
rpm -ivh --force *.rpm
cd ..
cd update
rpm -Uvh *.rpm
cd ..
cd ..

echo "policy configuration"
sed s/jadmin/$SYSADMNAME/ /etc/security/selinux/src/policy/users > /etc/security/selinux/src/policy/users1
sed 's/user jdoe roles { user_r };//' /etc/security/selinux/src/policy/users1 > /etc/security/selinux/src/policy/users
rm -f /etc/security/selinux/src/policy/users1

sed 's/\/jadmin\//\/'$SYSADMNAME'/' /etc/security/selinux/src/policy/file_contexts/types.fc > /etc/security/selinux/src/policy/file_contexts/types1.fc
sed 's/\/jadmin/\/'$SYSADMNAME'/' /etc/security/selinux/src/policy/file_contexts/types1.fc > /etc/security/selinux/src/policy/file_contexts/types.fc
rm -f /etc/security/selinux/src/policy/file_contexts/types1.fc

sed s/jadmin/$SYSADMNAME/ /etc/security/selinux/src/policy/file_contexts/program/ssh.fc > /etc/security/selinux/src/policy/file_contexts/program/ssh1.fc
mv -f /etc/security/selinux/src/policy/file_contexts/program/ssh1.fc /etc/security/selinux/src/policy/file_contexts/program/ssh.fc

echo "patching mkinitrd"
patch -d /sbin < ./patch/mkinitrd.patch
 
echo "adding selinuxfs entry to /etc/fstab"
mkdir /selinux
echo "none /selinux selinuxfs defaults 0 0">>/etc/fstab
 
echo "adding load_policy to /etc/rc.d/rc.sysinit"
patch -d /etc/rc.d <./patch/rc.sysinit.patch

echo "setting default runlevel 3"
sed s/id:[0-9]:initdefault:/id:3:initdefault:/ /etc/inittab >/etc/inittab.new
cat  /etc/inittab > /etc/inittab.orig
mv -f /etc/inittab.new /etc/inittab

echo "Installing SELinux enabled kernel rpm"
rpm -ivh --force kernel-2.4.21-selinux2.i386.rpm

echo "Copying newrules.pl"
cp newrules.pl /usr/bin

echo "modifying grub.conf's default kernel to boot SELinux";
sed s/default=[0-9]/default=0/ /boot/grub/grub.conf > /boot/grub/grub.conf.new
cat /boot/grub/grub.conf > /boot/grub/grub.conf.orig
mv -f  /boot/grub/grub.conf.new /boot/grub/grub.conf

echo "Adding bootstrap.sh to rc.local"
echo "/tmp/bootstrap.sh" >> /etc/rc.d/rc.local

# Create bootstrap.sh
cat << __EOF >/tmp/bootstrap.sh
#!/bin/sh
#Add SE Specific start up here
(cd /etc/security/selinux/src/policy/; make load ; make  relabel)
cat /etc/rc.d/rc.local | sed -e 's!/tmp/bootstrap.sh!!g' > /etc/rc.d/rc.local.tmp
rm -f /etc/rc.d/rc.local
mv /etc/rc.d/rc.local.tmp /etc/rc.d/rc.local
chmod 0755 /etc/rc.d/rc.local
init 6
__EOF
chmod 755 /tmp/bootstrap.sh

echo " "
echo "Installation of SELinux was completed!!"
echo -n "Press return key (It reboots): "
read
/sbin/shutdown -r now
