<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * photo class
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle, shoma
 * @copyright  2006 gooooooogle, shoma
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * photo class
 *
 * This is photo class.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle, shoma
 * @copyright  2006 gooooooogle, shoma
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_photo extends Services_Hatena_base {
    private   $http;
    private   $addurl  = 'http://f.hatena.ne.jp/atom/post';
    private   $editurl = 'http://f.hatena.ne.jp/atom/edit';
    protected $parameters;

    public function Services_Hatena_photo()
    {
        $this->http = new HTTP_Request();
    }

    public function add_photo($image, $title) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $wsse = $this->getWSSEAuth();
        $based_image = base64_encode(file_get_contents($image));

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>'.$title.'</title>
<content mode="base64" type="image/jpeg">'.$based_image.'</content>
</entry>';

        $this->setHeader(HTTP_REQUEST_METHOD_POST, $this->addurl);
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    public function get_photo($fid) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_GET, $this->editurl . "/$fid");

        $res = $this->http->sendRequest();
        $local_result = $this->http->getResponseBody();

        $matches = array();
        $pattern = '/<title>(.*)<\/title>/';
        preg_match($pattern, $local_result, $matches);

        $this->result = $matches[1];
    }

    public function edit_photo($fid, $title) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>'.$title.'</title>
</entry>';


        $this->setHeader(HTTP_REQUEST_METHOD_PUT, $this->editurl . "/$fid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    public function delete_photo($fid) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_DELETE, $this->editurl . "/$fid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    private function setHeader($method, $url) {
        $this->http->addHeader('Accept', 'application/x.atom+xml, application/xml, text/xml, */*');
        $this->http->addHeader('Authorization', 'WSSE profile="UsernameToken"');
        $this->http->addHeader('X-WSSE', $this->getWSSEAuth());
        $this->http->addHeader('Content-Type', 'application/x.atom+xml');
        $this->http->setMethod($method);
        $this->http->setURL($url);
    }
}
