<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * hatena dispatcher
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */


define("HATENA_BASEDIR", "Services/Hatena/");

require_once(HATENA_BASEDIR . "base.php");


/**
 * Hatena dispatcher class
 *
 * This class provides a method to create a concrete instance of one
 * of the supported service types (Search, AutoLink, Bookmarknum and Asin).
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena {
    public function __construct() {}
    public function Services_hatena() {}

    /**
     * Attempts to return a concrete instance of a class
     *
     * @access  public
     * @param   string Type of Service. Can be one of search, autolink, asin, bookmarknum, bookmark, similar and photo
     * @return  object Concrete instance of a service class based on the paramter
     */
    public function create($type)
    {

        switch ($type) {

        case "search"      : // i will make class for hatena search
        case "autolink"    : // i will make class for autolink word
        case "bookmarknum" : // i will make class for bookmarked count
        case "asin"        : // i will make class for asin count
        case "similar"     : // i will make class for similar word
        case "bookmark"    : // i will make class for bookmark operate
        case "photo"       : // i will make class for photo operate
        case "exist"       : // i will make class for exist operate
            require_once(HATENA_BASEDIR . $type . ".php");
            $classname = "Services_Hatena_" . $type;
            return new $classname;

        default :
            /** i do nothing */ 
            break;
        }
    }
}
