<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


/*
 * This script allow to edit the properties of the uploaded pictures:
 * - All pictures uploaded by the last JUpload will be displayed, and only them.
 * - For each pictures, it is possible to edit the title, the description and the key words.
 * 
 * This script is based on the editpics.php script. It is called by the /jupload.php script.
 * 
 */


if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


 
function form_options()
{
        global $CURRENT_PIC, $lang_editpics_php;

                $isgalleryicon_selected = ($CURRENT_PIC['galleryicon']) ? 'checked="checked" ':'';
                $isgalleryicon_disabled = ($CURRENT_PIC['category'] < FIRST_USER_CAT) ? 'disabled="disabled" ':'';

        if (UPLOAD_APPROVAL_MODE) {
                echo <<<EOT
        <tr>
                <td class="tableb" colspan="3" align="center">
                        <input type="radio" name="approved{$CURRENT_PIC['pid']}" id="approved{$CURRENT_PIC['pid']}yes" value="YES" class="radio" /><label for="approved{$CURRENT_PIC['pid']}yes" class="clickable_option">{$lang_editpics_php['approve']}</label>&nbsp;
                        <input type="radio" name="approved{$CURRENT_PIC['pid']}" id="approved{$CURRENT_PIC['pid']}no" value="NO" class="radio" checked="checked" /><label for="approved{$CURRENT_PIC['pid']}no" class="clickable_option">{$lang_editpics_php['postpone_app']}</label>&nbsp;
                        <input type="radio" name="approved{$CURRENT_PIC['pid']}" id="approved{$CURRENT_PIC['pid']}del" value="DELETE" class="radio" /><label for="approved{$CURRENT_PIC['pid']}del" class="clickable_option">{$lang_editpics_php['del_pic']}</label>&nbsp;
                </td>
        </tr>

EOT;
        } else {
                echo <<<EOT
        <tr>
                <td class="tableb" colspan="3" align="center">
                    <table border="0" cellspacing="0" cellpadding="0" width="100%">
                        <tr>
                            <td width="20%" align="center"><input type="radio" name="galleryicon" id="galleryicon{$CURRENT_PIC['pid']}" value="{$CURRENT_PIC['pid']}" {$isgalleryicon_selected}{$isgalleryicon_disabled}class="checkbox" />{$lang_editpics_php['gallery_icon']}</td>
                            <td width="20%" align="center"><input type="checkbox" name="delete{$CURRENT_PIC['pid']}" id="delete{$CURRENT_PIC['pid']}" value="1" class="checkbox" /><label for="delete{$CURRENT_PIC['pid']}" class="clickable_option">{$lang_editpics_php['del_pic']}</label></td>
                            <td width="20%" align="center"><input type="checkbox" name="reset_vcount{$CURRENT_PIC['pid']}" id="reset_vcount{$CURRENT_PIC['pid']}" value="1" class="checkbox" /><label for="reset_vcount{$CURRENT_PIC['pid']}" class="clickable_option">{$lang_editpics_php['reset_view_count']}</label></td>
                            <td width="20%" align="center"><input type="checkbox" name="reset_votes{$CURRENT_PIC['pid']}" id="reset_votes{$CURRENT_PIC['pid']}" value="1" class="checkbox" /><label for="reset_votes{$CURRENT_PIC['pid']}" class="clickable_option">{$lang_editpics_php['reset_votes']}</label></td>
                            <td width="20%" align="center"><input type="checkbox" name="del_comments{$CURRENT_PIC['pid']}" id="del_comments{$CURRENT_PIC['pid']}" value="1" class="checkbox" /><label for="del_comments{$CURRENT_PIC['pid']}" class="clickable_option">{$lang_editpics_php['del_comm']}</label></td>
                        </tr>
                    </table>
                </td>
        </tr>

EOT;
        }
}

function form_pic_info($text)
{
        global $CURRENT_PIC, $THUMB_ROWSPAN, $CONFIG, $lang_byte_units, $lang_editpics_php;

        if (!is_movie($CURRENT_PIC['filename'])) {
                $pic_info = sprintf($lang_editpics_php['pic_info_str'], $CURRENT_PIC['pwidth'], $CURRENT_PIC['pheight'], ($CURRENT_PIC['filesize'] >> 10), $CURRENT_PIC['hits'], $CURRENT_PIC['votes']);
        } else {
                $pic_info = sprintf($lang_editpics_php['pic_info_str'], '<input type="text" name="pwidth'.$CURRENT_PIC['pid'].'" value="'.$CURRENT_PIC['pwidth'].'" size="5" maxlength="5" class="textinput" />', '<input type="text" name="pheight'.$CURRENT_PIC['pid'].'" value="'.$CURRENT_PIC['pheight'].'" size="5" maxlength="5" class="textinput" />', ($CURRENT_PIC['filesize'] >> 10), $CURRENT_PIC['hits'], $CURRENT_PIC['votes']);
        }

        if (UPLOAD_APPROVAL_MODE) {
                // Commented out by Omni; Duplicate of above
                //$pic_info = $CURRENT_PIC['pwidth'].' &times; '.$CURRENT_PIC['pheight'].' - '.($CURRENT_PIC['filesize'] >> 10).$lang_byte_units[1];
                if($CURRENT_PIC['owner_name']){
                        $pic_info .= ' - <a href ="profile.php?uid='.$CURRENT_PIC['owner_id'].'" target="_blank">'.$CURRENT_PIC['owner_name'].'</a>';
                }
        }

        $thumb_url = get_pic_url($CURRENT_PIC, 'thumb');
        $thumb_link = 'displayimage.php?&amp;pos='.(-$CURRENT_PIC['pid']);
        $filename = htmlspecialchars($CURRENT_PIC['filename']);

        echo <<<EOT
        <input type="hidden" name="pid[]" value="{$CURRENT_PIC['pid']}" />
        <tr>
                <td class="tableh2" colspan="3">
                        <b>$filename</b>
                </td>
        </tr>
        <tr>
                <td class="tableb" style="white-space: nowrap;">
                        $text
                </td>
                <td class="tableb">
                        $pic_info
                </td>
                   <td class="tableb" align="center" rowspan="$THUMB_ROWSPAN">
                        <a href="$thumb_link" target="_blank"><img src="$thumb_url" class="image" border="0" alt="" /><br /></a>
            </td>
        </tr>

EOT;
}

function get_post_var($var, $pid)
{
        global $lang_errors;

        $var_name = $var.$pid;
        if(!isset($_POST[$var_name])) cpg_die(CRITICAL_ERROR, $lang_errors['param_missing']." ($var_name)", __FILE__, __LINE__);
        return $_POST[$var_name];
}


function process_post_data()
{
        global $CONFIG;
        global $user_albums_list, $lang_errors, $lang_picinfo, $nb_pictures, $message_update_status;

        //$user_album_set = array();
        //foreach($user_albums_list as $album) $user_album_set[$album['aid']] = 1;

        if (!is_array($_POST['pid'])) cpg_die(CRITICAL_ERROR, $lang_errors['param_missing'], __FILE__, __LINE__);

        $pid_array = &$_POST['pid'];

        $galleryicon = isset($_POST['galleryicon']) ? (int) $_POST['galleryicon'] : 0;

        foreach($pid_array as $pid){
                $pid = (int)$pid;

                $aid         = (int)get_post_var('aid', $pid);
                $title       = get_post_var('title', $pid);
                $caption     = get_post_var('caption', $pid);
                $keywords    = get_post_var('keywords', $pid);
                $user1       = get_post_var('user1', $pid);
                $user2       = get_post_var('user2', $pid);
                $user3       = get_post_var('user3', $pid);
                $user4       = get_post_var('user4', $pid);

                                $isgalleryicon = ($galleryicon===$pid);

                $delete       = isset($_POST['delete'.$pid]);
                $reset_vcount = isset($_POST['reset_vcount'.$pid]);
                $reset_votes  = isset($_POST['reset_votes'.$pid]);
                $del_comments = isset($_POST['del_comments'.$pid]) || $delete;

                $query = "SELECT category, filepath, filename, owner_id FROM {$CONFIG['TABLE_PICTURES']}, {$CONFIG['TABLE_ALBUMS']} WHERE {$CONFIG['TABLE_PICTURES']}.aid = {$CONFIG['TABLE_ALBUMS']}.aid AND pid='$pid'";
                $result = cpg_db_query($query);
                if (!mysql_num_rows($result)) cpg_die(CRITICAL_ERROR, $lang_errors['non_exist_ap'], __FILE__, __LINE__);
                $pic = mysql_fetch_array($result);
                mysql_free_result($result);

                if (!GALLERY_ADMIN_MODE) {
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////// Modification start for JUpload /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	                	//The user may modify its own pictures. He may not move pictures from an album to another
	                	//from this script: if he were allowed to, it would be necessary to check if approval is
	                	//needed when moving pictures to another category that its own gallery.
	                	$query = "SELECT pid FROM {$CONFIG['TABLE_PICTURES']} WHERE pid = $pid AND (owner_id != '" . USER_ID . "' OR aid != $aid)";  
		                $result = cpg_db_query($query);
		                //If we get lines, then some of the updated pictures don't belong to the current user,
		                //or are asked to move from an albu to another.
                    	if (mysql_num_rows($result)) cpg_die(ERROR, $lang_errors['perm_denied']."<br />(picture category = {$pic['category']}/ $pid)", __FILE__, __LINE__);

                    	//Below: the original test.
                    	//if ($pic['category'] != FIRST_USER_CAT + USER_ID) cpg_die(ERROR, $lang_errors['perm_denied']."<br />(picture category = {$pic['category']}/ $pid)", __FILE__, __LINE__);
                        //if (!isset($user_album_set[$aid])) cpg_die(ERROR, $lang_errors['perm_denied']."<br />(target album = $aid)", __FILE__, __LINE__);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////  Modification end for JUpload  /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                }

                $update  = "aid = '".$aid."'";
                $update .= ", title = '".addslashes($title)."'";
                $update .= ", caption = '".addslashes($caption)."'";
                $update .= ", keywords = '".addslashes($keywords)."'";
                $update .= ", user1 = '".addslashes($user1)."'";
                $update .= ", user2 = '".addslashes($user2)."'";
                $update .= ", user3 = '".addslashes($user3)."'";
                $update .= ", user4 = '".addslashes($user4)."'";

                if ($isgalleryicon && $pic['category']>FIRST_USER_CAT) {
                        $sql = 'update '.$CONFIG['TABLE_PICTURES'].' set galleryicon=0 where owner_id='.$pic['owner_id'].';';
                        cpg_db_query($sql);
                        $update .= ", galleryicon = ".addslashes($galleryicon);
                }

                if (is_movie($pic['filename'])) {
                        $pwidth = get_post_var('pwidth', $pid);
                        $pheight = get_post_var('pheight', $pid);
                        $update .= ", pwidth = " .  (int) $pwidth;
                        $update .= ", pheight = " . (int) $pheight;
                }

                if ($reset_vcount) {
                    $update .= ", hits = '0'";
                    resetDetailHits($pid);
                }
                if ($reset_votes) {
                    $update .= ", pic_rating = '0', votes = '0'";
                    resetDetailVotes($pid);
                }

                if (UPLOAD_APPROVAL_MODE) {
                    $approved = get_post_var('approved', $pid);
                        if ($approved == 'YES') {
                                $update .= ", approved = 'YES'";
                        } elseif ($approved == 'DELETE') {
                                $del_comments = 1;
                                $delete = 1;
                        }
                }

                if ($del_comments) {
                        $query = "DELETE FROM {$CONFIG['TABLE_COMMENTS']} WHERE pid='$pid'";
                        $result =cpg_db_query($query);
                }

                if ($delete) {
                        $dir=$CONFIG['fullpath'].$pic['filepath'];
                        $file=$pic['filename'];

                        if (!is_writable($dir)) cpg_die(CRITICAL_ERROR, sprintf($lang_errors['directory_ro'], $dir), __FILE__, __LINE__);

                        $files=array($dir.$file, $dir.$CONFIG['normal_pfx'].$file, $dir.$CONFIG['thumb_pfx'].$file);
                        foreach ($files as $currFile){
                                if (is_file($currFile)) @unlink($currFile);
                        }

                        $query = "DELETE FROM {$CONFIG['TABLE_PICTURES']} WHERE pid='$pid' LIMIT 1";
                        $result = cpg_db_query($query);
                        
                        ///////////////////////////////////////////////////////////////////////////
                        //////////////  Update for JUpload: start//////////////////////////////////
                        ///////////////////////////////////////////////////////////////////////////
                        $nb_pictures -= 1;
                        ///////////////////////////////////////////////////////////////////////////
                        //////////////  Update for JUpload: end  //////////////////////////////////
                        ///////////////////////////////////////////////////////////////////////////
                } else {
                        $query = "UPDATE {$CONFIG['TABLE_PICTURES']} SET $update WHERE pid='$pid' LIMIT 1";
                        $result = cpg_db_query($query);
                }
        }
        
        //Ok, the update is a success.
        $message_update_status = "alert('" . prepare_js_string($lang_picinfo['success']) . "');";
}

/*
function get_user_albums($user_id = '')
{
        global $CONFIG, $user_albums_list;

        $USER_ALBUMS_ARRAY=array(0 => array());

        if ($user_id != '') {
                $or = " OR category='" . (FIRST_USER_CAT + $user_id) . "'";
        }

        if (!isset($USER_ALBUMS_ARRAY[USER_ID])) {
                $user_albums = cpg_db_query("SELECT aid, title FROM {$CONFIG['TABLE_ALBUMS']} WHERE category='".(FIRST_USER_CAT + USER_ID)."' $or ORDER BY title");

                if (mysql_num_rows($user_albums)) {
                    $user_albums_list=cpg_db_fetch_rowset($user_albums);
                } else {
                        $user_albums_list = array();
                }
                mysql_free_result($user_albums);
                $USER_ALBUMS_ARRAY[USER_ID] = $user_albums_list;
        } else {
                $user_albums_list = &$USER_ALBUMS_ARRAY[USER_ID];
        }
}

*/


// We select the picture to display ...
logDebug('[edit_uploaded_pics.php] Before get_pictures()');
$resultset_pictures = get_pictures();
logDebug('[edit_uploaded_pics.php] After get_pictures()');
$data = array(
        array($lang_editpics_php['pic_info'], '', 3),
        //We prevent the user from changing the current album.
        //array($lang_editpics_php['album'], 'aid', 1.1),   // 1.1 correspond to the form_alb_list_box_pic function
        array('aid', $album, 5),
        array($lang_editpics_php['title'], 'title', 0, 255),
        array($lang_editpics_php['desc'], 'caption', 2, $CONFIG['max_img_desc_length']),
        array($lang_editpics_php['keywords'], 'keywords', 0, 255),
        array($CONFIG['user_field1_name'], 'user1', 0, 255),
        array($CONFIG['user_field2_name'], 'user2', 0, 255),
        array($CONFIG['user_field3_name'], 'user3', 0, 255),
        array($CONFIG['user_field4_name'], 'user4', 0, 255)
        //,array('', '', 4)    //Check box reset counter, remove picture...
);

$next_target = $_SERVER['PHP_SELF'].'?action=edit_uploaded_pics&amp;album='.$album_id.'&amp;start='.($start+$count).'&amp;count='.$count.((UPLOAD_APPROVAL_MODE==1)?"&amp;mode=upload_approval":"");
$prev_target = $_SERVER['PHP_SELF'].'?action=edit_uploaded_pics&amp;album='.$album_id.'&amp;start='.max(0,$start-$count).'&amp;count='.$count.((UPLOAD_APPROVAL_MODE==1)?"&amp;mode=upload_approval":"");
$s50 = $count == 50 ? 'selected' : '';
$s75 = $count == 75 ? 'selected' : '';
$s100 = $count == 100 ? 'selected' : '';
/*
if ($start + $count < $pic_count) {
    $next_link = "<a href=\"$next_target\"><b>{$lang_editpics_php['see_next']}</b></a>&nbsp;&nbsp;-&nbsp;&nbsp;";
} else {
        $next_link = '';
}

if ($start > 0) {
    $prev_link = "<a href=\"$prev_target\"><b>{$lang_editpics_php['see_prev']}</b></a>&nbsp;&nbsp;-&nbsp;&nbsp;";
} else {
        $prev_link = '';
}
*/
$prev_link = '';
$next_link = '';

$pic_count_text = sprintf(	
		$lang_editpics_php['n_pic'], 
		//$pic_count	//Total number of pictures in the album
		$nb_pictures	//Number of pictures that were downloaded. 
	);

$title = $lang_editpics_php['edit_pics'];


///////////////////////////////////////////////////////////////////////////////////////////////
////////////////////  HTML construction: start  ///////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////
pageheader($lang_editpics_php['edit_pics']);
 
starttable("100%", $title.$help, 3);
echo <<<EOT
<script type="text/javascript" language="javascript">

//Maybe there is a message to display to the user:
$message_update_status

<!--
function textCounter(field, maxlimit) {
        if (field.value.length > maxlimit) // if too long...trim it!
        field.value = field.value.substring(0, maxlimit);
}

function selectAll(d,box) {
  var f = document.editForm;
  for (i = 0; i < f.length; i++) {
    if (f[i].type == "checkbox" && f[i].name.indexOf(box) >= 0) {
      if (d.checked) {
        f[i].checked = true;
      } else {
        f[i].checked = false;
      }
    }
  }
}
-->
</script>
EOT;

$mode= (UPLOAD_APPROVAL_MODE==1) ? "&amp;mode=upload_approval":"";
$cat_l = (isset($actual_cat))? "?cat=$actual_cat" : (isset($cat) ? "?cat=$cat" : '');
echo <<<EOT
        <tr>
                <td class="tableh2" colspan="3" align="center" valign="middle">
                <form method="post" name="editForm" action="$form_target$mode">
                        <b>$pic_count_text</b>&nbsp;&nbsp;-&nbsp;&nbsp;
                        <!-- 
                        $prev_link
                        $next_link
                        <b>{$lang_editpics_php['n_of_pic_to_disp']}</b>
                        <select onChange="if(this.options[this.selectedIndex].value) window.location.href='{$_SERVER['PHP_SELF']}?action=edit_uploaded_pics&amp;album=$album_id$mode&amp;start=$start&amp;count='+this.options[this.selectedIndex].value;"  name="count" class="listbox">
                                <option value="25">25</option>
                                <option value="50" $s50>50</option>
                                <option value="75" $s75>75</option>
                                <option value="100" $s100>100</option>
                        </select>
                        -->
EOT;
if (UPLOAD_APPROVAL_MODE!=1) {
echo <<<EOT
                        &nbsp;&nbsp;-&nbsp;&nbsp;<a href="modifyalb.php?album=$album_id" class="admin_menu">{$lang_editpics_php['album_properties']}</a>&nbsp;&nbsp;-&nbsp;&nbsp;
                        <a href="index.php$cat_l" class="admin_menu">{$lang_editpics_php['parent_category']}</a>&nbsp;&nbsp;-&nbsp;&nbsp;
                        <a href="thumbnails.php?album=$album_id" class="admin_menu">{$lang_editpics_php['thumbnail_view']}</a>
EOT;
}
echo <<<EOT
                </td>
        </tr>
EOT;

/*
echo <<<EOT
        <tr>
            <td class="tableb" colspan="3" align="center">
                <table border="0" cellspacing="0" cellpadding="0" width="100%" style="padding-top:5px;padding-bottom:5px">
                    <tr>
                        <td width="20%" align="right">
                            <b>{$lang_editpics_php['select_unselect']}:</b>
                        </td>
                        <td width="20%" align="center">
                            <span class="admin_menu">
                                <input type="checkbox" name="deleteAll" onclick="selectAll(this,'delete');" class="checkbox" id="deleteAll" />
                                <label for="deleteAll" class="clickable_option">{$lang_editpics_php['del_all']}</label>
                            </span>
                        </td>
                        <td width="20%" align="center">
                            <span class="admin_menu">
                                <input type="checkbox" name="reset_vcountAll" onclick="selectAll(this,'reset_vcount');" class="checkbox" id="reset_vcountAll" />
                                <label for="reset_vcountAll" class="clickable_option">{$lang_editpics_php['reset_all_view_count']}</label>
                            </span>
                        </td>
                        <td width="20%" align="center">
                            <span class="admin_menu">
                                <input type="checkbox" name="reset_votesAll" onclick="selectAll(this,'reset_votes');" class="checkbox" id="reset_votesAll" />
                                <label for="reset_votesAll" class="clickable_option">{$lang_editpics_php['reset_all_votes']}</label>
                            </span>
                        </td>
                        <td width="20%" align="center">
                            <span class="admin_menu">
                                <input type="checkbox" name="del_commentsAll" onclick="selectAll(this,'del_comments');" class="checkbox" <!-- EGR reset_votesAll" --> id="del_commentsAll" />
                                <label for="del_commentsAll" class="clickable_option">{$lang_editpics_php['del_all_comm']}</label>
                            </span>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
EOT;
*/

//Let's display the pictures.
while($CURRENT_PIC = mysql_fetch_array($resultset_pictures)){
        create_form($data);
        flush();
} // while
mysql_free_result($resultset_pictures);

echo <<<EOT
        <tr>
                <td colspan="3" align="center" class="tablef">
                        <input type="submit" value="{$lang_editpics_php['apply']}" class="button" />
                </td>
                </form>
        </tr>

EOT;
endtable();
pagefooter();
//ob_end_flush();
