<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


//The applet first do a 'HEAD' call to this page, to check the server, proxy, protocol...
//When using JUpload internal session management, this would lead to the session being deleted from 
//the database. So, when a HEAD request is done, we just finish here.
if ($_SERVER['REQUEST_METHOD']=='HEAD') {
	die("HEAD request: everything is ok. No more work to do");
}




if (!defined('IN_COPPERMINE')) {
	//There can be direct access to this URL: as Coppermine central scripts (ex: login and errors) only
	//redirect to a page, without transmitting its parameters, we redirect to the plugins/jupload/jupload.php
	//Now that we are here, we redirect to  YourCoppermineInstallation/index.php?file=jupload/jupload
	
	//Let's get all GET parameters in this query, and redirect to the correct URL.
	$parameters = '';
	foreach ($_GET as $param => $value) {
		$parameters .= '&' . urlencode($param) . '=' . urlencode($value);
	}
	echo <<<EOS
	<script language="javascript">
	document.location.replace("../../index.php?file=jupload/jupload${parameters}"); 
	</script>
EOS;
	exit;	
}

//Ok, now we are within JUpload
// Note: define('JUPLOAD_PHP', true);  is executed in jupload_page_start (codebase.php)


//####################################################################################################
//##############################        CONSTANTS      ###############################################
//####################################################################################################


// Activate more language block sets.
define('ADMIN_PHP',			true);
define('ALBMGR_PHP',		true); // added this line as workaround for missing translation of *no category*. Should be removed in next version. GauGau 2005-08-09
define('CATMGR_PHP',		true);
define('DB_INPUT_PHP',		true);
define('DISPLAYIMAGE_PHP',	true);
define('EDITPICS_PHP',		true);
define('GROUPMGR_PHP',		true);
define('INDEX_PHP',			true);
define('UPLOAD_PHP',		true);


//####################################################################################################
//#################################     INCLUDES    ##################################################
//####################################################################################################

//In CPG1.4, it's up to this script to include the main ini.inc.php, so the plugins functions in codebase.php are not called
//when we're here !
if (!defined('JUPLOAD_CPG_VERSION')) {
	// We're in CPG 1.4, as JUpload is not initialized.
	// Call basic functions, etc.
	require_once('include/init.inc.php');
} else if (JUPLOAD_CPG_VERSION == JUPLOAD_CPG_1_5) {
	//For the Coppermine 1.5 version, we need to re-import the language files, using the previous definitions,
	//as the init.inc.php version has already been included in the index.php file.
	if (!file_exists("lang/{$CONFIG['lang']}.php")) {
	    $CONFIG['lang'] = 'english';
	}
	// We finally load the chosen language file if it differs from English
	if ($CONFIG['lang'] != 'english') {
	    require('lang/' . $CONFIG['lang'] . '.php');
	}
} else {
	die('unknown coppermine version (in file plugins/jupload/jupload.php)');
} 




// Some placeholders.
$customize = CUSTOMIZE_UPLOAD_FORM;
$user_form = USER_UPLOAD_FORM;
$allowed_URI_boxes = NUM_URI_BOXES;
$allowed_file_boxes = NUM_FILE_BOXES;


//####################################################################################################
//##########################  CHECK IF THE USER MAY ENTER THE PLUGIN  ################################
//####################################################################################################


//If the user may not use the plugin, we display the standard error message.
//$jupload_user_may_use_jupload comes from jupload_page_start() in codebase.php
if (!$jupload_user_may_use_jupload) {
    $msg = 
    	str_replace(
			'$1', 
			'login.php?referer=plugins/jupload/jupload.php', 
			$lang_jupload_php['perm_denied'])
		;
	
	//When in upload_picture, we must return a simple file text (no HTML), so that the applet
	//can read it.
 	if (isset($_GET['action']) && $_GET['action'] == 'upload_picture') {
 		die($msg);
 	} else {		
    	cpg_die(ERROR, $msg, __FILE__, __LINE__);
 	}    
}


// ???????????????????????
// Globalize $CONFIG.
global $CONFIG, $user_form, $max_file_size;


//####################################################################################################
//#################################    FUNCTIONS    ##################################################
//####################################################################################################



//####################################################################################################
//#############################  INIT OF SCRIPT VARIABLES  ###########################################
//####################################################################################################

//Initialize local parameters.
if (JUPLOAD_CPG_VERSION == JUPLOAD_CPG_1_5) {
	//coppermine 1.5
	$category = getSuperCageInt('category');
	if ($category < 0) {
		$category = getSuperCageInt('cat', -1);				
	} 
	$action = getSuperCageString('action');
	$album = getSuperCageInt('album');
	$album_name = getSuperCageString('album_name');
	$album_description = getSuperCageString('album_description');
	$jupart = getSuperCageInt('jupart', 0);
	$jufinal = getSuperCageInt('jufinal', 0);
	$chunkedUpload = $jupart || $jufinal;
	//Parameter specific to the plugins/jupload/include/edit_uploaded_pics.php
	$since_time = getSuperCageInt('since_time');
	$nb_pictures = getSuperCageInt('nb_pictures');	
	//Which pictures to display.
	$start = getSuperCageInt('start', 0);
	$count = getSuperCageInt('count', 25);
} else {
	//coppermine 1.4
	$category		= isset($_POST['category']			) 
							? ( (int) $_POST['category'])	
							: (
								isset($_GET['category'])
									? (int)$_GET['category']
									: (
										isset($_GET['cat'])		//Coppermine uses 'cat' get parameter.
											? (int) $_GET['cat']
											: -1				// 0 is a valid category: it's ....  no category !!!
									  )
							   );
	$action				= isset($_POST['action']			) ? $_POST['action'] 			: (isset($_GET['action'])? $_GET['action']   :'');
	$album				= isset($_POST['album']				) ? ( (int) $_POST['album']) 	: (isset($_GET['album'] )?(int)$_GET['album']:-1);
	$album_name			= isset($_POST['album_name']		) ? $_POST['album_name'] 		: '';
	$album_description	= isset($_POST['album_description'] ) ? $_POST['album_description'] : '';
	if (isset($_GET['jupart']) && isset($_GET['jufinal'])) {
		$chunkedUpload = true;
		$jupart  = (int) $_GET['jupart'];
		$jufinal = (int) $_GET['jufinal'];
	} else {
		$chunkedUpload = false;
	}
	
	//Parameter specific to the plugins/jupload/include/edit_uploaded_pics.php
	$since_time = isset($_GET['since_time']) ? (int)$_GET['since_time'] : 0;
	$nb_pictures = (int)$_GET['nb_pictures'];	
	//Which pictures to display.
	$start = isset($_GET['start']) ? (int)$_GET['start'] : 0;
	$count = isset($_GET['count']) ? (int)$_GET['count'] : 25;
}
logDebug("Category received: $category");
logDebug("Album received: $album");
logDebug("Action received: $action");



/////////////////////////////////////////////////////////////////////////////////////////////////////
//  Control for the $category and $album parameters
/////////////////////////////////////////////////////////////////////////////////////////////////////
/*
 * Rules are:
 * 
 * Controls that $category and $album are not integer has already been done.
 * 
 * In GALLERY_ADMIN_MODE or action=ajax_list_album_of_a_category
 * - $category must be a valid category,
 * - $category may be a user's album, only if $USER_DATA['can_create_albums'] is true. 
 * - $album is free (control has already been done that it's an integer)
 * - If both $category and $album are given, the album must be in this category. Otherwise, we clear the album
 * 
 * In non GALLERY_ADMIN_MODE:
 * - $category must be a valid category. If category is not given, or is invalid, the user gallery is used.
 * - $category may be a user's album, only if $USER_DATA['can_create_albums'] is true. 
 * - $album may be one of these:
 *   * his user's album
 *   * a public album where his group may upload
 * - If both $category and $album are given, the album must be in this category. Otherwise, we clear the album
 * If upload is accepted to this album, the category is initialized to this category.
 * 
 */

//If $album is set, but not $category, we look for the album's category.
if ($category < 0 && $album > 0) {
	//Let's find the category for this album. We'll check later if this category is Ok for the current user.
	$result = cpg_db_query(
			" SELECT category " .
			" FROM {$CONFIG['TABLE_ALBUMS']} " .
			" WHERE aid = $album "
			);
	$row = mysql_fetch_array($result);
	if ($row) {
		$category = $row['category'];
		logDebug("Album is set. Category changed to: $category");
	}
//In user admin mode, if the category wa not give, and doesn't correspond to the previous check,
//we replace it by the user's gallery.
}

//If category is still 0, then the album number is wrong.
if ($category < 0) {
	$album = -1;
	if (USER_CAN_CREATE_ALBUMS) {
		$category = FIRST_USER_CAT + USER_ID;
		logDebug("Category changed to: $category (user's album))");
	} else if (GALLERY_ADMIN_MODE) {
		//For admin mode, if he may not have a personal gallery, default category is 'no category'
		$category = 0;
		logDebug("Category changed to: $category (admin mode)");
	} else {
		//The user may not create album, and is not the admin. Let's find his/her first album.		
		$result = cpg_db_query(
				" SELECT category " .
				" FROM {$CONFIG['TABLE_ALBUMS']} a " .
				" WHERE a.category < " . FIRST_USER_CAT .
				" AND a.uploads='YES' " .
				" AND (a.visibility = '0' OR a.visibility IN ".USER_GROUP_SET.")" .
				" AND " . (USER_CAN_UPLOAD_PICTURES ? '1=1 ' : '1=2')
				);
		$row = mysql_fetch_array($result);
		$category = $row['category'];
		logDebug("Category changed to: $category (non admin user who can't create album))");
	}
} else { //($category >= 0)
	//$category is set, we check that it's a valid category
	if (USER_CAN_CREATE_ALBUMS && $category == (FIRST_USER_CAT + USER_ID)) {
		// It is the user's category.
		$result = 1;
		$current_category 	= array(
						'cid' => FIRST_USER_CAT + USER_ID, 
						'name' => $lang_groupmgr_php['personal_gallery'], 
						'parent' => '0', 
						'description' => '');
	} else if (GALLERY_ADMIN_MODE && $category > 0) {
		// It is a real category, in admin mode.
		$result = cpg_db_query(
				"  SELECT cid, name, parent, description " .
				"  FROM {$CONFIG['TABLE_CATEGORIES']} " .
				"  WHERE cid = $category " . 
				"  AND   cid > 0 " .
				"  AND   cid < " . FIRST_USER_CAT
				);
		$current_category = mysql_fetch_array($result);
	} else if ($category == 0) {
		// It is the fake 'no category'. It doesn't exist in the database.
		$result = 1;
		$current_category 	= array(
						'cid' => 0, 
						'name' => $lang_upload_php['albums_no_category'], 
						'parent' => '0', 
						'description' => '');
	} else {
		// We're in user mode, and the category is a true one.
		$result = cpg_db_query(
				" SELECT cid, name, parent, description " .
				" FROM {$CONFIG['TABLE_CATEGORIES']} " .
				" WHERE cid = $category " . 
				" AND   (cid < " . FIRST_USER_CAT . " or cid = " . (FIRST_USER_CAT + USER_ID) . ")"
				);
		$current_category = mysql_fetch_array($result);
	}

	$category = $current_category['cid'];
	
	//If the user has no right for this category, we switch category and album to -1.
	//It can happen, for instance, when having a bookmark on an album, and using it when
	//the session is finished, or when someone is browsing an album he may not upload to, 
	//and click on jupload.
	if (!isset($category)) {
		logDebug("Current user has no right on this one. Erasing album and category numbers.");
		$category = -1;
		$album = -1;
	} 
}

//If the category is still set (was set and accepted by the previous check), we
//can check the album
if (! isset($category)) {
	logDebug("Category is not set !!!");
} else if ($category >= 0 && $album > 0) {
	//Let's check that the album exists, and the user has right to have access to it. In JUpload
	//access means 'right to upload to it'.
	if (GALLERY_ADMIN_MODE) {
		logDebug("Admin mode. Checking category '$category' and album '$album'.");
		$result = cpg_db_query(
				" SELECT aid " .
				" FROM {$CONFIG['TABLE_ALBUMS']} a" .
				" WHERE a.category = $category " .
				" AND   a.aid = $album "
				);
	} else {
		logDebug("Non admin. Checking category '$category' and album '$album'.");
		$result = cpg_db_query(
				" SELECT aid " .
				" FROM {$CONFIG['TABLE_ALBUMS']} a " .
				" WHERE category = $category " .
				" AND   a.aid = $album " .
				" AND " .
				"  ( " .
				"     ( " .
				"		a.category < " . FIRST_USER_CAT .
				"		AND a.uploads='YES' " .
				"		AND (a.visibility = '0' OR a.visibility IN ".USER_GROUP_SET.")" .
				"		AND " . (USER_CAN_UPLOAD_PICTURES ? '1=1 ' : '1=2') .
				"      ) " .
				"  OR " .
				"     ( " .
				" 		a.category ='" . (FIRST_USER_CAT + USER_ID) . "'" . 
				"		AND " . (USER_CAN_CREATE_ALBUMS ? '1=1 ' : '1=2')  .
				"      ) " .
				"  ) "
				);
	}
	//If we have a result, the album is valid.
	$row = mysql_fetch_row($result);
	//Otherwise, we clear the album, as the user doesn't have access to it.
	if (!$row) {
		logDebug("(100) no album/category found. Album switched to -1");
		$album = -1;
	}	
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
//  End of controls for the $category and $album parameters
/////////////////////////////////////////////////////////////////////////////////////////////////////

//Override the SELF address, to add the album and category link, if any
$JUPLOAD_VAR['SELF'] = 'index.php?file=jupload/jupload'
	. ( $album>0 ? "&album=$album" : '')	
	. ( $category>0 ? "&category=$category" : '')	
;




//####################################################################################################
//################################# MAIN CODE BLOCK ##################################################
//####################################################################################################


///////////////////////////////////////////////////////////////////////
/////////////////   HANDLE OF INCOMING ACTIONS  (if any)  /////////////
///////////////////////////////////////////////////////////////////////
if (isset($_GET['action']) && $_GET['action'] == 'upload_picture') {
	//This ouput is only visible in the applet log windows, if debug mode is enabled.
	logDebug("jupload.php: before switch\n");
}

logDebug("JUpload will run with category $category and album $album<BR>");
$album_id = $album;

switch ($action) {
//First: generation of the standard jupload page, containing the applet:
case '':
case 'update_album':
case 'create_album':
case 'upload_page':
	require("$juploadRootDirectory/page/upload_page.php");
	break;
//Upload of a picture from the applet. No HTML to generate.
case 'upload_picture':
	require("$juploadRootDirectory/page/upload_picture.php");
	break;
//Edition of the properties of the uploaded pictures:
case 'ajax_list_album_of_a_category':
	require("$juploadRootDirectory/page/ajax_list_album_of_a_category.php");
	break;
case 'edit_uploaded_pics':
	require("$juploadRootDirectory/page/edit_uploaded_pics.php");
	break;
case 'config':
case 'store_config':
	require("$juploadRootDirectory/page/config_page.php");
	break;
case 'log_error':
	require("$juploadRootDirectory/page/log_error.php");
	break;
case 'display_error':
	$text = $_GET['text'];
	$msg = $lang_jupload_php[$text];
	cpg_die(ERROR, $msg, __FILE__, __LINE__);
default:
	cpg_die (ERROR, 'JUpload: Unknown action value', __FILE__, __LINE__);
}


//Let's send the output data.
ob_end_flush();



