<?php
 /**
 *
 * BrainFeeder for CPG
 * Version 0.5
 * written  by Hallvard Natvik <hallvard@natvik.com>
 * Send me a mail if you use it
 * 
 * This is free software made available to you without any guarantees or obligations
 * You can use this sofware anyway you like.
 *------------------------------------------------------------
 * This file manages the configuration screen 
 */
require('include/init.inc.php');
if (!GALLERY_ADMIN_MODE) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
pageheader();
if (!isset($_GET['cf_op'])) {
    $operation = "list";
} else {
    $operation = $_GET['cf_op'];
}

$fields = array (
        "fid"=> array ("Id:", "readonly",3,"",'value'=>""),
        "feed_name" => array ("Feed Name:", "input", 30, "",'value'=>""),
        "feed_title" => array("Feed Title:", "input",60, $CONFIG['gallery_name'],'value'=>""),
        "feed_link" => array("Feed main link:", "input",100, $CONFIG['site_url'],'value'=>""),
        "feed_copyright" => array("Copyright message:", "input",100, "",'value'=>""),
        "feed_keywords" => array("Feed categories:", "input",100, "",'value'=>""),
        "logo_keyw" => array ("Keyword for logo picture", "input", 10, "", 'value'=>""),
        "feed_description" => array("Description:", "textarea",250, $CONFIG['gallery_description'],'value'=>""),
        "feed_type" => array("Type:", "options",array("Last public", "Keyword", "Album", "Category", "Hits", "Rating" ), 'Keyword', 'value'=>""),
        "feed_parameter" => array("Which keyword(s), Album id or Cat id?:", "input",100, "", 'value'=>""),
        "feed_incl_restr" => array ("Include protected pictures?", "yesno", "No",'value'=>""),
        "items_to_include" => array("Number of items to include:", "input",10, 10, 'value'=>""),
        "feed_refresh" => array ("Minutes between each refresh: ", "input", 4, 1440, 'value'=>""),
        "item_def_title" => array("Heading for pictures without title or caption:", "input",100, $CONFIG['gallery_description'], 'value'=>""),
        "feed_source" => array("Include source?", "yesno", "No", 'value'=>""),
        "item_cms" => array("Include picture story from MiniCMS?", "yesno", "No", 'value'=>""),
        "item_comments" => array("Include comments?", "yesno", "No", 'value'=>""),
        "feed_category_opt" => array ("Include picture keywords?", "yesno", "No",'value'=>""),
        "feed_enclosure" => array ("Enclose picture?", "options", array("No", "Normal", "Original"),"No", 'value'=>""),
        "feed_mode" => array ("Batch or realtime?", "options", array("Batch","Realtime"), "Batch", 'value'=>""),
        "file_name" => array ("Filename for batchmode: ", "input", 30, "feed".rand(1,999). ".xml", 'value'=>"")
     );   

switch ($operation) {
    case "list": 
        show_feed_roster();
        break;
    case "add":         //Display emtpy form for entering a new feed
        add_feed($fields);
        break;
    case "insert":      //Form for new feed has been posted, insert new record into database
        update_feed("insert",$fields);
        show_feed_roster(); 
        break;
    case "edit":        //Display existing record for editing
        edit_feed($fields);
        break;
    case "delete":      //Delete record
        delete_feed();
        show_feed_roster(); 
        break;
    case "update":      //Update an existing record
        update_feed("update",$fields);
        show_feed_roster(); 
        break;
}


function show_feed_roster() {
    global $CONFIG;
    $query = "SELECT * from ".$CONFIG['TABLE_brainfeeder'];
    $result = cpg_db_query($query);
    $feeds = cpg_db_fetch_rowset($result);
    echo "
    <table align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"0\" class=\"maintable\">
        <TR>
            <td class=\"tableh1\" colspan=\"7\">RSS configuration</td>
        </TR>
        <TR>
            <td class=\"tableh2\" colspan=\"7\"><p>Give your feeds a name, configure the data sources and set the URL</td>
        </TR>
        <TR>
            <th class=\"tableh1\">id</th>
            <th class=\"tableh1\">Name</th>
            <th class=\"tableh1\">Title</th>
            <th class=\"tableh1\">Description</th>
            <th class=\"tableh1\">Type</th>
            <th class=\"tableh1\">URL</th>
            <th class=\"tableh1\">Actions</th>
        </TR>
     ";
    $c = count ($feeds);
    if ($c > 0) {
        for ($i = 0;$i<$c; $i++){
            if ($feeds[$i]['feed_mode']=="Realtime"){
                $url = "rss.php?fid=".$feeds[$i]['fid'];
            } else {
                $url = $feeds[$i]['file_name']{0}=='.' ? substr($feeds[$i]['file_name'],2) : $feeds[$i]['file_name'];
                $url = $feeds[$i]['file_name']{0}=='/' ? substr($feeds[$i]['file_name'],1) : $url;
            }
            if (strlen($feeds[$i]['feed_description'])>29) {
                $descr = substr($feeds[$i]['feed_description'],0,27)."...";
            } else {
                $descr = $feeds[$i]['feed_description'];
            }
            $kurl = $CONFIG['ecards_more_pic_target'].$url;
            $fid =$feeds[$i]['fid'];
            echo "\n\t<TR>";
            echo "<td class =\"tableb\">".$fid."</td>";
            echo "<td class =\"tableb\" width=\"15%\"><a href=\"?file=brainfeeder/brainfeeder_config&amp;cf_op=edit&amp;fid=".$fid."\">".$feeds[$i]['feed_name']."</a></td>";
            echo "<td class =\"tableb\" width=\"20%\"><a href=\"rss.php?fid=".$fid."\">".$feeds[$i]['feed_title']."</a></td>";
            echo "<td class =\"tableb\" title =\"".$feeds[$i]['feed_description']."\">".$descr."</td>";
            echo "<td class =\"tableb\">".$feeds[$i]['feed_type']."</td>";
            echo "<td class =\"tableb\">".$kurl."</td>";
            echo "<td class =\"tableb\"><a href=\"?file=brainfeeder/brainfeeder_config&amp;cf_op=delete&amp;fid=".$fid."\">
                    <img src=\"images/delete.gif\" title=\"delete feed\" border=\"0\" width=\"16\" height=\"16\" alt=\"delete.gif (603 bytes)\"></a> 
                    <a href=\"?file=brainfeeder/brainfeeder_config&amp;cf_op=edit&amp;fid=".$fid."\">
                    <img src=\"images/edit.gif\" title=\"edit feed\" border=\"0\" width=\"16\" height=\"16\" alt=\"edit.gif (603 bytes)\"></a> </td>\n\t</TR>";
        }
            echo "\n\t<TR>";
    }
     echo "<td class =\"tableh1\" colspan = \"7\">
              <a href=\"{$_SERVER['PHP_SELF']}?file=brainfeeder/brainfeeder_config&amp;cf_op=add\" {$makereadonly}class=\"admin_menu\">Add Feed</a>
              </td>";
    echo "</TABLE>";
}

function add_feed ($fields) {
    global $CONFIG;
     echo "
    <table align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"0\" class=\"maintable\">
        <TR>\n\t<TD class=\"tableh2\" colspan =\"2\">Configure channel-parameters</TD></TR>\n<TR>";
     echo build_form("insert", $fields);
     echo "</table>";
}

function edit_feed ($fields) {
    global $CONFIG;
    $fid = $_GET['fid'];
    $query = "SELECT * FROM ".$CONFIG['TABLE_brainfeeder']." WHERE fid=".$fid;
    $result = cpg_db_query($query);
    $row = cpg_db_fetch_row($result);
    foreach (array_keys($fields) as $field) {
        if (isset($row[$field])) {
            $fields[$field]['value'] = $row[$field];   //assumes that Coppermine sanitizes input 
        }
    }
     echo "
    <table align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"0\" class=\"maintable\">
        <TR>\n\t<TD class=\"tableh2\" colspan =\"2\">Edit channel-parameters</TD></TR>\n<TR>";
     echo build_form("update", $fields);
     echo "</table>";
}

function build_form($operation, $fields) {
    $ret = "<form action=\"". $_SERVER['PHP_SELF']."?file=brainfeeder/brainfeeder_config&cf_op=$operation\" method =\"POST\" enctype=\"multipart/form-data\">\n";
    foreach ($fields as $name=>$field) {
        $ret .= "<TR><TD class=\"tableb\"><a href=\"http://www.natvik.com/bfdoc/brainfeeder_doc.html#".$name."\" target=\"_blank\"><img src=\"images/help.gif\" width=\"13\" height=\"11\" border=\"0\" alt=\"\" title=\"\" /></a>&nbsp;".$field[0]."</TD>";   //caption
        switch ($field[1]) {
            case "input":
                $val=strlen($field['value'])>=1 ? $field['value'] : $field[3];
                $ret .= "<TD class=\"tableb\"><INPUT id=\"".$name."\" type =\"text\" name=\"".$name."\" class =\"textinput\" size =\"".$field[2]."\" maxlength =\"".$field[2]."\" value=\"". $val."\" /> ";
                break;
            case "textarea":
                $val=strlen($field['value'])>=1 ? $field['value'] : $field[3];
                $ret .= "<TD class=\"tableb\"> <TEXTAREA  id=\"".$name."\" class =\"textinput\" name=\"".$name."\" rows =\"".$val."\" cols=\"30\" >".$field['value']."</TEXTAREA>";
                break;
            case "yesno":
                $val=strlen($field['value'])>1 ? $field['value'] : $field[2];
                $checked = FALSE;
                $ret .= "<TD class=\"tableb\">Yes <INPUT id=\"".$name."\" class =\"radio\" type =\"radio\" name=\"".$name."\" value=\"Yes\"";
                        if ($val=='Yes') {   //takes priority over $field['2']
                            $ret .= " checked=\"Yes\"";
                            $checked = TRUE;
                        } elseif ($field[2]=="Yes") {
                            $ret .= " checked=\"Yes\"";
                            $checked = TRUE;
                        }
                        $ret .= " /> ";
                $ret .= "\tNo <INPUT id=\"".$name."\" class =\"radio\" type =\"radio\" name=\"".$name."\" value=\"No\"";
                        if (!$checked){
                            if ($val=='No') {   //takes priority over $field['2']
                                $ret .= " checked=\"Yes\"";
                            } elseif ($field[2]=="No") {
                                $ret .= " checked=\"Yes\"";
                            }
                        }
                        $ret .= " /> ";
                break;
            case "options":
                $val=strlen($field['value'])>=1 ? $field['value'] : $field[3];
                $ret .= "<TD  class=\"tableb\">";
                foreach ($field[2] as $opt) {
                    $ret .= $opt." <INPUT id=\"".$name."\" class =\"radio\" type =\"radio\" name=\"".$name."\" value=\"".$opt."\"";
                            if ($val==$opt) $ret .= " checked=\"yes\"";
                            $ret .= " /> ";
                }
                break;
            case "readonly":
                $val=strlen($field['value'])>=1 ? $field['value'] : $field[3];
                $ret .= "<TD class=\"tableb\"><INPUT id=\"".$name."\" type =\"text\" name=\"".$name."\" class =\"textinput\" size =\"".$field[2]."\" value =\"".$val."\" readonly=\"yes\" /> ";
                break;
        }
        $ret .= "</TD></TR>";
    }
    $ret .= "<TR><TD class =\"tableh2\" colspan =\"2\">
            <button name =\"send\" type =\"submit\" value = \"sent\">Go</button>
            </TD></TR>";
    $ret .= "</form>";
    return $ret;
}

function update_feed ($edit, $fields) {
    global $CONFIG;
    $sql_fields ="";
    $fields = array_keys($fields); //field names are in the keys. values are underlaying arrays.
    foreach ($fields as $field) {
        if (isset ($_POST[$field])) $sql_fields .= " ".$field."='".$_POST[$field]."',";
    }
    $sql_fields=substr($sql_fields,0,-1);    //remove last comma
    if ($edit=="insert") {
        $query = "INSERT ";
        $where ="";
    } else {
        $query = "UPDATE ";
        $where = " WHERE fid =".$_POST['fid']; 
    }
    $query .=  $CONFIG['TABLE_brainfeeder']." SET ". $sql_fields.$where;
    
 //   die ($query);
    $results=cpg_db_query($query);
}

function delete_feed () {
    global $CONFIG;
    $fid = $_GET['fid'];
    $query = "DELETE FROM ".$CONFIG['TABLE_brainfeeder']." WHERE fid=".$fid;
    $results=cpg_db_query($query);
}

function shorten($text="", $length=30) {
    if (strlen($text>$length)) {
                $ret = substr($text,0,$length-3)."...";
            } else {
                $ret = $text;
            }
    return $ret;
}

pagefooter();
ob_end_flush();
?>
