<?php

// -----------------------------------------------------------------------------------------
// DEFAULT PART - ONLY FOR INSTALL & UNINSTALL PLUGIN
// -----------------------------------------------------------------------------------------

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...'); 

// install action
$thisplugin->add_action('plugin_install' ,'adaptor_install');
// configure action
$thisplugin->add_action('plugin_configure', 'adaptor_configure');
// uninstall action
$thisplugin->add_action('plugin_uninstall', 'adaptor_uninstall');
// cleanup action 
$thisplugin->add_action('plugin_cleanup', 'adaptor_cleanup');

function adaptor_sql($title, $sqlFile) {
	global $CONFIG;	
	require ('include/sql_parse.php');  	
	$sql_query = fread(fopen($sqlFile, 'r'), filesize($sqlFile));
	$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';'); 			
    echo <<<EOT
    	<h2>$title</h2>
        <table class="maintable" border="0" cellspacing="1" cellpadding="0">        
EOT;
	foreach($sql_query as $q) {
		echo "<tr><td class='debug_text' style='color: black;'>$q</td>";
		if (mysql_query($q)) {
        	echo "<td class='debug_text' style='color: green;'>OK</td></tr>";
        } else {
        	echo "<td class='debug_text' style='color: black;'>Already Done</td></tr>";
        }
	}
	echo '</table>';
}

function adaptor_install() {
    // install
    if (isset($_REQUEST['submit']) && $_REQUEST['submit'] == 'GO!') {
        return true;
    } else {
        return 1;
    }
}

function adaptor_configure($stop=true) {
    global $errors, $CONFIG;    
    adaptor_sql('Performing database updates','plugins/adaptor/sql/install.sql');
    if ($stop) {
        echo <<< EOT
        <form action="{$_SERVER['REQUEST_URI']}" method="post">
            <input class="button" type="submit" value="GO!" name="submit" />
        </form>
EOT;
    }
}

function adaptor_cleanup($action) {
    if ($action === 1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            Do you want to drop the plugin's current database ?
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="1" /></td>
                <td>YES</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" value="0" /></td>
                <td>NO</td>
            </tr>
        </table>
        </div>
        <span>
           <input class="button" type="submit" name="submit" value="Submit" /> &nbsp;&nbsp;&nbsp;
            <input class="button" type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="Cancel" />
        </span>
    </form>
EOT;
    }
}

function adaptor_uninstall() {
	global $CONFIG;
    if (!isset($_POST['drop'])) return 1;
    if ($_POST['drop']) {    	    	
		adaptor_sql('Drop the database', 'plugins/adaptor/sql/uninstall.sql');		
    }		   
    return true;
}

// -----------------------------------------------------------------------------------------
// SUB PART - FOR FUNCTION THAT MAKE ADMIN|USER BUTTON, REDIRECT ...
// -----------------------------------------------------------------------------------------

function adaptor_admin_button($href, $title, $target, $link, $before='documentation') {
	global $template_gallery_admin_menu;
	$newTemplate = $template_gallery_admin_menu;
	$button = template_extract_block($newTemplate, $before);
	$beforeU = strtoupper($before);
	$params = array(
      "{{$beforeU}_HREF}" => $href,
      "{{$beforeU}_TITLE}" => $title,
      "target=\"cpg_$before\"" => $target,
      "{{$beforeU}_LNK}" => $link,
   	);
	$newButton="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";	
	template_extract_block($template_gallery_admin_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $newButton);	
}

function adaptor_sub_user_button($href, $title, $target, $link, $before='custom_link') {
	global $template_sub_menu;	
	$newTemplate = $template_sub_menu;
    $button = template_extract_block($newTemplate, $before);
    switch ($before) {
    	case 'custom_link':	
    		$beforeU = 'CUSTOM_LNK';
    		break;
    	case 'album_list':
    		$beforeU = 'ALB_LIST';
    		break;
    	case 'favpics':
    		$beforeU = 'FAV';
    		break;
    	default:
    	    $beforeU = strtoupper($before);    	
	}
    $params = array(      
      "{{$beforeU}_LNK}" => $link,
      "{{$beforeU}_TITLE}" => $title,      
      "{{$beforeU}_TGT}" => $href,
   	);
    $newButton="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
    template_extract_block($template_sub_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $newButton);
}

function adaptor_sys_user_button($href, $title, $target, $link, $before='my_gallery') {
	global $template_sys_menu;	
	$newTemplate = $template_sys_menu;
    $button = template_extract_block($newTemplate, $before);
    switch ($before) {
    	case 'my_gallery':	
    		$beforeU = 'MY_GAL';
    		break;
    	case 'allow_memberlist':
    		$beforeU = 'MEMBERLIST';
    		break;
    	case 'enter_admin_mode':
    		$beforeU = 'ADM_MODE';
    		break;
    	case 'leave_admin_mode':
    		$beforeU = 'USR_MODE';
    		break;
    	case 'upload_pic':
    		$beforeU = 'UPL_PIC';
    		break;    		
    	default:
    	    $beforeU = strtoupper($before);    	
	}
    $params = array(      
      "{{$beforeU}_LNK}" => $link,
      "{{$beforeU}_TITLE}" => $title,      
      "{{$beforeU}_TGT}" => $href,
   	);
    $newButton="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
    template_extract_block($template_sys_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $newButton);
}

if (!function_exists('adaptor_redirect')) {
	function adaptor_redirect($link, $type='js') {	
		// PHP redirect
		if ($type == 'php') {
        	header("Location: $link");
		} elseif ($type == 'js') {
        	echo "<script language=\"javascript\" type=\"text/javascript\">window.location='$link';</script>";
		} else {
		// HTML redirect
			echo "<html><head><meta http-equive=\"refresh\" content=\"2; URL=$link\"></head></html>";			
		}
	}
}

// -----------------------------------------------------------------------------------------
// MAIN PART - EVERYTHING START HERE
// ----------------------------------------------------------------------------------------- 

// page start action
$thisplugin->add_action('page_start', 'adaptor_start');

function adaptor_start() {
	global $CONFIG;	      
	// forum administator button		
	adaptor_admin_button('forum.admin.php','Forum Manager','','Forum Manager');
	adaptor_sys_user_button('forum.php','Forum','','Forum');	
}
 
?>