<?php
/**************************************************
  Coppermine 1.4 Plugin - Custom Home
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add an install & configure & uninstall actions
$thisplugin->add_action('plugin_install','customhome_install');
$thisplugin->add_action('plugin_configure','customhome_configure');
$thisplugin->add_action('plugin_uninstall','customhome_uninstall');
$thisplugin->add_action('plugin_cleanup','customhome_cleanup');

// Add the main filter - replace home link with group-specific category
$thisplugin->add_filter('page_html','customhome_replacehome');

// Add actions
$thisplugin->add_action('page_start','customhome_page_start');

// Install Plugin
function customhome_install() 
{
	global $CONFIG, $lang_plugin_customhome, $lang_plugin_customhome_config, $thisplugin;
	require ('plugins/custom_home/include/init.inc.php');
	
	if ($_POST['submit']==$lang_plugin_customhome_config['button_install']) {
		require 'include/sql_parse.php';
    
		// create table	
		$db_schema = $thisplugin->fullpath . '/schema.sql';
		$sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
		$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

		$sql_query = remove_remarks($sql_query);
		$sql_query = split_sql_file($sql_query, ';');
		
		foreach($sql_query as $q) { 
			cpg_db_query($q);
		}

		return true;
	} else {
		return 1;
	}
}

// Configure Plugin
function customhome_configure() 
{
	global $CONFIG, $lang_plugin_customhome, $lang_plugin_customhome_config;
	require ('plugins/custom_home/include/init.inc.php');

	echo <<< EOT
		<h2>{$lang_plugin_customhome['install_click']}</h2>
		{$lang_plugin_customhome['install_note']}<br />
		<br />
		<form action="{$_SERVER['REQUEST_URI']}" method="post">
		<input type="submit" value="{$lang_plugin_customhome_config['button_install']}" name="submit" />
		</form>
EOT;
}

// Uninstall (ask admin about dropping table)
function customhome_uninstall()
{
	global $CONFIG;
	
	if (!isset($_POST['drop'])) return 1;
	
	if ($_POST['drop']) {
		cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PLUGIN_CUSTOMHOME']}");
   	}
	
	return true;
}

// Ask if admin wants to drop the table
function customhome_cleanup($action) 
{
    global $lang_plugin_customhome_config;
    require ('plugins/custom_home/include/init.inc.php');

    if ($action===1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            {$lang_plugin_customhome_config['cleanup_question']}
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" value="1" /></td>
                <td>Yes</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="0" /></td>
                <td>No</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="{$lang_plugin_customhome_config['button_submit']}" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="{$lang_plugin_customhome_config['button_cancel']}" />
        </span>
    </form>
EOT;
    }
}

// add config button
function customhome_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// add admin button to start of each page
function customhome_page_start()
{
	global $CONFIG, $lang_plugin_customhome, $lang_plugin_customhome_config;
	require ('plugins/custom_home/include/init.inc.php');

	$CONFIG['TABLE_PLUGIN_CUSTOMHOME'] = $CONFIG['TABLE_PREFIX'].'plugin_customhome';

	if (GALLERY_ADMIN_MODE) {
		customhome_add_config_button('index.php?file=custom_home/plugin_config',$lang_plugin_customhome['config_title'],'',$lang_plugin_customhome['config_button']);
	}
}

// Replace Home link with admin-set group category
function customhome_replacehome($html) 
{
	global $CONFIG, $lang_main_menu;

	if (defined('USER_ID') && USER_ID) {
		$user_id = USER_ID;
		$sql = "SELECT `user_group`, `user_group_list` FROM `{$CONFIG['TABLE_USERS']}` WHERE `user_id`='{$user_id}' LIMIT 1;";
		$result = cpg_db_query($sql);
		$user_groups = mysql_fetch_array($result);
		$user_group = $user_groups['user_group'];
		$user_group_list = $user_groups['user_group_list'];
		if ($user_group_list && (count(explode(',',$user_group_list)) == 1)) {
			$user_group = $user_group_list;
		}
		mysql_free_result($result);
	} else {
		$user_group = 3;  // guests group
	}

	$sql = "SELECT `cat_id` FROM `{$CONFIG['TABLE_PLUGIN_CUSTOMHOME']}` WHERE `group_id`='{$user_group}' LIMIT 1;";
	$result = mysql_query($sql);
	$group_cat = mysql_fetch_array($result);
	$group_cat = $group_cat[0];
	mysql_free_result($result);

	if ($group_cat) { 
		$html = preg_replace('@(?U)(<a.*\s*.*href=).+(.*'.$lang_main_menu['home_lnk'].'.*<\/a>)@','$1"index.php?cat='.$group_cat.'"$2',$html);
	}
	return $html;
}

?>
