<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2008 Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

  ********************************************
  Coppermine version: 1.4.x
  $HeadURL$
  $Revision$
  $LastChangedBy$
  $Date$
**********************************************/
/*********************************************
  Coppermine Plugin - Group Pictures
  ********************************************
  Copyright (c) 2009 eenemeenemuu
**********************************************/


if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

$thisplugin->add_action('plugin_install', 'group_pictures_install');

function group_pictures_install() {
    global $CONFIG;
    cpg_db_query("INSERT INTO {$CONFIG['TABLE_CONFIG']} (name,value) VALUES ('group_pictures_criteria','pid')");
    return true;
}


$thisplugin->add_action('plugin_uninstall', 'group_pictures_uninstall');

function group_pictures_uninstall() {
    global $CONFIG;
    cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name LIKE 'group_pictures_%'");
    return true;
}


function group_pictures_get_criteria_array() {
    global $CONFIG;
    if (!$CONFIG['group_pictures_criteria']) {
        return false;
    }
    $criteria = explode(" ",$CONFIG['group_pictures_criteria']);
    return $criteria;
}


function group_pictures_get_pids() {
    global $CONFIG;

    // get files with same group criteria 
    $query = "SELECT ".implode(", ", group_pictures_get_criteria_array()).", COUNT(*) as count FROM {$CONFIG['TABLE_PICTURES']} GROUP BY ".implode(", ", group_pictures_get_criteria_array())." HAVING count > 1";
    $result = cpg_db_query($query);
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
        $where_array = array();
        foreach(group_pictures_get_criteria_array() as $value) {
            $where_array[] = "{$value} = '{$row[$value]}'";
        }
        // get latest file
        $query = "SELECT MAX(pid) as pid FROM {$CONFIG['TABLE_PICTURES']} WHERE ".implode(" AND ", $where_array);
        $row = mysql_fetch_array(cpg_db_query($query), MYSQL_ASSOC);
        $pids[] = $row['pid'];
    }

    // get other files
    $query = "SELECT pid, COUNT(*) as count FROM {$CONFIG['TABLE_PICTURES']} GROUP BY ".implode(", ", group_pictures_get_criteria_array())." HAVING count = 1";
    $result = cpg_db_query($query);
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
        $pids[] = $row['pid'];
    }

    $pids = implode (", ", $pids);
    $pids = " AND pid IN ({$pids})";

    return $pids;
}


// config page
$thisplugin->add_action('page_start', 'group_pictures_page_start');

function group_pictures_page_start() {
    if ($_GET['plugin_config'] == "group_pictures") {
        global $CONFIG;

        load_template();
        pageheader('Group Pictures Config');

        if (isset($_POST['commit'])) {
            $criteria = implode(" ", $_POST['group_pictures_criteria']);
            starttable('100%', 'Group Pictures Config');
            
            if (!$criteria) {
                echo "<tr><td class=\"tableb\">Your settings have <b>not</b> been saved!<br /><br />You have to select at least one value.<br /><br /><a href=\"javascript:history.back();\" class=\"button\">Back</a></td></tr>";
            } else {
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$criteria}' WHERE name = 'group_pictures_criteria'");
                $criteria = implode(" & ", $_POST['group_pictures_criteria']);
                echo "<tr><td class=\"tableb\">Your settings have been saved!<br /><br />Pictures will be grouped by {$criteria}.<br /><br /><a href=\"index.php?plugin_config=group_pictures\" class=\"button\">Continue</a></td></tr>";
            }
            endtable();
            pagefooter();
            exit;
        }

        echo '<form method="post">';
        starttable('100%', 'Group Pictures Config');

        $result = cpg_db_query("SELECT * FROM {$CONFIG['TABLE_PICTURES']}");
        for ($i = 0; $i < mysql_num_fields($result); $i++) {
            $field_name = mysql_field_name($result, $i);
            if (in_array($field_name, group_pictures_get_criteria_array())) {
                $selected = " selected=\"selected\"";
            } else {
                $selected = "";
            }
            $options .= "<option{$selected}>{$field_name}</option>";
        }
    
        echo <<< EOT
<tr>
	<td class="tableb">
        Select one or more criteria your pictures should grouped by. <br /> To select more criteria hold down your CTRL key. <br />
        <select name="group_pictures_criteria[]" class="listbox" multiple>
            $options
        </select>
        <br />
		<input type="submit" name="commit" class="button" value="Save"/>
	</td>
</tr>

EOT;
        endtable();
        echo '</form>';
        pagefooter();
        exit;
    }
}



if (defined('THUMBNAILS_PHP')) {
    // display number of grouped pictures in title when watching regular album
    $thisplugin->add_filter('thumb_caption_regular', 'group_pictures_thumb_caption_regular');
    // display number of grouped pictures in title when watching meta album 'lastup'
    $thisplugin->add_filter('thumb_caption_lastup', 'group_pictures_thumb_caption_regular');

    function group_pictures_thumb_caption_regular($rowset) {
        global $CONFIG;

        // get files with same group criteria
        $query = "SELECT ".implode(", ", group_pictures_get_criteria_array()).", COUNT(*) as count FROM {$CONFIG['TABLE_PICTURES']} GROUP BY ".implode(", ", group_pictures_get_criteria_array())." HAVING count > 1";
        $result = cpg_db_query($query);
        $rowset_length = count($rowset);
        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
            for ($i = 0; $i < $rowset_length; $i++) {
                $match = true;
                foreach(group_pictures_get_criteria_array() as $value) {
                    if ($row[$value] != $rowset[$i][$value]) {
                        $match = false;
                    }
                }
                if ($match == true) {
                    $rowset[$i]['caption_text'] = preg_replace("/(<span class=\"thumb_title\">{$rowset[$i]['title']})(<\/span>)/", "\\1 ({$row['count']}) \\2", $rowset[$i]['caption_text']); 
                }
            }
        }

        return $rowset;
    }
}




if (defined('DISPLAYIMAGE_PHP')) {
    // show thumbs of other grouped pictures
    $thisplugin->add_filter('page_html', 'group_pictures_page_html');

    function group_pictures_page_html($html) {
        global $CONFIG, $CURRENT_PIC_DATA;

        $search = "/(<div id=\"picinfo\".*)/Uis";

        // search for other files with same group criteria
        $where_array = array();
        foreach(group_pictures_get_criteria_array() as $value) {
            $where_array[] = "{$value} = '{$CURRENT_PIC_DATA[$value]}'";
        }
        $query = "SELECT * FROM {$CONFIG['TABLE_PICTURES']} WHERE pid != '{$CURRENT_PIC_DATA['pid']}' AND ".implode(" AND ", $where_array);
        $result = cpg_db_query($query);

        // create links
        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
            $new_html .= "<a href=\"displayimage.php?pos=-{$row['pid']}\"><img src=\"".get_pic_url($row, 'thumb')."\" class=\"image\" /></a>";
        }

        if (isset($new_html)) {
            $new_html = <<<EOT
<!-- Start standard table -->
<table align="center" width="{$CONFIG['picture_table_width']}" cellspacing="1" cellpadding="0" class="maintable">
        <tr>
                <td class="tableh1"><b>Other pictures of this vessel</b></td>
        </tr>
        <tr>
                <td class="tableb" align="left">$new_html</td>
        </tr>
</table>
EOT;
        }

        $html = preg_replace($search, $new_html."\\1", $html);

        return $html;
    }
} else {
    // modify stats
    $thisplugin->add_filter('page_html', 'group_pictures_page_html');

    function group_pictures_page_html($html) {
        global $CONFIG, $FORBIDDEN_SET, $cpg_show_private_album, $lang_list_categories;

        $pic_filter = '';
        if (!empty($FORBIDDEN_SET) && !$cpg_show_private_album) {
            $pic_filter = ' and ' . $FORBIDDEN_SET;
        }        

        // get picture count
        $sql = "SELECT COUNT(*) FROM {$CONFIG['TABLE_PICTURES']} WHERE 1 {$pic_filter} AND approved='YES'";
        $result = cpg_db_query($sql);
        $nbEnr = mysql_fetch_array($result);
        $picture_count = $nbEnr[0];
        mysql_free_result($result);

        // get unique picture count
        $sql = "SELECT DISTINCT ".implode(", ", group_pictures_get_criteria_array())." FROM {$CONFIG['TABLE_PICTURES']} WHERE 1 {$pic_filter} AND approved='YES'";
        $result = cpg_db_query($sql);
        $picture_count_unique = mysql_num_rows($result);
        mysql_free_result($result);

        // get the word that's behind the picture count
        $search = "/<b>\[pictures\]<\/b> (\w+) /Uis";
        preg_match($search, $lang_list_categories['stat2'], $matches);
        $word = $matches[1];

        // replace picture count with picture+unique picture count
        $search = "<b>{$picture_count}</b> {$word}";
        $new_html = "<b>{$picture_count}</b> pictures of <b>{$picture_count_unique}</b> vessels";
        $html = str_replace($search, $new_html, $html);

        return $html;
    }
}

?>