/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import wjhk.jupload2.JavascriptHandler;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.JUploadTextArea;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;

public class JUploadApplet
extends Applet {
    private static final long serialVersionUID = -3207851532114846776L;
    private static final String svnPropertiesFilename = "/conf/svn.properties";
    private Properties svnProperties = JUploadApplet.getSvnProperties();
    private JavascriptHandler jsHandler = null;
    private final String RELEASE_VERSION = "4.3.2";
    @Deprecated
    public final String BUILD_DATE = this.svnProperties.getProperty("buildDate");
    private UploadPolicy uploadPolicy = null;
    private JUploadPanel jUploadPanel = null;
    private JUploadTextArea logWindow = null;
    private Vector<Callback> unloadCallbacks = new Vector();

    public String getVersion() {
        try {
            return this.RELEASE_VERSION + " [SVN-Rev: " + this.svnProperties.getProperty("revision") + "]";
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in JUploadApplet.getVersion()");
            return this.RELEASE_VERSION;
        }
    }

    public String getLastModified() {
        try {
            return this.svnProperties.getProperty("lastSrcDirModificationDate");
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in JUploadApplet.getLastModified()");
            return "Unknown";
        }
    }

    public String getBuildDate() {
        try {
            return this.svnProperties.getProperty("buildDate");
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in JUploadApplet.getBuildDate()");
            return "Unknown";
        }
    }

    public void init() {
        try {
            this.logWindow = new JUploadTextArea(20, 20);
            this.uploadPolicy = UploadPolicyFactory.getUploadPolicy(this);
            this.setLayout(new BorderLayout());
            this.jUploadPanel = new JUploadPanel(this, this.logWindow, this.uploadPolicy);
            this.add((Component)this.jUploadPanel, "Center");
            this.jsHandler = new JavascriptHandler(this.uploadPolicy, this.jUploadPanel);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
            JOptionPane.showMessageDialog(null, "Error during applet initialization!\nHave a look in your Java console.", "Error", 0);
        }
    }

    public void start() {
        this.uploadPolicy.displayInfo("JUploadApplet is now started.");
    }

    public JUploadTextArea getLogWindow() {
        return this.logWindow;
    }

    public JUploadPanel getUploadPanel() {
        return this.jUploadPanel;
    }

    public UploadPolicy getUploadPolicy() {
        return this.uploadPolicy;
    }

    public void setProperty(String prop, String value) {
        try {
            for (int i = 0; i < 20 && this.uploadPolicy == null; ++i) {
                this.wait(100L);
            }
            if (this.uploadPolicy == null) {
                System.out.println("uploadPolicy is null. Impossible to set " + prop + " to " + value);
            } else {
                this.uploadPolicy.setProperty(prop, value);
            }
        }
        catch (Exception e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    public String startUpload() {
        return this.jsHandler.doCommand("startUpload");
    }

    public void displayErr(String err) {
        this.uploadPolicy.displayErr(err);
    }

    public void displayInfo(String info) {
        this.uploadPolicy.displayInfo(info);
    }

    public void displayWarn(String warn) {
        this.uploadPolicy.displayWarn(warn);
    }

    public void displayDebug(String debug, int minDebugLevel) {
        this.uploadPolicy.displayDebug(debug, minDebugLevel);
    }

    public void stop() {
        this.runUnload();
    }

    public static void main(String[] args) {
        JUploadApplet juploadApplet = new JUploadApplet();
        System.out.println(juploadApplet.RELEASE_VERSION);
    }

    public static Properties getSvnProperties() {
        Properties properties = new Properties();
        Boolean bPropertiesLoaded = false;
        try {
            properties.load(Class.forName("wjhk.jupload2.JUploadApplet").getResourceAsStream(svnPropertiesFilename));
            bPropertiesLoaded = true;
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in JUploadApplet.getSvnProperties() (" + e.getMessage() + ")");
        }
        if (!bPropertiesLoaded.booleanValue()) {
            properties.setProperty("buildDate", "Unknown build date (please use the build.xml ant script)");
            properties.setProperty("lastSrcDirModificationDate", "Unknown last modification date (please use the build.xml ant script)");
            properties.setProperty("revision", "Unknown revision (please use the build.xml ant script)");
        }
        return properties;
    }

    public void registerUnload(Object o, String method) {
        this.unloadCallbacks.add(new Callback(o, method));
    }

    private void runUnload() {
        Iterator<Callback> i = this.unloadCallbacks.iterator();
        while (i.hasNext()) {
            try {
                i.next().invoke();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.unloadCallbacks.clear();
    }

    public void destroy() {
        this.runUnload();
    }

    private class Callback {
        private String m;
        private Object o;

        Callback(Object o, String m) {
            this.o = o;
            this.m = m;
        }

        void invoke() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException {
            Object[] args = new Object[]{};
            Method[] methods = this.o.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(this.m)) continue;
                methods[i].invoke(this.o, args);
            }
        }
    }
}

