/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.policies.PictureUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;

public class CoppermineUploadPolicy
extends PictureUploadPolicy {
    private int albumId;
    private int nbPictureInUpload = 0;

    public CoppermineUploadPolicy(JUploadApplet theApplet) throws JUploadException {
        super(theApplet);
        this.albumId = UploadPolicyFactory.getParameter(theApplet, "albumId", 0, (UploadPolicy)this);
    }

    public void onFileSelected(FileData fileData) {
        if (fileData == null) {
            super.onFileSelected(fileData);
        } else if (fileData instanceof PictureFileData) {
            super.onFileSelected(fileData);
        } else {
            super.onFileSelected(null);
        }
    }

    public void setProperty(String prop, String value) throws JUploadException {
        this.displayDebug("[CoppermineUploadPolicy] Call of setProperty: " + prop + " => " + value, 30);
        if (prop.equals("albumId")) {
            this.albumId = UploadPolicyFactory.parseInt(value, 0, this);
            this.displayDebug("Post URL (modified in CoppermineUploadPolicy) = " + this.getPostURL(), 10);
        } else {
            super.setProperty(prop, value);
        }
    }

    public String getPostURL() {
        String postURL = super.getPostURL();
        return postURL + (postURL.contains("?") ? "&" : "?") + "album=" + this.albumId;
    }

    public String getUploadName(FileData fileData, int index) {
        return "userpicture";
    }

    public boolean isUploadReady() {
        if (this.albumId <= 0) {
            this.alert("chooseAlbumFirst");
            return false;
        }
        this.nbPictureInUpload = this.getApplet().getUploadPanel().getFilePanel().getFilesLength();
        return super.isUploadReady();
    }

    public void afterUpload(Exception e, String serverOutput) throws JUploadException {
        int nbPictureAfterUpload = this.getApplet().getUploadPanel().getFilePanel().getFilesLength();
        if (nbPictureAfterUpload > this.nbPictureInUpload) {
            this.displayErr("CoppermineUploadPolicy.afterUpload: The number of uploaded files is negative! (" + (this.nbPictureInUpload - nbPictureAfterUpload) + ")");
        } else if (nbPictureAfterUpload == this.nbPictureInUpload) {
            this.displayWarn("CoppermineUploadPolicy.afterUpload: No file were uploaded! (" + (nbPictureAfterUpload - this.nbPictureInUpload) + ")");
        } else if (this.getDebugLevel() >= 100) {
            this.alertStr("No switch to property page, because debug level is " + this.getDebugLevel() + " (>=100)");
        } else if (e == null) {
            this.alert("coppermineUploadOk");
            this.setAfterUploadURL(this.getPostURL().substring(0, this.getPostURL().lastIndexOf(47)) + "/jupload&action=edit_uploaded_pics&album=" + this.albumId + "&nb_pictures=" + (this.nbPictureInUpload - nbPictureAfterUpload));
            super.afterUpload(e, serverOutput);
        }
    }

    public void displayParameterStatus() {
        super.displayParameterStatus();
        this.displayDebug("======= Parameters managed by CoppermineUploadPolicy", 30);
        this.displayDebug("albumId : " + this.albumId, 30);
        this.displayDebug("", 30);
    }
}

