/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;
import wjhk.jupload2.upload.helper.ByteArrayEncoderHTTP;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;
import wjhk.jupload2.upload.helper.HttpConnect;

public class DefaultUploadPolicy
implements UploadPolicy {
    private JUploadApplet applet = null;
    private String afterUploadURL = UploadPolicy.DEFAULT_AFTER_UPLOAD_URL;
    private boolean allowHttpPersistent = false;
    private String allowedFileExtensions = UploadPolicy.DEFAULT_ALLOWED_FILE_EXTENSIONS;
    private String showLogWindow = "true";
    private boolean showStatusbar = true;
    private String specificHeaders = null;
    private File currentBrowsingDirectory = null;
    private boolean debugGenerateFile = false;
    private int debugLevel = 0;
    private int fileChooserIconFromFileContent = 0;
    private int fileChooserIconSize = 20;
    private String filenameEncoding = UploadPolicy.DEFAULT_FILENAME_ENCODING;
    private boolean ftpCreateDirectoryStructure = false;
    private boolean ftpTransfertBinary = true;
    private boolean ftpTransfertPassive = true;
    private String lang = UploadPolicy.DEFAULT_LANG;
    private JUploadException lastException = null;
    private String lookAndFeel = "";
    private int nbFilesPerRequest = 1;
    private long maxChunkSize = Long.MAX_VALUE;
    private long maxFileSize = Long.MAX_VALUE;
    private String postURL = UploadPolicy.DEFAULT_POST_URL;
    private boolean readCookieFromNavigator = true;
    private String serverProtocol = "HTTP/1.1";
    private String stringUploadError = "^ERROR: (.*)$";
    private String stringUploadSuccess = "^SUCCESS$";
    private String stringUploadWarning = "^WARNING: (.*)$";
    private String urlToSendErrorTo = UploadPolicy.DEFAULT_URL_TO_SEND_ERROR_TO;
    private String formData = UploadPolicy.DEFAULT_FORMDATA;
    private String afterUploadTarget = UploadPolicy.DEFAULT_AFTER_UPLOAD_TARGET;
    private String lastResponseBody = null;
    private String lastResponseMessage = null;
    private int sslVerifyCert = 0;
    private final String CRLF = System.getProperty("line.separator");
    private Vector<String> headers = new Vector();
    private ResourceBundle resourceBundle = null;
    protected PrintStream debugOut = null;
    protected File debugFile = null;
    protected boolean debugOk = true;
    protected String cookie = null;
    protected String userAgent = null;
    protected Pattern patternError = Pattern.compile("^ERROR: (.*)$");
    protected Pattern patternSuccess = Pattern.compile("^SUCCESS$");
    protected Pattern patternWarning = Pattern.compile("^WARNING: (.*)$");

    public DefaultUploadPolicy(JUploadApplet theApplet) throws JUploadException {
        this.applet = theApplet;
        this.displayInfo("JUpload applet started, with " + this.getClass().getName() + " upload policy");
        this.setDebugLevel(UploadPolicyFactory.getParameter(theApplet, "debugLevel", 0, (UploadPolicy)this), false);
        this.setLang(UploadPolicyFactory.getParameter(theApplet, "lang", DEFAULT_LANG, (UploadPolicy)this));
        this.setLookAndFeel(UploadPolicyFactory.getParameter(theApplet, "lookAndFeel", "", (UploadPolicy)this));
        this.setSslVerifyCert(UploadPolicyFactory.getParameter(theApplet, "sslVerifyCert", "none", (UploadPolicy)this));
        this.setAfterUploadURL(UploadPolicyFactory.getParameter(theApplet, "afterUploadURL", DEFAULT_AFTER_UPLOAD_URL, (UploadPolicy)this));
        this.setFtpCreateDirectoryStructure(UploadPolicyFactory.getParameter(theApplet, "ftpCreateDirectoryStructure", false, (UploadPolicy)this));
        this.setFtpTransfertBinary(UploadPolicyFactory.getParameter(theApplet, "ftpTransfertBinary", true, (UploadPolicy)this));
        this.setFtpTransfertPassive(UploadPolicyFactory.getParameter(theApplet, "ftpTransfertPassive", true, (UploadPolicy)this));
        this.setAllowedFileExtensions(UploadPolicyFactory.getParameter(theApplet, "allowedFileExtensions", DEFAULT_ALLOWED_FILE_EXTENSIONS, (UploadPolicy)this));
        this.setAllowHttpPersistent(UploadPolicyFactory.getParameter(theApplet, "allowHttpPersistent", false, (UploadPolicy)this));
        this.setShowStatusbar(UploadPolicyFactory.getParameter(theApplet, "showStatusbar", true, (UploadPolicy)this));
        this.setShowLogWindow(UploadPolicyFactory.getParameter(theApplet, "showLogWindow", "true", (UploadPolicy)this));
        this.setFileChooserIconFromFileContent(UploadPolicyFactory.getParameter(theApplet, "fileChooserIconFromFileContent", 0, (UploadPolicy)this));
        this.setFileChooserIconSize(UploadPolicyFactory.getParameter(theApplet, "fileChooserIconSize", 20, (UploadPolicy)this));
        this.setCurrentBrowsingDirectory(UploadPolicyFactory.getParameter(theApplet, "browsingDirectory", DEFAULT_BROWSING_DIRECTORY, (UploadPolicy)this));
        this.setFilenameEncoding(UploadPolicyFactory.getParameter(theApplet, "filenameEncoding", DEFAULT_FILENAME_ENCODING, (UploadPolicy)this));
        this.setNbFilesPerRequest(UploadPolicyFactory.getParameter(theApplet, "nbFilesPerRequest", 1, (UploadPolicy)this));
        this.setMaxChunkSize(UploadPolicyFactory.getParameter(theApplet, "maxChunkSize", Long.MAX_VALUE, (UploadPolicy)this));
        this.setMaxFileSize(UploadPolicyFactory.getParameter(theApplet, "maxFileSize", Long.MAX_VALUE, (UploadPolicy)this));
        this.setPostURL(UploadPolicyFactory.getParameter(theApplet, "postURL", DEFAULT_POST_URL, (UploadPolicy)this));
        this.setSpecificHeaders(UploadPolicyFactory.getParameter(theApplet, "specificHeaders", DEFAULT_SPECIFIC_HEADERS, (UploadPolicy)this));
        this.setStringUploadError(UploadPolicyFactory.getParameter(theApplet, "stringUploadError", "^ERROR: (.*)$", (UploadPolicy)this));
        this.setStringUploadSuccess(UploadPolicyFactory.getParameter(theApplet, "stringUploadSuccess", "^SUCCESS$", (UploadPolicy)this));
        this.setStringUploadWarning(UploadPolicyFactory.getParameter(theApplet, "stringUploadWarning", "^WARNING: (.*)$", (UploadPolicy)this));
        this.setUrlToSendErrorTo(UploadPolicyFactory.getParameter(theApplet, "urlToSendErrorTo", DEFAULT_URL_TO_SEND_ERROR_TO, (UploadPolicy)this));
        this.formData = UploadPolicyFactory.getParameter(theApplet, "formdata", DEFAULT_FORMDATA, (UploadPolicy)this);
        this.afterUploadTarget = UploadPolicyFactory.getParameter(theApplet, "afterUploadTarget", DEFAULT_AFTER_UPLOAD_TARGET, (UploadPolicy)this);
        this.setReadCookieFromNavigator(UploadPolicyFactory.getParameter(theApplet, "readCookieFromNavigator", true, (UploadPolicy)this));
        try {
            this.cookie = this.getReadCookieFromNavigator() ? (String)JSObject.getWindow((Applet)this.getApplet()).eval("document.cookie") : null;
            this.userAgent = (String)JSObject.getWindow((Applet)this.getApplet()).eval("navigator.userAgent");
            this.displayDebug("cookie: " + this.cookie, 30);
            this.displayDebug("userAgent: " + this.userAgent, 30);
        }
        catch (JSException e) {
            this.displayWarn("JSException (" + e.getClass() + ": " + e.getMessage() + ") in DefaultUploadPolicy, trying default values.");
            this.cookie = System.getProperty("debug_cookie");
            this.userAgent = System.getProperty("debug_agent");
            this.displayDebug("  no navigator found, reading 'debug_cookie' from system properties (" + this.cookie + ")", 30);
            this.displayDebug("  no navigator found, reading 'debug_agent' from system properties (" + this.userAgent + ")", 30);
        }
        if (this.cookie != null) {
            this.addHeader("Cookie: " + this.cookie);
        }
        if (this.userAgent != null) {
            this.addHeader("User-Agent: " + this.userAgent);
        }
        this.setServerProtocol(UploadPolicyFactory.getParameter(theApplet, "serverProtocol", null, (UploadPolicy)this));
        this.displayDebug("[DefaultUploadPolicy] end of constructor (serverProtocol has been set)", 30);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public void beforeUpload() {
    }

    public boolean checkUploadSuccess(int status, String msg, String body) throws JUploadException {
        boolean bReturn = false;
        if (this.getDebugLevel() > 100) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.lastResponseBody = body;
        this.lastResponseMessage = msg;
        this.displayDebug("HTTP status: " + msg, 30);
        if (status != 200 && status != 100) {
            throw new JUploadExceptionUploadFailed("Received HTTP status " + msg);
        }
        Pattern p = Pattern.compile("[\\r\\n]", 8);
        String[] lines = p.split(body);
        StringBuffer sbBodyWithUniformCRLF = new StringBuffer(body.length());
        for (int i = 0; i < lines.length; ++i) {
            Matcher matcherWarning;
            Matcher matcherError;
            String line = lines[i];
            sbBodyWithUniformCRLF.append(line).append("\r\n");
            if (line == null || line.equals("")) continue;
            if (this.getStringUploadSuccess() != null && !this.getStringUploadSuccess().equals("") && this.patternSuccess.matcher(line).matches()) {
                bReturn = true;
            }
            if (this.getStringUploadError() != null && !this.getStringUploadError().equals("") && (matcherError = this.patternError.matcher(line)).matches()) {
                String errmsg = "An error occurs during upload (but the applet couldn't find the error message)";
                if (matcherError.groupCount() > 0 && !matcherError.group(1).equals("")) {
                    errmsg = matcherError.group(1);
                    int maxLineLength = 80;
                    StringBuffer sbErrMsg = new StringBuffer();
                    int j = 0;
                    int remaining = errmsg.length();
                    while (remaining > 0) {
                        if (remaining <= maxLineLength) {
                            sbErrMsg.append(errmsg.substring(j * maxLineLength));
                        } else {
                            sbErrMsg.append(errmsg.substring(j * maxLineLength, (j + 1) * maxLineLength));
                        }
                        sbErrMsg.append("\n");
                        remaining -= maxLineLength;
                        ++j;
                    }
                    errmsg = sbErrMsg.toString();
                }
                this.lastResponseMessage = errmsg;
                throw new JUploadExceptionUploadFailed(errmsg);
            }
            if (this.getStringUploadWarning() == null || this.getStringUploadWarning().equals("") || !(matcherWarning = this.patternWarning.matcher(line)).matches()) continue;
            String warnmsg = "A warning occurs during upload (but the applet couldn't find the warning message)";
            if (matcherWarning.groupCount() > 0 && !matcherWarning.group(1).equals("")) {
                warnmsg = matcherWarning.group(1);
            }
            this.lastResponseMessage = warnmsg;
            this.displayWarn(warnmsg);
            this.alertStr(warnmsg);
        }
        if (bReturn) {
            return true;
        }
        if (this.getStringUploadSuccess() == null || this.getStringUploadSuccess().equals("")) {
            return true;
        }
        throw new JUploadExceptionUploadFailed(this.getClass().getName() + ".checkUploadSuccess(): The string \"" + this.stringUploadSuccess + "\" was not found in the response body");
    }

    public String jsString(String s) {
        String dollarReplacement = Matcher.quoteReplacement("\\$");
        String singleQuoteReplacement = Matcher.quoteReplacement("\\'");
        String linefeedReplacement = Matcher.quoteReplacement("\\n");
        if (s == null || s.equals("")) {
            this.displayDebug("jsString (nothing to do, s is an empty string)", 100);
            return "";
        }
        this.displayDebug("jsString:", 100);
        this.displayDebug("  original string:" + s, 100);
        s = s.replaceAll("\\$", dollarReplacement);
        this.displayDebug("  after dollar changed:" + s, 100);
        s = s.replaceAll("\"", "'");
        this.displayDebug("  after double quote changed:" + s, 100);
        s = s.replaceAll("'", singleQuoteReplacement);
        this.displayDebug("  after single quote changed:" + s, 100);
        s = s.replaceAll("\n", linefeedReplacement);
        this.displayDebug("  after LF changed:" + s, 100);
        s = s.replaceAll("\r", "");
        this.displayDebug("  after CR changed:" + s, 100);
        return s;
    }

    public void afterUpload(Exception e, String serverOutput) throws JUploadException {
        String url = this.getAfterUploadURL();
        if (url != null) {
            try {
                if (url.toLowerCase().startsWith("javascript:")) {
                    String expr = url.substring(11);
                    expr = expr.replaceAll("%msg%", Matcher.quoteReplacement(this.jsString(this.getLastResponseMessage())));
                    expr = expr.replaceAll("%body%", Matcher.quoteReplacement(this.jsString(this.getLastResponseBody())));
                    expr = expr.replaceAll("%success%", Matcher.quoteReplacement(null == e ? "true" : "false"));
                    this.displayDebug("Calling javascript expression: " + expr, 80);
                    JSObject.getWindow((Applet)this.getApplet()).eval(expr);
                } else if (null == e) {
                    String target = this.getAfterUploadTarget();
                    if (this.getDebugLevel() >= 100) {
                        this.alertStr("No switch to getAfterUploadURL, because debug level is " + this.getDebugLevel() + " (>=100)");
                    } else {
                        this.getApplet().getAppletContext().showDocument(new URL(url), null == target ? "_self" : target);
                    }
                }
            }
            catch (Exception ee) {
                this.displayErr(ee);
            }
        }
    }

    public void alertStr(String str) {
        String str2 = str.replaceAll("\\\\n", "\n");
        JOptionPane.showMessageDialog(null, str2, "Alert", 2);
    }

    public void alert(String key) {
        this.alertStr(this.getString(key));
    }

    public FileData createFileData(File file, File root) throws JUploadExceptionStopAddingFiles {
        if (!this.fileFilterAccept(file)) {
            String msg = file.getName() + " : " + this.getString("errForbiddenExtension");
            this.displayWarn(msg);
            if (JOptionPane.showConfirmDialog(null, msg, "alert", 2, 2) == 2) {
                throw new JUploadExceptionStopAddingFiles("Stopped by the user");
            }
            return null;
        }
        if (!file.canRead()) {
            this.displayInfo("Can't read file " + file.getName() + ". No DefaultFileData creation.");
            return null;
        }
        return new DefaultFileData(file, root, this);
    }

    public JPanel createTopPanel(JButton browse, JButton remove, JButton removeAll, JUploadPanel jUploadPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add(browse);
        jPanel.add(removeAll);
        jPanel.add(remove);
        jUploadPanel.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        return jPanel;
    }

    public JPanel createProgressPanel(JProgressBar preparationProgressBar, JProgressBar uploadProgressBar, JButton uploadButton, JButton stopButton, JPanel mainPanel) {
        JPanel jProgressBarPanel = new JPanel();
        jProgressBarPanel.setLayout(new BorderLayout(10, 1));
        jProgressBarPanel.add((Component)preparationProgressBar, "North");
        jProgressBarPanel.add((Component)uploadProgressBar, "South");
        JPanel jProgressPanel = new JPanel();
        jProgressPanel.setLayout(new BorderLayout(10, 0));
        jProgressPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jProgressPanel.add((Component)uploadButton, "Before");
        jProgressPanel.add((Component)jProgressBarPanel, "Center");
        jProgressPanel.add((Component)stopButton, "After");
        return jProgressPanel;
    }

    public JPanel createStatusBar(JLabel content, JPanel mainPanel) {
        if (this.showStatusbar) {
            JPanel pstatus = new JPanel();
            pstatus.setLayout(new BorderLayout());
            pstatus.add((Component)content, "Center");
            pstatus.setBorder(new BevelBorder(1));
            return pstatus;
        }
        return null;
    }

    public void addComponentsToJUploadPanel(JUploadPanel jUploadPanel) {
        jUploadPanel.setLayout(new BoxLayout(jUploadPanel, 1));
        JPanel topPanel = this.createTopPanel(jUploadPanel.getBrowseButton(), jUploadPanel.getRemoveButton(), jUploadPanel.getRemoveAllButton(), jUploadPanel);
        if (topPanel != null) {
            jUploadPanel.add(topPanel);
            topPanel.addMouseListener(jUploadPanel);
        }
        jUploadPanel.add(jUploadPanel.getFilePanel().getDropComponent());
        JPanel progressPanel = this.createProgressPanel(jUploadPanel.getPreparationProgressBar(), jUploadPanel.getUploadProgressBar(), jUploadPanel.getUploadButton(), jUploadPanel.getStopButton(), jUploadPanel);
        jUploadPanel.add(progressPanel);
        jUploadPanel.addMouseListener(jUploadPanel);
        jUploadPanel.showOrHideLogWindow();
        jUploadPanel.add(jUploadPanel.getJLogWindowPane());
        JPanel p = this.createStatusBar(jUploadPanel.getStatusLabel(), jUploadPanel);
        if (null != p) {
            jUploadPanel.add(p);
            p.addMouseListener(jUploadPanel);
        }
    }

    public void displayErr(Exception e) {
        this.displayErr(e.getMessage(), e);
    }

    public void displayErr(String err) {
        this.displayErr(err, null);
    }

    private void displayStackTrace(Throwable throwable) {
        if (throwable != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            throwable.printStackTrace(ps);
            ps.close();
            this.displayMsg("", bs.toString());
            if (throwable.getCause() != null) {
                this.displayMsg("", "Caused by:");
                this.displayStackTrace(throwable.getCause());
            }
        }
    }

    public void displayErr(String errorText, Exception exception) {
        if (exception == null) {
            this.setLastException(new JUploadException("errorText"));
        } else if (exception instanceof JUploadException) {
            this.setLastException((JUploadException)exception);
        } else {
            this.setLastException(new JUploadException(exception));
        }
        if (this.getDebugLevel() == 0) {
            this.setDebugLevel(1);
        }
        String exceptionMsg = null;
        String exceptionClassName = null;
        String alertMsg = errorText;
        String logMsg = errorText;
        exceptionClassName = exception == null ? "" : (exception instanceof JUploadException ? "[" + ((JUploadException)exception).getClassNameAndClause() + "] " : "[" + exception.getClass().getName() + "] ");
        if (exception != null) {
            exceptionMsg = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            if (errorText == null || errorText.equals("")) {
                alertMsg = "Unknown error (" + exceptionMsg + ")";
            }
            logMsg = exceptionMsg + " (" + errorText + ")";
        }
        this.displayMsg("[ERROR] ", exceptionClassName + logMsg);
        this.displayStackTrace(exception);
        if (this.getDebugLevel() >= 100) {
            this.alertStr(exceptionClassName + logMsg);
        } else {
            this.alertStr(alertMsg);
        }
        if (this.getApplet().getUploadPanel() != null && this.getDebugLevel() == 100) {
            this.getApplet().getUploadPanel().copyLogWindow();
            this.alert("messageLogWindowCopiedToClipboard");
        }
    }

    public void displayInfo(String info) {
        this.displayMsg("[INFO] ", info);
    }

    public void displayWarn(String warn) {
        this.displayMsg("[WARN] ", warn);
    }

    public void displayDebug(String debug, int minDebugLevel) {
        String tag = "[DEBUG] ";
        if (this.debugLevel >= minDebugLevel) {
            this.displayMsg("[DEBUG] ", debug);
        } else if (this.debugGenerateFile) {
            this.addMsgToDebugLog("[DEBUG] " + debug);
        }
    }

    public String getString(String key) {
        String ret = this.resourceBundle.getString(key);
        return ret;
    }

    public String getUploadFilename(FileData fileData, int index) throws JUploadException {
        if (this.filenameEncoding == null || this.filenameEncoding.equals("")) {
            return fileData.getFileName();
        }
        try {
            return URLEncoder.encode(fileData.getFileName(), this.filenameEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadException(e);
        }
    }

    public String getUploadName(FileData fileData, int index) {
        return "File" + index;
    }

    public boolean isUploadReady() {
        return true;
    }

    public ByteArrayEncoder onAppendHeader(ByteArrayEncoder bae) throws JUploadIOException {
        for (String header : this.headers) {
            this.displayDebug(header, 70);
            bae.append(header).append("\r\n");
        }
        return bae;
    }

    public void onFileSelected(FileData fileData) {
    }

    public void onFileDoubleClicked(FileData fileData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDebugInformation(String description, Exception exception) {
        block14: {
            try {
                this.displayInfo("Sending debug information to " + this.getUrlToSendErrorTo());
                if (null == this.getUrlToSendErrorTo() || JOptionPane.showConfirmDialog(null, this.getString("questionSendMailOnError"), this.getString("Confirm"), 0, 3) != 0) break block14;
                this.displayDebug("[sendDebugInformation] Within response == true", 30);
                String action = null;
                HTTPConnectionHelper connectionHelper = null;
                boolean localDebugOk = this.debugOk;
                try {
                    try {
                        URL url = new URL(this.urlToSendErrorTo);
                        connectionHelper = new HTTPConnectionHelper(this);
                        connectionHelper.initRequest(url, "POST", false, true);
                        ByteArrayEncoderHTTP baeContent = new ByteArrayEncoderHTTP(this, connectionHelper.getByteArrayEncoder().getBoundary(), connectionHelper.getByteArrayEncoder().getEncoding());
                        baeContent.appendTextProperty("description", "An error occured during upload, in JUpload.");
                        String exceptionClass = null;
                        String exceptionCause = null;
                        String exceptionStackTrace = null;
                        if (exception != null) {
                            exceptionClass = exception.getClass().getName();
                            if (exception.getCause() != null) {
                                exceptionCause = exception.getCause().getClass().getName();
                            }
                            StackTraceElement[] elements = exception.getStackTrace();
                            ByteArrayEncoderHTTP baeStackTrace = new ByteArrayEncoderHTTP(this, connectionHelper.getByteArrayEncoder().getBoundary(), connectionHelper.getByteArrayEncoder().getEncoding());
                            for (int i = 0; i < elements.length; ++i) {
                                baeStackTrace.append(" at ");
                                baeStackTrace.append(elements[i].getClassName());
                                baeStackTrace.append(".");
                                baeStackTrace.append(elements[i].getMethodName());
                                baeStackTrace.append("() [line ");
                                baeStackTrace.append(Integer.toString(elements[i].getLineNumber()));
                                baeStackTrace.append("]\r\n");
                            }
                            baeStackTrace.close();
                            exceptionStackTrace = baeStackTrace.getString();
                        }
                        baeContent.appendTextProperty("exceptionClass", exceptionClass);
                        baeContent.appendTextProperty("exceptionCause", exceptionCause);
                        baeContent.appendTextProperty("exceptionStackTrace", exceptionStackTrace);
                        String baeBound = connectionHelper.getByteArrayEncoder().getBoundary();
                        String baeEncoding = connectionHelper.getByteArrayEncoder().getEncoding();
                        ByteArrayEncoderHTTP baeDebug = new ByteArrayEncoderHTTP(this, baeBound, baeEncoding);
                        if (this.debugGenerateFile) {
                            String line;
                            action = "flush (debugGenerateFile=true)";
                            this.debugOut.flush();
                            this.debugOk = false;
                            action = "read debug file (debugGenerateFile=true)";
                            BufferedReader debugIn = new BufferedReader(new FileReader(this.debugFile));
                            while ((line = debugIn.readLine()) != null) {
                                baeDebug.append(line).append("\r\n");
                            }
                            debugIn.close();
                            this.debugOk = localDebugOk;
                        } else {
                            action = "read debug file (debugGenerateFile=false)";
                            baeDebug.append(this.applet.getLogWindow().getText());
                        }
                        action = "baeDebug.close()";
                        baeDebug.close();
                        baeContent.appendTextProperty("debugOutput", baeDebug.getString());
                        baeContent.appendEndPropertyList();
                        baeContent.close();
                        action = "send request";
                        connectionHelper.append("Content-Type: multipart/form-data; boundary=").append(connectionHelper.getBoundary().substring(2)).append("\r\n");
                        connectionHelper.append("Content-length: ").append(String.valueOf(baeContent.getEncodedLength())).append("\r\n");
                        connectionHelper.sendRequest();
                        connectionHelper.append("\r\n");
                        connectionHelper.append(baeContent);
                        action = "connectionHelper.readHttpResponse()";
                        int status = connectionHelper.readHttpResponse();
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("==================      sendDebugInformation [start]   =================================", 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("[sendDebugInformation] Sent to server: \r\n" + connectionHelper.getByteArrayEncoder().getString(), 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("[sendDebugInformation] Body received: \r\n" + connectionHelper.getResponseBody(), 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("==================      sendDebugInformation [end]     =================================", 90);
                        this.displayDebug("========================================================================================", 90);
                        if (!this.checkUploadSuccess(status, connectionHelper.getResponseMsg(), connectionHelper.getResponseBody())) {
                            throw new JUploadExceptionUploadFailed(this.getString("errHttpResponse"));
                        }
                        this.displayInfo("debug information sent correctly");
                    }
                    catch (MalformedURLException e) {
                        throw new JUploadIOException("Malformed URL Exception for " + this.urlToSendErrorTo, e);
                    }
                    catch (Exception e) {
                        this.debugOk = localDebugOk;
                        this.displayErr(this.getString("errDuringLogManagement") + " (" + action + ")", e);
                        Object var17_22 = null;
                        this.debugOk = localDebugOk;
                        break block14;
                    }
                    Object var17_21 = null;
                    this.debugOk = localDebugOk;
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    this.debugOk = localDebugOk;
                    throw throwable;
                }
            }
            catch (JUploadIOException e) {
                this.displayErr("Could not send debug information", e);
            }
        }
    }

    public void setProperty(String prop, String value) throws JUploadException {
        this.displayDebug("[DefaultUploadPolicy] Call of setProperty: " + prop + " => " + value, 30);
        if (prop.equals("afterUploadURL")) {
            this.setAfterUploadURL(value);
        } else if (prop.equals("allowHttpPersistent")) {
            this.setAllowHttpPersistent(Boolean.parseBoolean(value));
        } else if (prop.equals("allowedFileExtensions")) {
            this.setAllowedFileExtensions(value);
        } else if (prop.equals("debugLevel")) {
            this.setDebugLevel(UploadPolicyFactory.parseInt(value, this.debugLevel, this));
        } else if (prop.equals("fileChooserIconFromFileContent")) {
            this.setFileChooserIconFromFileContent(UploadPolicyFactory.parseInt(value, this.getFileChooserIconFromFileContent(), this));
        } else if (prop.equals("fileChooserIconSize")) {
            this.setFileChooserIconSize(UploadPolicyFactory.parseInt(value, this.getFileChooserIconSize(), this));
        } else if (prop.equals("lang")) {
            this.setLang(value);
        } else if (prop.equals("filenameEncoding")) {
            this.setFilenameEncoding(value);
        } else if (prop.equals("lookAndFeel")) {
            this.setLookAndFeel(value);
        } else if (prop.equals("maxChunkSize")) {
            this.setMaxChunkSize(UploadPolicyFactory.parseLong(value, this.maxChunkSize, this));
        } else if (prop.equals("maxFileSize")) {
            this.setMaxFileSize(UploadPolicyFactory.parseLong(value, this.maxFileSize, this));
        } else if (prop.equals("nbFilesPerRequest")) {
            this.setNbFilesPerRequest(UploadPolicyFactory.parseInt(value, this.nbFilesPerRequest, this));
        } else if (prop.equals("postURL")) {
            this.setPostURL(value);
        } else if (prop.equals("serverProtocol")) {
            this.setServerProtocol(value);
        } else if (prop.equals("stringUploadSuccess")) {
            this.setStringUploadSuccess(value);
        } else if (prop.equals("sslVerifyCert")) {
            this.setSslVerifyCert(value);
        } else if (prop.equals("urlToSendErrorTo")) {
            this.setUrlToSendErrorTo(value);
        } else {
            this.displayWarn("Unknown applet parameter: " + prop + " (in DefaultUploadPolicy.setProperty)");
        }
    }

    public void displayParameterStatus() {
        this.displayDebug("=======================================================================", 30);
        this.displayDebug("======= Parameters managed by DefaultUploadPolicy", 30);
        this.displayInfo("JUpload applet, version " + this.getApplet().getVersion() + " (compiled: " + this.getApplet().getBuildDate() + "), available at http://jupload.sourceforge.net/");
        this.displayDebug("Java version: " + System.getProperty("java.version"), 30);
        this.displayDebug("Cookie: " + this.cookie, 30);
        this.displayDebug("userAgent: " + this.userAgent, 30);
        this.displayDebug("List of all applet parameters:", 30);
        this.displayDebug("  language: " + this.resourceBundle.getLocale().getLanguage(), 30);
        this.displayDebug("  country: " + this.resourceBundle.getLocale().getCountry(), 30);
        this.displayDebug("afterUploadURL: " + this.getAfterUploadURL(), 30);
        this.displayDebug("allowHttpPersistent: " + this.getAllowHttpPersistent(), 30);
        this.displayDebug("allowedFileExtensions: " + this.getAllowedFileExtensions(), 30);
        this.displayDebug("browsingDirectory (current value): " + this.getCurrentBrowsingDirectory(), 30);
        this.displayDebug("debugLevel: " + this.debugLevel, 1);
        if (this.debugGenerateFile) {
            this.displayDebug("  (debugfile: " + this.debugFile.getAbsolutePath() + ")", 1);
        }
        this.displayDebug("fileChooserIconFromFileContent: " + this.getFileChooserIconFromFileContent(), 30);
        this.displayDebug("fileChooserIconSize: " + this.getFileChooserIconSize(), 30);
        this.displayDebug("filenameEncoding: " + this.getFilenameEncoding(), 30);
        this.displayDebug("ftpCreateDirectoryStructure: " + this.getFtpCreateDirectoryStructure(), 30);
        this.displayDebug("ftpTransfertBinary: " + this.getFtpTransfertBinary(), 30);
        this.displayDebug("ftpTransfertPassive: " + this.getFtpTransfertPassive(), 30);
        this.displayDebug("lang: " + this.lang, 30);
        this.displayDebug("maxChunkSize: " + this.getMaxChunkSize(), 30);
        if (this.maxFileSize == Long.MAX_VALUE) {
            this.displayDebug("maxFileSize: " + this.getMaxFileSize(), 30);
        } else {
            this.displayInfo("maxFileSize: " + this.getMaxFileSize());
        }
        this.displayDebug("nbFilesPerRequest: " + this.getNbFilesPerRequest(), 30);
        this.displayDebug("postURL: " + this.postURL, 30);
        this.displayDebug("readCookieFromNavigator: " + this.readCookieFromNavigator, 30);
        this.displayDebug("serverProtocol: " + this.getServerProtocol(), 30);
        this.displayDebug("showLogWindow: " + this.getShowLogWindow(), 30);
        this.displayDebug("showStatusbar: " + this.showStatusbar, 30);
        this.displayDebug("specificHeaders: " + this.getSpecificHeaders(), 30);
        this.displayDebug("stringUploadError: " + this.getStringUploadError(), 30);
        this.displayDebug("stringUploadSuccess: " + this.getStringUploadSuccess(), 30);
        this.displayDebug("stringUploadWarning: " + this.getStringUploadWarning(), 30);
        this.displayDebug("urlToSendErrorTo: " + this.getUrlToSendErrorTo(), 30);
        this.displayDebug("", 30);
    }

    private final String normalizeURL(String url) throws JUploadException {
        if (null == url || url.length() == 0) {
            return this.getApplet().getDocumentBase().toString();
        }
        URI uri = null;
        try {
            uri = new URI(url);
            if (null == uri.getScheme()) {
                uri = this.getApplet().getDocumentBase().toURI().resolve(url);
            }
            if (!(uri.getScheme().equals("http") || uri.getScheme().equals("https") || uri.getScheme().equals("ftp"))) {
                throw new JUploadException("URI scheme " + uri.getScheme() + " not supported.");
            }
        }
        catch (URISyntaxException e) {
            throw new JUploadException(e);
        }
        return uri.toString();
    }

    public String getAfterUploadURL() {
        return this.afterUploadURL;
    }

    protected void setAfterUploadURL(String afterUploadURL) throws JUploadException {
        if (null == afterUploadURL) {
            return;
        }
        this.afterUploadURL = afterUploadURL.toLowerCase().startsWith("javascript:") ? afterUploadURL : this.normalizeURL(afterUploadURL);
    }

    public boolean getAllowHttpPersistent() {
        return this.allowHttpPersistent;
    }

    public String getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    protected void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions == null || allowedFileExtensions.equals("") ? null : (allowedFileExtensions.startsWith("/") ? "" : "/") + allowedFileExtensions.toLowerCase() + (allowedFileExtensions.endsWith("/") ? "" : "/");
    }

    protected void setAllowHttpPersistent(boolean value) {
        this.allowHttpPersistent = value;
    }

    public JUploadApplet getApplet() {
        return this.applet;
    }

    public void setCurrentBrowsingDirectory(File currentBrowsingDirectoryParam) {
        try {
            if (currentBrowsingDirectoryParam.isDirectory()) {
                this.currentBrowsingDirectory = currentBrowsingDirectoryParam;
            } else {
                this.displayWarn("DefaultUploadPolicy.setCurrentBrowsingDirectory(): " + currentBrowsingDirectoryParam + " doesn't exist.");
            }
        }
        catch (SecurityException se) {
            this.displayWarn(se.getClass().getName() + " in DefaultUploadPolicy.setCurrentBrowsingDirectory(): " + currentBrowsingDirectoryParam + " is ignored.");
        }
    }

    private void setCurrentBrowsingDirectory(String currentBrowsingDirectoryParam) {
        if (currentBrowsingDirectoryParam == null) {
            this.currentBrowsingDirectory = null;
        } else {
            this.setCurrentBrowsingDirectory(new File(currentBrowsingDirectoryParam));
        }
    }

    public File getCurrentBrowsingDirectory() {
        return this.currentBrowsingDirectory;
    }

    public String getDateFormat() {
        return "dd/MM/yyyy HH:mm:ss";
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.setDebugLevel(debugLevel, true);
    }

    public void setDebugLevel(int debugLevel, boolean displayAppletParameterList) {
        if (this.debugLevel >= 0) {
            this.displayInfo("Debug level set to " + debugLevel);
            if (this.debugGenerateFile) {
                this.displayInfo("Current debug output file: " + this.debugFile.getAbsolutePath());
            }
        }
        this.debugLevel = debugLevel;
        if (displayAppletParameterList) {
            this.displayParameterStatus();
        }
    }

    public int getFileChooserIconFromFileContent() {
        return this.fileChooserIconFromFileContent;
    }

    public void setFileChooserIconFromFileContent(int fileChooserIconFromFileContent) {
        this.fileChooserIconFromFileContent = fileChooserIconFromFileContent;
    }

    public int getFileChooserIconSize() {
        return this.fileChooserIconSize;
    }

    public void setFileChooserIconSize(int fileChooserIconSize) {
        this.fileChooserIconSize = fileChooserIconSize;
    }

    public void setLang(String lang) {
        Locale locale;
        this.lang = lang;
        if (lang == null) {
            this.displayInfo("lang = null, taking default language");
            locale = Locale.getDefault();
        } else if (lang.length() == 5 && (lang.substring(2, 3).equals("_") || lang.substring(2, 3).equals("-"))) {
            String language = lang.substring(0, 2);
            String country = lang.substring(3, 5);
            this.displayDebug("setLang - language read: " + language, 50);
            this.displayDebug("setLang - country read: " + country, 50);
            locale = new Locale(language, country.toUpperCase());
        } else {
            locale = new Locale(lang);
            this.displayDebug("setLang - language read (no country): " + lang, 50);
        }
        this.resourceBundle = ResourceBundle.getBundle("wjhk.jupload2.lang.lang", locale, new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException();
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return this.getClass().getClassLoader().getResourceAsStream(name);
            }
        });
    }

    protected String getLookAndFeel() {
        return this.lookAndFeel;
    }

    protected void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
        if (lookAndFeel != null && !lookAndFeel.equals("") && !lookAndFeel.equals("java")) {
            try {
                if (!lookAndFeel.equals("system")) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (Exception e) {
                this.displayErr(e);
            }
        }
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    protected void setMaxChunkSize(long maxChunkSize) {
        if (maxChunkSize <= 0L) {
            this.displayDebug("maxChunkSize<=0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxChunkSize = Long.MAX_VALUE;
        }
        this.maxChunkSize = maxChunkSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    protected void setMaxFileSize(long maxFileSize) {
        if (maxFileSize < 0L) {
            this.displayDebug("maxFileSize<0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxFileSize = Long.MAX_VALUE;
        }
        this.maxFileSize = maxFileSize;
    }

    public int getNbFilesPerRequest() {
        return this.nbFilesPerRequest;
    }

    protected void setNbFilesPerRequest(int nbFilesPerRequest) {
        if (nbFilesPerRequest < 0) {
            this.displayDebug("nbFilesPerRequest<0 which is invalid. Switched to the default value (Integer.MAX_VALUE)", 1);
            nbFilesPerRequest = Integer.MAX_VALUE;
        }
        this.nbFilesPerRequest = nbFilesPerRequest;
    }

    public String getFilenameEncoding() {
        return this.filenameEncoding;
    }

    protected void setFilenameEncoding(String filenameEncoding) {
        this.filenameEncoding = filenameEncoding;
    }

    public boolean getFtpCreateDirectoryStructure() {
        return this.ftpCreateDirectoryStructure;
    }

    protected void setFtpCreateDirectoryStructure(boolean ftpCreateDirectoryStructure) {
        this.ftpCreateDirectoryStructure = ftpCreateDirectoryStructure;
    }

    public boolean getFtpTransfertBinary() {
        return this.ftpTransfertBinary;
    }

    protected void setFtpTransfertBinary(boolean ftpTransfertBinary) {
        this.ftpTransfertBinary = ftpTransfertBinary;
    }

    public boolean getFtpTransfertPassive() {
        return this.ftpTransfertPassive;
    }

    protected void setFtpTransfertPassive(boolean ftpTransfertPassive) {
        this.ftpTransfertPassive = ftpTransfertPassive;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String postURL) throws JUploadException {
        this.postURL = this.normalizeURL(postURL);
    }

    public boolean getReadCookieFromNavigator() {
        return this.readCookieFromNavigator;
    }

    private void setReadCookieFromNavigator(boolean readCookieFromNavigator) {
        this.readCookieFromNavigator = readCookieFromNavigator;
    }

    public String getServerProtocol() {
        if (this.serverProtocol == null) {
            return "HTTP/1.1";
        }
        return this.serverProtocol;
    }

    protected void setServerProtocol(String value) throws JUploadException {
        if (null == value || value.equals("")) {
            if (null == this.postURL || this.postURL.equals("")) {
                this.displayErr("postURL not set");
                value = "HTTP/1.1";
            } else if (this.postURL.substring(0, 3).equals("ftp")) {
                value = "ftp";
            } else {
                try {
                    value = new HttpConnect(this).getProtocol();
                }
                catch (Exception e) {
                    this.displayErr("Unable to access to the postURL: '" + this.getPostURL() + "'", e);
                    value = "HTTP/1.1";
                }
            }
        } else if (value.startsWith("HTTP")) {
            try {
                new HttpConnect(this).getProtocol();
            }
            catch (Exception e) {
                this.displayErr("Unable to access to the postURL: '" + this.getPostURL() + "'", e);
            }
        }
        this.serverProtocol = value;
    }

    public String getShowLogWindow() {
        return this.showLogWindow;
    }

    public void setShowLogWindow(String showLogWindow) {
        if (showLogWindow.equals("true") || showLogWindow.equals("false") || showLogWindow.equals("onError")) {
            this.showLogWindow = showLogWindow;
            if (this.getApplet().getUploadPanel() != null) {
                this.getApplet().getUploadPanel().showOrHideLogWindow();
            }
        } else {
            this.displayWarn("[setShowLogWindow] Unallowed value: " + showLogWindow + " (showLogWindow is left unchanged)");
        }
    }

    public String getSpecificHeaders() {
        return this.specificHeaders;
    }

    protected void setSpecificHeaders(String specificHeaders) {
        this.specificHeaders = specificHeaders;
        if (specificHeaders != null) {
            String[] headerArray = specificHeaders.split("\\\\n");
            for (int x = 0; x < headerArray.length; ++x) {
                this.addHeader(headerArray[x]);
            }
        }
    }

    public int getSslVerifyCert() {
        return this.sslVerifyCert;
    }

    protected void setSslVerifyCert(String mode) throws JUploadException {
        int val = -1;
        if (mode.toLowerCase().equals("none")) {
            val = 0;
        }
        if (mode.toLowerCase().equals("server")) {
            val = 1;
        }
        if (mode.toLowerCase().equals("client")) {
            val = 2;
        }
        if (mode.toLowerCase().equals("strict")) {
            val = 3;
        }
        if (val == -1) {
            throw new JUploadException("Invalid parameter sslVerifyCert (" + mode + ")");
        }
        this.sslVerifyCert = val;
    }

    protected void setShowStatusbar(boolean show) {
        this.showStatusbar = show;
    }

    public String getStringUploadError() {
        return this.stringUploadError;
    }

    public String getStringUploadSuccess() {
        return this.stringUploadSuccess;
    }

    public String getStringUploadWarning() {
        return this.stringUploadWarning;
    }

    protected void setStringUploadError(String stringUploadError) throws JUploadException {
        this.stringUploadError = stringUploadError;
        if (stringUploadError != null) {
            try {
                this.patternError = Pattern.compile(stringUploadError);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadError");
            }
        }
    }

    protected void setStringUploadSuccess(String stringUploadSuccess) throws JUploadException {
        this.stringUploadSuccess = stringUploadSuccess;
        if (stringUploadSuccess != null) {
            try {
                this.patternSuccess = Pattern.compile(stringUploadSuccess);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadSuccess");
            }
        }
    }

    protected void setStringUploadWarning(String stringUploadWarning) throws JUploadException {
        this.stringUploadWarning = stringUploadWarning;
        if (stringUploadWarning != null) {
            try {
                this.patternWarning = Pattern.compile(stringUploadWarning);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadWarning");
            }
        }
    }

    public String getUrlToSendErrorTo() {
        return this.urlToSendErrorTo;
    }

    public void setUrlToSendErrorTo(String urlToSendErrorTo) throws JUploadException {
        if (null == urlToSendErrorTo) {
            return;
        }
        String tmp = this.normalizeURL(urlToSendErrorTo);
        if (tmp.startsWith("ftp://")) {
            throw new JUploadException("urlToSendErrorTo: ftp scheme not supported.");
        }
        this.urlToSendErrorTo = tmp;
    }

    public String getFormdata() {
        return this.formData;
    }

    public String getAfterUploadTarget() {
        return this.afterUploadTarget;
    }

    public Cursor setWaitCursor() {
        Cursor previousCursor = this.getApplet().getCursor();
        this.getApplet().setCursor(new Cursor(3));
        return previousCursor;
    }

    public void setCursor(Cursor cursor) {
        this.getApplet().setCursor(cursor);
    }

    public void deleteLog() {
        if (this.debugGenerateFile) {
            try {
                if (null != this.debugOut) {
                    this.debugOut.close();
                    this.debugOut = null;
                }
                if (null != this.debugFile) {
                    this.debugFile.delete();
                    this.debugFile = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void addMsgToDebugLog(String msg) {
        block6: {
            if (this.debugGenerateFile && this.debugOk) {
                try {
                    if (null == this.debugOut) {
                        this.getApplet().registerUnload(this, "deleteLog");
                        this.debugFile = File.createTempFile("jupload_", "_log.txt");
                        this.debugOut = new PrintStream(new FileOutputStream(this.debugFile));
                    }
                    boolean endsLF = msg.endsWith("\n");
                    msg = msg.replaceAll("\n", this.CRLF);
                    if (endsLF) {
                        this.debugOut.print(msg);
                        break block6;
                    }
                    this.debugOut.println(msg);
                }
                catch (IOException e) {
                    this.debugOk = false;
                    System.err.println("IO error on debuglog " + this.debugFile.getPath() + "\nFallback to standard output.");
                    System.out.println(msg);
                }
            } else {
                System.out.println(msg);
            }
        }
    }

    private final String timestamp(String tag, String s) {
        String stamp = new SimpleDateFormat("HH:mm:ss.SSS ").format(new Date()) + tag;
        boolean endsLF = s.endsWith("\n");
        if (endsLF) {
            s = s.substring(0, s.length() - 1);
        }
        return stamp + s.replaceAll("\n", "\n" + stamp) + (endsLF ? "\n" : "");
    }

    private void displayMsg(String tag, String msg) {
        msg = this.timestamp(tag, msg);
        if (this.applet.getLogWindow() == null) {
            System.out.println(msg);
        } else {
            this.applet.getLogWindow().displayMsg(msg.endsWith("\n") ? msg : msg + "\n");
        }
        if (this.debugGenerateFile) {
            this.addMsgToDebugLog(msg);
        }
    }

    public void afterFileDropped(DropTargetDropEvent dropEvent) {
    }

    public JUploadFileChooser createFileChooser() {
        return new JUploadFileChooser(this);
    }

    public boolean fileFilterAccept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return true;
        }
        String extension = DefaultFileData.getExtension(file).toLowerCase();
        return this.allowedFileExtensions.indexOf("/" + extension + "/") >= 0;
    }

    public String fileFilterGetDescription() {
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return null;
        }
        return "JUpload file filter (" + this.allowedFileExtensions + ")";
    }

    public Icon fileViewGetIcon(File file) {
        return null;
    }

    public JUploadException getLastException() {
        return this.lastException;
    }

    public void setLastException(JUploadException exception) {
        this.lastException = exception;
        if (this.getApplet().getUploadPanel() != null) {
            this.getApplet().getUploadPanel().showOrHideLogWindow();
        }
    }

    public String getLastResponseBody() {
        return this.lastResponseBody;
    }

    public String getLastResponseMessage() {
        return null != this.lastResponseMessage ? this.lastResponseMessage : "";
    }
}

