/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.image.JUploadImagePreview;
import wjhk.jupload2.gui.image.PictureDialog;
import wjhk.jupload2.gui.image.PicturePanel;
import wjhk.jupload2.policies.DefaultUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;

public class PictureUploadPolicy
extends DefaultUploadPolicy
implements ActionListener,
ImageObserver {
    private boolean storeBufferedImage;
    private String targetPictureFormat;
    private boolean fileChooserImagePreview = true;
    private boolean highQualityPreview;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private float pictureCompressionQuality = 0.8f;
    private boolean pictureTransmitMetadata;
    private int realMaxWidth = -1;
    private int realMaxHeight = -1;
    private JButton rotateLeftButton;
    private JButton rotateRightButton;
    private PicturePanel picturePanel;

    public PictureUploadPolicy(JUploadApplet theApplet) throws JUploadException {
        super(theApplet);
        this.setFileChooserImagePreview(UploadPolicyFactory.getParameter(theApplet, "fileChooserImagePreview", true, (UploadPolicy)this));
        this.setHighQualityPreview(UploadPolicyFactory.getParameter(theApplet, "highQualityPreview", false, (UploadPolicy)this));
        this.setMaxHeight(UploadPolicyFactory.getParameter(theApplet, "maxPicHeight", Integer.MAX_VALUE, (UploadPolicy)this));
        this.setMaxWidth(UploadPolicyFactory.getParameter(theApplet, "maxPicWidth", Integer.MAX_VALUE, (UploadPolicy)this));
        this.setPictureCompressionQuality(UploadPolicyFactory.getParameter(theApplet, "pictureCompressionQuality", 0.8f, (UploadPolicy)this));
        this.setPictureTransmitMetadata(UploadPolicyFactory.getParameter(theApplet, "pictureTransmitMetadata", false, (UploadPolicy)this));
        this.setRealMaxHeight(UploadPolicyFactory.getParameter(theApplet, "realMaxPicHeight", Integer.MAX_VALUE, (UploadPolicy)this));
        this.setRealMaxWidth(UploadPolicyFactory.getParameter(theApplet, "realMaxPicWidth", Integer.MAX_VALUE, (UploadPolicy)this));
        this.setStoreBufferedImage(UploadPolicyFactory.getParameter(theApplet, "storeBufferedImage", false, (UploadPolicy)this));
        this.setTargetPictureFormat(UploadPolicyFactory.getParameter(theApplet, "targetPictureFormat", DEFAULT_TARGET_PICTURE_FORMAT, (UploadPolicy)this));
        this.displayDebug("[PictureUploadPolicy] end of constructor", 30);
    }

    public FileData createFileData(File file, File root) throws JUploadExceptionStopAddingFiles {
        FileData defaultFileData = super.createFileData(file, root);
        if (defaultFileData == null) {
            return null;
        }
        PictureFileData pfd = null;
        try {
            pfd = new PictureFileData(file, root, this);
        }
        catch (JUploadIOException e) {
            this.displayErr(e);
        }
        if (pfd != null && pfd.isPicture()) {
            return pfd;
        }
        if (this.getAllowedFileExtensions() != null) {
            return defaultFileData;
        }
        String msg = String.format(this.getString("notAPicture"), file.getName());
        this.displayWarn(msg);
        if (JOptionPane.showConfirmDialog(null, msg, "alert", 2, 2) == 2) {
            throw new JUploadExceptionStopAddingFiles("Stopped by the user");
        }
        return null;
    }

    public JPanel createTopPanel(JButton browse, JButton remove, JButton removeAll, JUploadPanel jUploadPanel) {
        this.rotateLeftButton = new JButton(this.getString("buttonRotateLeft"));
        this.rotateLeftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/rotateLeft.gif")));
        this.rotateLeftButton.addActionListener(this);
        this.rotateLeftButton.addMouseListener(jUploadPanel);
        this.rotateLeftButton.setEnabled(false);
        this.rotateRightButton = new JButton(this.getString("buttonRotateRight"));
        this.rotateRightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/rotateRight.gif")));
        this.rotateRightButton.addActionListener(this);
        this.rotateRightButton.addMouseListener(jUploadPanel);
        this.rotateRightButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        buttonPanel.add(browse);
        buttonPanel.add(this.rotateLeftButton);
        buttonPanel.add(this.rotateRightButton);
        buttonPanel.add(removeAll);
        buttonPanel.add(remove);
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridLayout(1, 1));
        pPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.picturePanel = new PicturePanel(true, this);
        this.picturePanel.addMouseListener(jUploadPanel);
        pPanel.add(this.picturePanel);
        this.setCursor(null);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.add(buttonPanel);
        topPanel.add(pPanel);
        jUploadPanel.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        return topPanel;
    }

    public void actionPerformed(ActionEvent e) {
        this.displayInfo("Action : " + e.getActionCommand());
        if (e.getActionCommand() == this.rotateLeftButton.getActionCommand()) {
            this.picturePanel.rotate(-1);
        } else if (e.getActionCommand() == this.rotateRightButton.getActionCommand()) {
            this.picturePanel.rotate(1);
        }
    }

    public void onFileSelected(FileData fileData) {
        if (fileData != null) {
            this.displayDebug("File selected: " + fileData.getFileName(), 30);
        }
        if (this.picturePanel != null) {
            if (fileData instanceof PictureFileData) {
                Cursor previousCursor = this.setWaitCursor();
                this.picturePanel.setPictureFile((PictureFileData)fileData, this.rotateLeftButton, this.rotateRightButton);
                this.setCursor(previousCursor);
            } else {
                this.picturePanel.setPictureFile(null, this.rotateLeftButton, this.rotateRightButton);
            }
        }
    }

    public void onFileDoubleClicked(FileData pictureFileData) {
        if (pictureFileData != null) {
            if (!(pictureFileData instanceof PictureFileData)) {
                this.displayWarn("PictureUploadPolicy: received a non PictureFileData in onFileDoubleClicked");
            } else {
                new PictureDialog(null, (PictureFileData)pictureFileData, this);
            }
        }
    }

    public void beforeUpload() {
        this.getApplet().getUploadPanel().getFilePanel().clearSelection();
        if (this.picturePanel != null) {
            this.picturePanel.setPictureFile(null, this.rotateLeftButton, this.rotateRightButton);
        }
        super.beforeUpload();
    }

    public boolean getFileChooserImagePreview() {
        return this.fileChooserImagePreview;
    }

    public void setFileChooserImagePreview(boolean fileChooserImagePreview) {
        this.fileChooserImagePreview = fileChooserImagePreview;
    }

    public boolean getHighQualityPreview() {
        return this.highQualityPreview;
    }

    void setHighQualityPreview(boolean highQualityPreview) {
        this.highQualityPreview = highQualityPreview;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    void setMaxHeight(int maxHeight) {
        if (maxHeight <= 0) {
            this.maxHeight = Integer.MAX_VALUE;
            this.displayWarn("[setMaxHeight] maxHeight switched from " + maxHeight + " to " + this.maxHeight);
        } else {
            this.maxHeight = maxHeight;
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    void setMaxWidth(int maxWidth) {
        if (maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
            this.displayWarn("[setMaxWidth] maxWidth switched from " + maxWidth + " to " + this.maxWidth);
        } else {
            this.maxWidth = maxWidth;
        }
    }

    public float getPictureCompressionQuality() {
        return this.pictureCompressionQuality;
    }

    void setPictureCompressionQuality(float pictureCompressionQuality) {
        this.pictureCompressionQuality = pictureCompressionQuality;
    }

    public boolean getPictureTransmitMetadata() {
        return this.pictureTransmitMetadata;
    }

    void setPictureTransmitMetadata(boolean pictureTransmitMetadata) {
        this.pictureTransmitMetadata = pictureTransmitMetadata;
    }

    public int getRealMaxHeight() {
        return this.realMaxHeight == Integer.MAX_VALUE ? this.maxHeight : this.realMaxHeight;
    }

    void setRealMaxHeight(int realMaxHeight) {
        this.realMaxHeight = realMaxHeight;
    }

    public int getRealMaxWidth() {
        return this.realMaxWidth == Integer.MAX_VALUE ? this.maxWidth : this.realMaxWidth;
    }

    void setRealMaxWidth(int realMaxWidth) {
        this.realMaxWidth = realMaxWidth;
    }

    public boolean hasToStoreBufferedImage() {
        return this.storeBufferedImage;
    }

    void setStoreBufferedImage(boolean storeBufferedImage) {
        this.storeBufferedImage = storeBufferedImage;
    }

    public String getTargetPictureFormat() {
        return this.targetPictureFormat;
    }

    void setTargetPictureFormat(String targetPictureFormat) {
        this.targetPictureFormat = targetPictureFormat;
    }

    public void setProperty(String prop, String value) throws JUploadException {
        if (prop.equals("fileChooserImagePreview")) {
            this.setFileChooserImagePreview(UploadPolicyFactory.parseBoolean(value, this.getFileChooserImagePreview(), this));
        } else if (prop.equals("storeBufferedImage")) {
            this.setStoreBufferedImage(UploadPolicyFactory.parseBoolean(value, this.storeBufferedImage, this));
        } else if (prop.equals("highQualityPreview")) {
            this.setHighQualityPreview(UploadPolicyFactory.parseBoolean(value, this.highQualityPreview, this));
        } else if (prop.equals("maxPicHeight")) {
            this.setMaxHeight(UploadPolicyFactory.parseInt(value, this.maxHeight, this));
        } else if (prop.equals("maxPicWidth")) {
            this.setMaxWidth(UploadPolicyFactory.parseInt(value, this.maxWidth, this));
        } else if (prop.equals("pictureCompressionQuality")) {
            this.setPictureCompressionQuality(UploadPolicyFactory.parseFloat(value, this.pictureCompressionQuality, this));
        } else if (prop.equals("pictureTransmitMetadata")) {
            this.setPictureTransmitMetadata(UploadPolicyFactory.parseBoolean(value, this.pictureTransmitMetadata, this));
        } else if (prop.equals("realMaxPicHeight")) {
            this.setRealMaxHeight(UploadPolicyFactory.parseInt(value, this.realMaxHeight, this));
        } else if (prop.equals("realMaxPicWidth")) {
            this.setRealMaxWidth(UploadPolicyFactory.parseInt(value, this.realMaxWidth, this));
        } else if (prop.equals("targetPictureFormat")) {
            this.setTargetPictureFormat(value);
        } else {
            super.setProperty(prop, value);
        }
    }

    public void displayParameterStatus() {
        super.displayParameterStatus();
        this.displayDebug("======= Parameters managed by PictureUploadPolicy", 30);
        this.displayDebug("fileChooserImagePreview: " + this.getFileChooserImagePreview(), 30);
        this.displayDebug("highQualityPreview : " + this.highQualityPreview, 30);
        this.displayDebug("pictureCompressionQuality : " + this.getPictureCompressionQuality(), 30);
        this.displayDebug("pictureTransmitMetadata : " + this.getPictureTransmitMetadata(), 30);
        this.displayDebug("maxPicWidth : " + this.maxWidth + ", " + "maxPicHeight" + " : " + this.maxHeight, 30);
        this.displayDebug("realMaxPicWidth : " + this.realMaxWidth + ", " + "realMaxPicHeight" + " : " + this.realMaxHeight, 30);
        this.displayDebug("storeBufferedImage : " + this.storeBufferedImage, 30);
        this.displayDebug("targetPictureFormat : " + this.targetPictureFormat, 30);
        this.displayDebug("", 30);
    }

    public Cursor setWaitCursor() {
        Cursor previousCursor = super.setWaitCursor();
        this.picturePanel.setCursor(null);
        return previousCursor;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(null);
        this.picturePanel.setCursor(new Cursor(12));
    }

    public JUploadFileChooser createFileChooser() {
        JUploadFileChooser jufc = super.createFileChooser();
        if (this.getFileChooserImagePreview()) {
            jufc.setAccessory(new JUploadImagePreview(jufc, this));
        }
        return jufc;
    }

    public Icon fileViewGetIcon(File file) {
        return PictureFileData.getImageIcon(file, this.getFileChooserIconSize(), this.getFileChooserIconSize());
    }

    public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return true;
    }
}

