/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

public class ByteArrayEncoderHTTP
implements ByteArrayEncoder {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String bound = null;
    private String encoding = "UTF-8";
    private boolean closed = false;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int encodedLength = -1;
    private byte[] encodedByteArray = null;
    private UploadPolicy uploadPolicy;
    private Writer writer;

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy) throws JUploadIOException {
        this.init(uploadPolicy, null, DEFAULT_ENCODING);
    }

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy, String bound) throws JUploadIOException {
        this.init(uploadPolicy, bound, DEFAULT_ENCODING);
    }

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy, String bound, String encoding) throws JUploadIOException {
        this.init(uploadPolicy, bound, encoding);
    }

    public synchronized void close() throws JUploadIOException {
        if (this.isClosed()) {
            throw new JUploadIOException("Trying to close an already closed ByteArrayEncoded");
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        this.encodedByteArray = this.baos.toByteArray();
        this.encodedLength = this.encodedByteArray.length;
        this.closed = true;
    }

    public ByteArrayEncoder append(String str) throws JUploadIOException {
        try {
            this.writer.append(str);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(int b) throws JUploadIOException {
        try {
            this.writer.flush();
            this.baos.write(b);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(byte[] b) throws JUploadIOException {
        try {
            this.writer.flush();
            this.baos.write(b);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(ByteArrayEncoder bae) throws JUploadIOException {
        this.append(bae.getEncodedByteArray());
        return this;
    }

    public ByteArrayEncoder appendTextProperty(String name, String value) throws JUploadIOException {
        this.append(this.bound).append("\r\n");
        this.append("Content-Disposition: form-data; name=\"").append(name).append("\"\r\n");
        this.append("Content-Transfer-Encoding: 8bit\r\n");
        this.append("Content-Type: text/plain; ").append(this.getEncoding()).append("\r\n");
        this.append("\r\n");
        this.append(value).append("\r\n");
        return this;
    }

    public ByteArrayEncoder appendEndPropertyList() throws JUploadIOException {
        this.append(this.bound).append("--\r\n");
        return this;
    }

    public ByteArrayEncoder appendFormVariables(String formname) throws JUploadIOException {
        try {
            JSObject win = JSObject.getWindow((Applet)this.uploadPolicy.getApplet());
            Object o = win.eval("document." + formname + ".elements.length");
            if (o instanceof Number) {
                int len = ((Number)o).intValue();
                if (len <= 0) {
                    this.uploadPolicy.displayWarn("The specified form \"" + formname + "\" does not contain any elements.");
                }
                for (int i = 0; i < len; ++i) {
                    try {
                        Object on;
                        String t;
                        Object name = win.eval("document." + formname + "[" + i + "].name");
                        Object value = win.eval("document." + formname + "[" + i + "].value");
                        Object elementType = win.eval("document." + formname + "[" + i + "].type");
                        Object elementClass = win.eval("document." + formname + "[" + i + "].class");
                        Object etype = win.eval("document." + formname + "[" + i + "].type");
                        if (etype instanceof String && ((t = (String)etype).equals("checkbox") || t.equals("radio")) && (on = win.eval("document." + formname + "[" + i + "].checked")) instanceof Boolean && !((Boolean)on).booleanValue()) continue;
                        if (name instanceof String) {
                            if (value instanceof String) {
                                this.uploadPolicy.displayDebug("  Trying to add formdata element num " + i + " (name: " + name + ", value: " + value + ", type: " + elementType + ", class: " + elementClass + ")", 80);
                                this.appendTextProperty((String)name, (String)value);
                                continue;
                            }
                            this.uploadPolicy.displayWarn("[ByteArrayEncoder.appendFormVariables] value must be an instance of String (name: " + name + ", value: )" + value + ")");
                            continue;
                        }
                        this.uploadPolicy.displayWarn("[ByteArrayEncoder.appendFormVariables] name must be an instance of String (name: " + name + ", value: )" + value + ")");
                        continue;
                    }
                    catch (JSException e1) {
                        this.uploadPolicy.displayDebug(e1.getStackTrace()[1] + ": got JSException, bailing out", 10);
                        i = len;
                    }
                }
            } else {
                this.uploadPolicy.displayWarn("The specified form \"" + formname + "\" could not be found.");
            }
        }
        catch (JSException e) {
            this.uploadPolicy.displayDebug(e.getStackTrace()[1] + ": No JavaScript availabe", 10);
        }
        return this;
    }

    public String getBoundary() {
        return this.bound;
    }

    public static String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getEncodedLength() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get length of a on non-closed ByteArrayEncoded");
        }
        return this.encodedLength;
    }

    public byte[] getEncodedByteArray() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get the byte array of a on non-closed ByteArrayEncoded");
        }
        return this.encodedByteArray;
    }

    public String getString() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get the byte array of a on non-closed ByteArrayEncoded");
        }
        try {
            return new String(this.encodedByteArray, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadIOException(e);
        }
    }

    private void init(UploadPolicy uploadPolicy, String bound, String encoding) throws JUploadIOException {
        this.uploadPolicy = uploadPolicy;
        this.encoding = encoding;
        this.bound = bound;
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.baos, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadIOException(e);
        }
    }
}

