/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;
import wjhk.jupload2.upload.helper.ByteArrayEncoderHTTP;
import wjhk.jupload2.upload.helper.HTTPInputStreamReader;
import wjhk.jupload2.upload.helper.HttpConnect;

public class HTTPConnectionHelper
extends OutputStream {
    private static final int STATUS_NOT_INITIALIZED = 0;
    private static final int STATUS_BEFORE_SERVER_CONNECTION = 1;
    private static final int STATUS_WRITING_REQUEST = 2;
    private static final int STATUS_READING_RESPONSE = 3;
    private static final int STATUS_CONNECTION_CLOSED = 4;
    private String boundary = this.calculateRandomBoundary();
    private boolean bChunkEnabled;
    private boolean bLastChunk;
    private ByteArrayEncoder byteArrayEncoder = null;
    private int connectionStatus = 0;
    private HTTPInputStreamReader httpInputStreamReader = null;
    private PushbackInputStream inputStream = null;
    private String method = null;
    private DataOutputStream outputStream = null;
    private Proxy proxy = null;
    private Socket socket = null;
    private UploadPolicy uploadPolicy = null;
    private URL url = null;
    private boolean useProxy;
    private boolean useSSL;

    public HTTPConnectionHelper(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
    }

    public HTTPConnectionHelper(URL url, String method, boolean bChunkEnabled, boolean bLastChunk, UploadPolicy uploadPolicy) throws JUploadIOException {
        this.uploadPolicy = uploadPolicy;
        this.initRequest(url, method, bChunkEnabled, bLastChunk);
    }

    public void initRequest(URL url, String method, boolean bChunkEnabled, boolean bLastChunk) throws JUploadIOException {
        if (this.connectionStatus != 0 && this.connectionStatus != 4) {
            throw new JUploadIOException("Bad status of the connectionHelper in initRequest: " + this.getStatusLabel());
        }
        if (this.isKeepAlive()) {
            this.dispose();
        }
        this.url = url;
        this.method = method;
        this.bChunkEnabled = bChunkEnabled;
        this.bLastChunk = bLastChunk;
        this.initByteArrayEncoder();
        this.connectionStatus = 1;
    }

    public ByteArrayEncoder getByteArrayEncoder() throws JUploadIOException {
        return this.byteArrayEncoder;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void sendRequest() throws JUploadIOException {
        if (this.connectionStatus != 1) {
            throw new JUploadIOException("Bad status of the connectionHelper in initRequest: " + this.getStatusLabel());
        }
        try {
            if (!this.byteArrayEncoder.isClosed()) {
                this.byteArrayEncoder.close();
            }
            this.httpInputStreamReader = null;
            if (this.socket == null || !this.uploadPolicy.getAllowHttpPersistent()) {
                this.socket = new HttpConnect(this.uploadPolicy).Connect(this.url, this.proxy);
                this.outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.inputStream = new PushbackInputStream(this.socket.getInputStream(), 1);
            }
            this.outputStream.write(this.byteArrayEncoder.getEncodedByteArray());
            this.connectionStatus = 2;
        }
        catch (IOException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (KeyManagementException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (KeyStoreException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (CertificateException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
        catch (IllegalArgumentException e) {
            throw new JUploadIOException("Unable to open socket", e);
        }
    }

    public void dispose() throws JUploadIOException {
        block17: {
            block16: {
                block15: {
                    try {
                        try {
                            this.outputStream.close();
                        }
                        catch (NullPointerException e) {
                            Object var3_2 = null;
                            this.outputStream = null;
                            break block15;
                        }
                        catch (IOException e) {
                            throw new JUploadIOException(e);
                        }
                        Object var3_1 = null;
                        this.outputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.outputStream = null;
                        throw throwable;
                    }
                }
                try {
                    try {
                        this.inputStream.close();
                    }
                    catch (NullPointerException e) {
                        Object var5_13 = null;
                        this.inputStream = null;
                        break block16;
                    }
                    catch (IOException e) {
                        throw new JUploadIOException(e);
                    }
                    Object var5_12 = null;
                    this.inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var5_14 = null;
                    this.inputStream = null;
                    throw throwable;
                }
            }
            try {
                try {
                    this.socket.close();
                }
                catch (NullPointerException e) {
                    Object var7_17 = null;
                    this.socket = null;
                    break block17;
                }
                catch (IOException e) {
                    throw new JUploadIOException(e);
                }
                Object var7_16 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var7_18 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    public OutputStream getOutputStream() {
        return this;
    }

    public PushbackInputStream getInputStream() {
        return this.inputStream;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResponseBody() {
        return this.httpInputStreamReader.getResponseBody();
    }

    public String getResponseHeaders() {
        return this.httpInputStreamReader.getResponseHeaders();
    }

    public String getResponseMsg() {
        return this.httpInputStreamReader.getResponseMsg();
    }

    public String getStatusLabel() {
        switch (this.connectionStatus) {
            case 0: {
                return "Not initialized";
            }
            case 1: {
                return "Before server connection";
            }
            case 2: {
                return "Writing request to the network";
            }
            case 3: {
                return "Reading server response";
            }
            case 4: {
                return "Connection closed";
            }
        }
        return "Unknown status in HTTPConnectionHelper.getStatusLabel()";
    }

    Socket getSocket() {
        return this.socket;
    }

    public HTTPConnectionHelper append(int b) throws JUploadIOException {
        if (this.connectionStatus == 1) {
            this.byteArrayEncoder.append(b);
        } else if (this.connectionStatus == 2) {
            try {
                this.outputStream.write(b);
            }
            catch (IOException e) {
                throw new JUploadIOException(e.getClass().getName() + " while writing to httpDataOut", e);
            }
        } else {
            throw new JUploadIOException("Wrong status in HTTPConnectionHelper.write() [" + this.getStatusLabel() + "]");
        }
        return this;
    }

    public HTTPConnectionHelper append(byte[] bytes) throws JUploadIOException {
        if (this.connectionStatus == 1) {
            this.byteArrayEncoder.append(bytes);
        } else if (this.connectionStatus == 2) {
            try {
                this.outputStream.write(bytes);
            }
            catch (IOException e) {
                throw new JUploadIOException(e.getClass().getName() + " while writing to httpDataOut", e);
            }
        } else {
            throw new JUploadIOException("Wrong status in HTTPConnectionHelper.write() [" + this.getStatusLabel() + "]");
        }
        if (this.uploadPolicy.getDebugLevel() > 100) {
            this.uploadPolicy.displayDebug("[HTTPConnectionHelper append] (" + bytes.length + " bytes appended to " + (this.connectionStatus == 1 ? " current ByteArrayEncoder" : " socket") + ")", 70);
        }
        return this;
    }

    public HTTPConnectionHelper append(byte[] bytes, int off, int len) throws JUploadIOException {
        if (this.connectionStatus == 1) {
            this.byteArrayEncoder.append(bytes);
        } else if (this.connectionStatus == 2) {
            try {
                this.outputStream.write(bytes, off, len);
            }
            catch (IOException e) {
                throw new JUploadIOException(e.getClass().getName() + " while writing to httpDataOut", e);
            }
        } else {
            throw new JUploadIOException("Wrong status in HTTPConnectionHelper.write() [" + this.getStatusLabel() + "]");
        }
        if (this.uploadPolicy.getDebugLevel() > 100) {
            this.uploadPolicy.displayDebug("[HTTPConnectionHelper append] (" + len + " bytes appended to " + (this.connectionStatus == 1 ? " current ByteArrayEncoder" : " socket") + ")", 101);
        }
        return this;
    }

    public HTTPConnectionHelper append(String str) throws JUploadIOException {
        this.uploadPolicy.displayDebug("[HTTPConnectionHelper append] " + str, 70);
        if (this.connectionStatus == 1) {
            this.byteArrayEncoder.append(str);
        } else if (this.connectionStatus == 2) {
            ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, this.byteArrayEncoder.getBoundary(), this.byteArrayEncoder.getEncoding());
            bae.append(str);
            bae.close();
            this.append(bae);
        }
        return this;
    }

    public HTTPConnectionHelper append(ByteArrayEncoder bae) throws JUploadIOException {
        this.uploadPolicy.displayDebug("[HTTPConnectionHelper append] " + bae.getString(), 70);
        return this.append(bae.getEncodedByteArray());
    }

    public int readHttpResponse() throws JUploadException {
        if (this.connectionStatus != 2) {
            throw new JUploadIOException("Bad status of the connectionHelper in initRequest: " + this.getStatusLabel());
        }
        this.connectionStatus = 3;
        if (this.httpInputStreamReader == null) {
            this.httpInputStreamReader = new HTTPInputStreamReader(this, this.uploadPolicy);
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException ioe) {
            throw new JUploadIOException("flushing outputStream, in " + this.getClass().getName() + ".readHttpResponse()");
        }
        this.httpInputStreamReader.readHttpResponse();
        if (this.httpInputStreamReader.gotClose) {
            this.dispose();
        }
        this.connectionStatus = 4;
        return this.httpInputStreamReader.gethttpStatusCode();
    }

    private void initByteArrayEncoder() throws JUploadIOException {
        if (this.byteArrayEncoder != null && !this.byteArrayEncoder.isClosed()) {
            this.byteArrayEncoder.close();
            this.byteArrayEncoder = null;
        }
        this.byteArrayEncoder = new ByteArrayEncoderHTTP(this.uploadPolicy, this.boundary);
        this.connectionStatus = 1;
        this.proxy = null;
        try {
            this.proxy = ProxySelector.getDefault().select(this.url.toURI()).get(0);
        }
        catch (URISyntaxException e) {
            throw new JUploadIOException("Error while managing url " + this.url.toExternalForm(), e);
        }
        this.useProxy = this.proxy != null && this.proxy.type() != Proxy.Type.DIRECT;
        this.useSSL = this.url.getProtocol().equals("https");
        this.byteArrayEncoder.append(this.method);
        this.byteArrayEncoder.append(" ");
        if (this.useProxy && !this.useSSL) {
            this.byteArrayEncoder.append(this.url.getProtocol()).append("://").append(this.url.getHost());
        }
        this.byteArrayEncoder.append(this.url.getPath());
        if (null != this.url.getQuery() && !"".equals(this.url.getQuery())) {
            this.byteArrayEncoder.append("?").append(this.url.getQuery());
        }
        this.byteArrayEncoder.append(" ").append(this.uploadPolicy.getServerProtocol()).append("\r\n");
        this.byteArrayEncoder.append("Host: ").append(this.url.getHost()).append("\r\nAccept: */*\r\n");
        this.byteArrayEncoder.append("Accept-Encoding: identity\r\n");
        if (!this.uploadPolicy.getAllowHttpPersistent()) {
            this.byteArrayEncoder.append("Connection: close\r\n");
        } else if (!this.bChunkEnabled || this.bLastChunk || this.useProxy || !this.uploadPolicy.getServerProtocol().equals("HTTP/1.1")) {
            this.byteArrayEncoder.append("Connection: close\r\n");
        } else {
            this.byteArrayEncoder.append("Keep-Alive: 300\r\n");
            if (this.useProxy) {
                this.byteArrayEncoder.append("Proxy-Connection: keep-alive\r\n");
            } else {
                this.byteArrayEncoder.append("Connection: keep-alive\r\n");
            }
        }
        this.uploadPolicy.onAppendHeader(this.byteArrayEncoder);
    }

    private boolean isKeepAlive() {
        if (this.socket == null) {
            return true;
        }
        if (!this.uploadPolicy.getAllowHttpPersistent()) {
            return false;
        }
        return this.bChunkEnabled && !this.bLastChunk && !this.useProxy && this.uploadPolicy.getServerProtocol().equals("HTTP/1.1");
    }

    private final String calculateRandomBoundary() {
        StringBuffer sbRan = new StringBuffer(11);
        sbRan.append("-----------------------------");
        String alphaNum = "1234567890abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < 11; ++i) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
        }
        return sbRan.toString();
    }

    public void write(int b) throws IOException {
        try {
            this.append(b);
        }
        catch (JUploadIOException e) {
            if (e.getCause() == null) {
                throw new IOException(e);
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.append(b, off, len);
        }
        catch (JUploadIOException e) {
            if (e.getCause() == null) {
                throw new IOException(e);
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void close() throws IOException {
        throw new IOException("Forbidden action. Please use the " + this.getClass().getName() + ".sendRequest() method");
    }

    public void flush() throws IOException {
        if (this.connectionStatus != 2) {
            throw new IOException("Wrong status in " + this.getClass().getName() + ".flush method: " + this.getStatusLabel());
        }
        this.outputStream.flush();
    }
}

