<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

//This file is included within a function (see codebase.php: jupload_plugin_wakeup)
//So, we need to declare all variables that must be global, as such:
global $JUploadParamList, $CONFIG, $JUPLOAD_CONFIG, $configFileHeader, $juploadParameterPrefix, $config_inc;



//####################################################################################################
//##############################  PARAMETER DEFINITION ###############################################
//####################################################################################################

//These texts will be both displayed on the screen, and written in the configuration file.
//See also the jupload/page/config_page.php file

/*
 * $JUploadParamList is an array of param. Each param contains the following keys:
 * name: the parameter name. It's the key that'll be stored in the $JUPLOAD_CONFIG array.
 * desc: an explanation about the parameter. Only in english. This explanation will only be visible to admins.
 * default: The default value for this parameter.
 * type: the data type for this parameter. Can be 'int' or 'string'. Any unknown value is managed as a string.
 */

$JUploadParamList = array 
(
'albumShowEditFields' => array (
	'desc' => <<<EOS
This parameter controls whether input text boxes of the album title and the album description are displayed
below the albums list, on the upload page. 
<DIR>
 <LI>If the user may create albums, this parameter is not used. This happens when the user is an administrator, 
 or if the user may have his own gallery. In this case, the album title and the album description text box are
 always displayed.
 <LI>If the user may not create albums and is not an administrator:
 <DIR>
  <LI><U>If set to 0</U>, the album title an description fileds are <B>not</B> displayed on the upload page. 
  The user can only choose an album. The user won't see the album's description.
  <LI><U>Otherwise</U> (1 is the default value), these fields are shown. They allow the user to view the album
  title and description, and, if allowed to, the user can update the album or create a new one.
 </DIR>
</DIR>
EOS
,
	'default' => '1',
	'type' => 'int'
	)
,
'alwaysVisible' => array (
	'desc' => <<<EOS
<B>Caution: Signification changed (a little) since v2.4.1 and since 3.0.0 (add of the <I>otherwise</I> section)</B><BR>
<DIR>
 <LI><U>If set to 0</U>, the JUpload link will only be displayed if the user may upload pictures. In this case,
 the user is also allowed to use the plugin. <BR>
 Note: if the user is the administrator, and may not upload picture, he will see the link. He may access to 
 the JUpload configuration page, but not the upload page.
 <LI><U>If set to 1</U>, the JUpload link will always be visible, whenever the user may or may not upload 
 pictures.<BR> 
 If the user clicks on it, here is what happens:<BR>
 <DIR>
  <LI>a- If the user may upload pictures, the upload page containing the applet opens: the user may 
  use the plugin.
  <LI>b- If the user is authenticated, but may not upload pictures, an error message is displayed: the user
  may not user the pugin.
  <LI>c- If the user is not authenticated, an error page containing a link to the login page is displayed. Once 
  connected, the previous rule a or b occurs, depending on its rights.
 </DIR>
 <LI><U>If set to 2</U>, the JUpload link will only be displayed if the user is connected and is an 
 administrator of the gallery.
 <LI><U>Otherwise</U>, this parameter is considered to be a <B>group name</B>. In this case, if one of these two 
 conditions is met, the JUpload link is displayed: 
 <DIR>
 	<LI>The user is an administrator: the JUpload link is displayed, and the user may use the plugin.
 	<LI>If the user is in the group whose name is in this parameter:
 	<DIR>
	 	<LI>If the user may upload picture: The JUpload link is displayed, and the user may 
	 	use the plugin.
	 	<LI>If the user may not upload picture: The JUpload link is displayed, and the user may not 
	 	use the plugin. 
 	</DIR>
 </DIR> 
</DIR>
In release previous to 3.0, values other than 0, 1 or 2 are treated as the default value.
EOS
,
	'default' => '0',
	'type' => 'int'
	)
,
'appletHeight' => array (
	'desc' => <<<EOS
Allows the local administrator, to define a specific height for the applet.
EOS
,
	'default' => '450',
	'type' => 'int'
	)
,
'appletWidth' => array (
	'desc' => <<<EOS
Allows the local administrator, to define a specific width for the applet. This can be useful for theme 
that allows only little place for the 'useful' part of the page, that is ... where the applet is displayed ;-)<BR>
For instance, for the <I>i-feel-dirty</I> them, a width of 450 sould be used instead of the default one.
EOS
,
	'default' => '640',
	'type' => 'int'
	)
,
'basicHttpAuthentication' => array (
	'desc' => <<<EOS
This parameter allows use of basic HTTP authentication in the applet. When using apache, this authentication can be triggered 
through the .htaccess file. See the AuthUserFile, AuthName, AuthType and require. <BR>
Note: To use the <I>basicHttpAuthentication</I> parameter, then <I>AuthType</I> must contain <I>Basic</I>.
<BR>
The format for this parameter is <B><I>user:password</I></B>
<BR>
If empty (default value), this parameter is ignored (no authentication).
EOS
,
	'default' => '',
	'type' => 'string'
	)
,
'browsingDirectory' => array (
	'desc' => <<<EOS
Contains the directory in which the file chooser should open for the first time. If this directory does not exist, or can 
not be read, then, this parameter is ignored.<BR>
This parameter is used only for applet intialization. That is, each time the upload page is refreshed. When the user
stays on the upload page, and clicks several times on the 'Browse' button, the file chooser keeps the directory from the 
previous call. 
EOS
,
	'default' => '',
	'type' => 'string'
	)
,
'debug' => array (
	'desc' => <<<EOS
Put debug mode on, to allow the debug output (in PHP part, and in the applet). This will allow debug output for nobody (false), 
all users (true) or only the administrators (admin).
EOS
,
	'default' => 'false',
	'allowedValues' => array('false', 'true', 'admin'),
	'type' => 'list'
	)
,
'fileChooserIconFromFileContent' => array (
	'desc' => <<<EOS
If this parameter is set to true, the file chooser will replace the default file icons by an icon created
from the picture content.<BR>
Put it to 'false', to avoid this, as it can be CPU and memory consuming, with big directories.<BR>
<U>Note:</U> the icons are created in a separate thread, to avoid impact on the applet use. The applet reacts
to use inputs, even if it is still calculating picture icons for the current directory.
EOS
,
	'default' => 'true',
	'type' => 'string'
	)
,
'fileChooserIconSize' => array (
	'desc' => <<<EOS
This parameter defines the size of the icon to be displayed in the file chooser, when a icon is
created from the file content. See the fileChooserIconFromFileContent parameter, here above.<BR>
EOS
,
	'default' => '50',
	'type' => 'int'
	)
,
'generateDefaultPictureTitle' => array (
	'desc' => <<<EOS
If 0, the picture title is left blank.  
<BR>
Otherwise, the plugin defines a default title for each picture, based on the filename. All
underscores are removed. For instance, when uploading a <I>When_I_m_Happy.jpg</I> file, it creates a default
title <I>When I m Happy</I>.
EOS
	,
	'default' => '1',
	'type' => 'int'
	)
,
'highQualityPreview' => array (
	'desc' => <<<EOS
If set to a non 0 value, the JUpload will display better preview pictures on the applet. But pictures will then display slower 
within the applet. This parameter applies when resizing the picture. Setting it to 1 creates smoother resized 
pictures It is different from the pictureCompressionQuality, that controls the jpeg compression of the files itself.
<BR>
The pictures sent to the server are always of the best available quality, whatever is the value of this parameter.<BR>
<BR>
<B>Since 2.6.0:</B> Default value is now 0, which allows much faster picture display.
EOS
	,
	'default' => '0',
	'type' => 'int'
	)
,
'jarPath' =>array (
	'desc' => <<<EOS
This parameter contains the path where the navigator should find the wjhk.jupload.jar file. This jar file contains 
the JUpload applet, and is absolutely necessary for this plugin.<BR>
It should contain one of the following values, in this order of priority:
 <DIR>
  <LI>Standard case: let this parameter empty. The default value is correct for standard Coppermine configuration.
  <LI>The absolute path of the jar file, ending with a slash, when your installation is not a standard 
  Coppermine installation. For instance, when Coppermine is itself a plugin of another tool.
  For instance: <I>/coppermine/plugins/jupload/</I>
  <LI>The relative path from the page calling the applet, ending by a slash. See the default value for a sample. 
 </DIR> 
EOS
	,
	'default' => 'plugins/jupload/',
	'type' => 'string'
	)
,
'linkComment' => array (
	'desc' => <<<EOS
This parameter allows the admin to override the translated value of JUpload comment. This is the explanation text 
that is displayed when the mouse is over the JUpload button.<BR>
Take care that, if set, this text will be displayed whatever the user language is.<BR>
When this string is empty, the translated value is used. 
EOS
	,
	'default' => '',
	'type' => 'string'
	)
,
'linkKeepStandardUpload' => array (
	'desc' => <<<EOS
Indicates whether you want to keep the upload form, coming with Coppermine, or not. 0 indicates that the standard
upload link should disappear from the menu. 1 means that the two upload links are visible.  
EOS
	,
	'default' => '1',
	'type' => 'int'
	)
,
'linkTitle' => array (
	'desc' => <<<EOS
This parameter allows the admin to override the translated value of JUpload title. This is the text that is 
displayed on the JUpload button.<BR>
Take care that, if set, this text will be displayed whatever the user language is.<BR>
When this string is empty, the translated value is used. 
EOS
	,
	'default' => '',
	'type' => 'string'
	)
,
'maxChunkSize' => array (
	'desc' => <<<EOS
This value is the number of Kb that your webserver will allow for an upload. It may be smaller than the maximum
file size that you allow on your gallery.<BR>
<I>maxChunkSize</I> is a technical parameter, that allows you to override your webserver technical limitation
in upload file size.<BR>
Default is -1, meaning: no chunk. <BR>
If you know the maximum upload size of your webserver (or ISP), put it here. This limitation is often 2Mb, that 
is a value of 2000 for this paramter (default value in PHP configuration). Otherwise, let it empty.<BR>
Note: this value can be smaller than the effective server limitation. 
EOS
	,
	'default' => '500',
	'type' => 'int'
	)
,
'maxFileSize' => array (
	'desc' => <<<EOS
This value is the maximum length of file, in kb, that you allow on your gallery, when uploading with JUpload. 
Default is the maximum file length defined in the Coppermine configuration. <BR>
You can put here a bigger value, than your Coppermine configuration max file, as this one must not be bigger than
the maximum upload size of your server. <BR>
If you put here a bigger value than the maximum upload size of your server, you should define a value for 
<I>maxChunkSize</I>.    <BR>
<U>Note 1:</U> When the upload is done in chunk mode, Coppermine internal code controls the size of the last upload, 
that is : the size of the last chunk, and not the size of the whole uploaded file, that may have been split into 
several chunk. <BR>
<U>Note 2:</U> The default value is based on your Coppermine configuration. 

EOS
	,
	'default' => (isset($CONFIG)) ? $CONFIG['max_upl_size'] : -1, //$CONFIG is not set, when called from ./plugins/jupload/configuration.php	
	'type' => 'int'
	)
,
'maxNonTransformedPictureSize' => array (
	'desc' => <<<EOS
Allows to control which of the applet or the server resizes pictures biggers than the 
<B>maximum picture width and height <U>in pixels</B></U> that you have defined in your Coppermine configuration. This is <U>important as the 
applet will resize pictures much slower than the GD (or ImageMagik) library on your server</U>. But, if the applet
resizes the picture, it will do it before upload. The upload is then much quicker, as the file to transmit will
probably be much smaller than your original picture file (4Mb to 400kb in my case).  
<BR>
This parameters applies only on pictures that the applet does not need to transform (that is: non rotated pictures).
In this case, the applet will resize or not the picture, depending on this parameter.
<BR>
To sum up:
<DIR>
<LI>if you put a value in this field:
	<DIR>
		<LI>Pictures that the user does not modify are resized or not, depending on this parameter.
		<LI>Pictures that the user modifies (picture rotation for instance) are transformed before upload, 
		and the transformed picture file is automatically resized according to the current Coppermine configuration.
	</DIR>
<LI>if you do not put a value in this field, all pictures are resized, before upload, according to the 
Coppermine maxPictureSize.
</DIR>
<BR>If you put a 'big' value in this field. The consequence is:
<DIR>
	<LI>If the picture to upload (width or height) is bigger than the Coppermine maxPictureSize
		<DIR>
		<LI>CPU time is much smaller, as Java is not really quick in picture work.
		<LI>Network traffic is bigger, as your original picture is sent to the server (instead of the resized picture) 
		</DIR>
	<LI>If the width or height of the original picture is less or equal to the Coppermine maximum height/width:
		<DIR>
		<LI>No change wether you use this parameter or not: there is no work to do on pictures to add them to
		your gallery. 
		</DIR>
</DIR>
<B>Be careful</B> that, if you put a big value here, you may encounter limitation with your server maxUploadSize.
You should take a look to the maxChunkSize and maxFileSize parameters.
The default behaviour is to provide the Coppermine maxPictureSize to the applet.
<BR>
<B>Notes: </B>
<DIR>
<LI>This parameter contains a number of pixels, that correspond to the maximum width and height allowed for the picture.
<LI>There is a know java bug, that can change colors for pictures made with some camera. See the 
<A HREF="index.php?file=jupload/jupload&action=config#pictureTransmitMetadata">pictureTransmitMetadata<A> configuration parameter. 
</DIR
   
EOS
	,
	'default' => -1,
	'type' => 'int'
	)
,
JUPLOAD_CONFIG_onError => array (
	'desc' => <<<EOS
Indicates what the applet should do when an error occurs. Possible values are:
<DIR>
<LI>Do nothing: Just displays the error message to the user. No exchange toward the server.
<LI>Log error: the applet send the error to the server. The server logs the error, but does not send any mail to the 
	admin. If an error occurs when sending the log info to the server, it fails silently: no more error message to the user.  
<LI>Mail to the admin: the applet send the error to the server. The server logs the error, then send a mail to the admin, with 
	the full debug output. If an occcurs when sending the mail, an error is displayed to the user.
</DIR>
EOS
	,
	'default' => JUPLOAD_CONFIG_onError_doNothing,
	'allowedValues' => array(JUPLOAD_CONFIG_onError_doNothing, JUPLOAD_CONFIG_onError_mailAdmin),
	'type' => 'list'
	)
,
'pictureCompressionQuality' => array (
	'desc' => <<<EOS
This value represents the quality compression, for jpeg picture files. Bigger quality means higher quality
and bigger file. The default value corresponds to the Coppermine compression quality. See 
<a href="#Behaviour">Plugin behaviour</a> for a global view of how the plugin transform pictures.
EOS
	,
	'default' => '0.8',
	'type' => 'float'
	)
,
'pictureTransmitMetadata' => array (
	'desc' => <<<EOS
Indicates whether metadata are transmitted or not during upload to the Coppermine server.
<BR>
<DIR>
<LI><B>false</B> to block metadata.
<LI><B>true</B> to transmit the metadata.
</DIR>
<B>Notes:</B>
<DIR>
<LI>Since 3.0.0: default value switched to false, to avoir some color problems, that occur with pictures taken from 
some camera, or with some particular picture configuration. Default configuration is safe, and it is up to the
admin to check that upload works with his pictures. 
<LI>Since 3.0.0: fully implemented, even for picture resized or rotated by the applet. Non 
transformed pictures will keep their metadata or not, depending on the value of this parameter.
</DIR>
<B>Caution:</B> when using default value here, this forces the applet to generate the picture file to upload.
The file is then calculated, according to the gallery max picture size (pixels), JUpload 
<a href="#maxNonTransformedPictureSize">maxNonTransformedPictureSize</a> and  
<a href="#pictureCompressionQuality">pictureCompressionQuality</a> configuration parameters. In other words:
take care of this default value that will transform picture, even if you do not want to.  
EOS
	,
	'default' => 'false',
	'type' => 'string'
	)
/*
,
JUPLOAD_CONFIG_SessionManagement => array (
	'desc' => <<<EOS
This value should be used when the user get permission errors, while uploading files with the applet. This error
seems to occur only in bridge mode, and perhaps with some patch that change internal Coppermine code.<BR>  
Allowed values for this parameter are:
<DIR>
	<LI><U>JUpload</U>: JUpload will store the session identifier and a specific JUpload identifier into a 
	specific table. When the plugin receives uploaded files, it checks that the <B>session number</B> and the 
	<B>JUpload specific number</B> and the <B>client IP</B> given in the upload correspond to one line 
	stored in this specific table. If IP is wrong, the corresponding lien is removed from the table, bloking
	any upload with these session parameters (protection against brute force attack).  
	<DIR>
		<LI>If so: the plugin accepts the uploaded file(s). The applet tags the last uploaded file. When this 
		file is uploaded, the corresponding line is removed from the JUpload specific table. These information 
		can not be used by an attacker to upload other files.
		<LI>Otherwise: the plugin generate a permission error.
	</DIR>
	<LI><U>JUpload Simplified:</U> a simplified (understand less secure) version of internal session management.
	In this mode, JUpload do not check the IP of the client. Seems to be necessary for yahoo hosting. Otherwise: 
	this mode is <B>to avoid</B>.
	<LI><U>Other values:</U> The plugins uses standard internal Coppermine code, to identify the user session. 
	<B>(works in most cases)</B>
</DIR>
 
EOS
	,
	'default' => '',
	'allowedValues' => array('', JUPLOAD_CONFIG_SessionManagement_JUpload, JUPLOAD_CONFIG_SessionManagement_JUploadSimplified),
	'type' => 'list'
	)
*/
);


//####################################################################################################
//#################################  INTERNAL VARIABLES  #############################################
//####################################################################################################

$dateTime = getDate();

$configFileHeader = <<<EOS
<?php
/**
 * Caution: This file is generated from the jupload configuration page of JUpload.
 * 
 * You can update it: all modifications on value of valid Jupload parameters will be kept. Comments will be lost
 * if you save the configuration through the jupload configuration page.
 * 
 * To go to the jupload configuration page :
 * - Connect as an admin,
 * - Click on configuration, then General, then 'plugin management',
 * - Click on the 'Jupload Configuration' button that should appear, if JUpload is installed.
 * 
 * TODO: remove the html tags in this file. One day, perhaps ...
 * 
 */
 
EOS
;


//Let's read the current configuration from the config table: all existing parameters have been read
//from the config table, and stored in the $CONFIG array.
initJuploadConfig();


//####################################################################################################
//#################################    FUNCTIONS    ##################################################
//####################################################################################################


/**
 * Writes the list of available parameters, with a link to the coresponding section in this page.
 * It allows a quick view of all available parameters, and a quick access to each part of the page.
 */
function getTableOfContent() {
	global $JUploadParamList;

	$return = "";
	$return .= "<B>Table of content:</B>\n";
	$return .= " <DIR>\n";
	$return .= "  <LI><a href='#Behaviour'>Plugin behaviour</a> <i>(describes the way this plugin works, and what it does with your pictures)</i>\n";
	$return .= "  <LI><a href='#Hints'>Configuration hints</a>\n";
	foreach ($JUploadParamList as $paramName => $param) {
		//$return .= "  <LI><a href='#${param['name']}'>config parameter <I>${param['name']}</I></a>\n";
		$return .= "  <LI><a href='#$paramName'>config parameter <I>$paramName</I></a>\n";
	}
	$return .= " </DIR>\n";
	
	return $return;
}//getTableOfContent


/**
 * Initialization of the JUPLOAD_CONFIG array, from the existing parameters in $CONFIG. The $CONFIG array
 * contains the config table data. All parameter names in this table are prefixed by the content of the
 * $juploadParameterPrefix variable, to be sure that there is no collision with Coppermine internal config parameters.
 * 
 * $useDefaultValue indicates whether default value should be used or not.
 */
function initJuploadConfig($useDefaultValue = true) {
	global $CONFIG, $JUPLOAD_CONFIG, $JUploadParamList, $juploadParameterPrefix;
	
	//Initialization of some technical stuff.
	$JUPLOAD_CONFIG['TABLE_PREFIX'] = "${CONFIG['TABLE_PREFIX']}jupload_";
	$JUPLOAD_CONFIG['TABLE_SESSION'] = "${JUPLOAD_CONFIG['TABLE_PREFIX']}session";
	
	//For all known JUpload parameters: if it's set in the config table, we use this value. Otherwiser, we user
	//the default value for this parameter.
	foreach($JUploadParamList as $paramName=>$param) {
		if (isset($CONFIG[$juploadParameterPrefix . $paramName])) {
			$JUPLOAD_CONFIG[$paramName] = $CONFIG[$juploadParameterPrefix . $paramName];
			//echo("$param_name: default(${JUPLOAD_CONFIG[$paramName]})<BR>");
		} else if ($useDefaultValue) {
			$JUPLOAD_CONFIG[$paramName] = $param['default'];
			//echo("$param_name: default(${param['default']})<BR>");
		}
	}//foreach($JUploadParamList)
	
	//Specific test for some parameters
	
	//alwaysVisible can only be 0, 1 or 2.
	if ($JUPLOAD_CONFIG['alwaysVisible'] != 0 
	 && $JUPLOAD_CONFIG['alwaysVisible'] != 1 
	 && $JUPLOAD_CONFIG['alwaysVisible'] != 2) 
	{
		$JUPLOAD_CONFIG['alwaysVisible'] = $JUploadParamList['alwaysVisible']['default'];
	}
	
	// Since 4.0rc1, the jupload session mnagement is removed.
	unset($JUPLOAD_CONFIG[JUPLOAD_CONFIG_SessionManagement]); 
}

function migrateConfigFileToConfigTable() {
	global $CONFIG, $JUPLOAD_CONFIG, $config_inc;
	
	//First: let's read the 'old' config file.
	unset($JUPLOAD_CONFIG);
	require($config_inc);
	echo("Migrating the JUpload configuration: the $config_inc is not more used. " .
			"Data is now stored in the Coppermine database.<BR>" .
			"<B>This messsage (and migration) will occur only once.</B><BR>");

	//Then: save the config in the database.
	//No need to reload the config, as the one in the file was Ok.  
	saveJuploadConfigParamInCoppermineDatabase($JUPLOAD_CONFIG);
	
	//Now, we remove this old configuration file.
	unlink($config_inc);
	
	//That's all.	
}


/**
 * Save all config parameters defined in $JUploadParamList, that do not have default value in the config table.
 * All other parameters from $JUploadParamList are removed.
 * Note: Coppermine erases the config table when restauring the default configuration, which is nice also 
 * for JUpload..
 * 
 * The configuration to store can be store in any array. The default one is the $_POST superglobal array. But, it
 * seems that $_POST can not be assigned to an array. So, it's handled manually in the foreach.
 */
function saveJuploadConfigParamInCoppermineDatabase(&$paramsToStore) {
	global $juploadParameterPrefix, $JUploadParamList, $CONFIG;

	foreach ($JUploadParamList as $paramName=>$param) {

		//To check the content of the config table, we trust the $CONFIG variable. Won't work
		//if someone updated the config table while the server is managing a submit from the config page.
		//Let's say it's not possible...
		
		//If this parameter was set in the config table
		$parameterValueProtected = 
			str_replace(
				'\'', 
				'\\\'', 
				str_replace(
					'\\', 
					'\\\\', 
					$paramsToStore[$paramName]
					)
				);
		if (isset($CONFIG[$juploadParameterPrefix . $paramName])) {
			//If the value changed, we store it
			if ($CONFIG[$juploadParameterPrefix . $paramName] != $paramsToStore[$paramName]) {
				//If the new value is the default one, we delete the parameter from the config table.
				//Also: we do not accept empty value. Considered as default value.
				if ($paramsToStore[$paramName]==$param['default'] || $paramsToStore[$paramName]=='') {
					cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='$juploadParameterPrefix{$paramName}'");
				} else {
					cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='"
						. $parameterValueProtected
						. "' WHERE name='$juploadParameterPrefix$paramName'");
				}
			}				
		} else {			
			//The parameter was not set in the config table. If the post is not the default value,
			//we store it (insert).
			if ($paramsToStore[$paramName] != $param['default']  &&  $paramsToStore[$paramName] != '') {
				cpg_db_query("INSERT INTO {$CONFIG['TABLE_CONFIG']} (name, value) VALUES ('$juploadParameterPrefix$paramName', '"
					. $parameterValueProtected
					. "')"
					);
			}
		} 
	}//saveJuploadConfigParamInCoppermineDatabase
	
}