<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


/**
 * Taken from the get_subcat_data, from Coppermine core.
 *  
 * Modifications for JUpload:
 * - The function now returns a value, indicating the total number of albums contained in sub-categories
 * - The $CAT_LIST global variable now contains also:
 *    * 'nb_albums_in_subcategories', wich contains the total number of albums in which the user may upload
 *         in all subcategories if the current category.
 *    * 'nb_albums', which contains the number of albums in which the user may upload in the current categories. 
 */
function j_get_subcat_data($parent, $ident = '')
{
    global $CONFIG, $CAT_LIST, $albumsCountPerCategory;
    $return = 0;
    
	if ($CONFIG['categories_alpha_sort'] == 1) {
		$sort_query = 'name';
	} else {
		$sort_query = 'pos';
	}

    $sql =  " SELECT cid, name, description, pos " . 
			" FROM {$CONFIG['TABLE_CATEGORIES']} " . 
			" WHERE parent = '$parent' " . 
			" ORDER BY $sort_query";
	//For the parent 0 (root), we add the 'no category' item.
    $result = cpg_db_query($sql);

    if (($cat_count = mysql_num_rows($result)) > 0) {
        $rowset = cpg_db_fetch_rowset($result);
        $pos = 0;
        $prev_cid = 0;  //Just to prevent a warning in my IDE
        $last_index = 0;//Just to prevent a warning in my IDE
        foreach ($rowset as $subcat) {
	    	$nbAlbums = isset($albumsCountPerCategory[$subcat['cid']]) ? $albumsCountPerCategory[$subcat['cid']] : 0;
            if ($pos > 0) {
                $CAT_LIST[] = array(
					'cid' => $subcat['cid'],
                    'parent' => $parent,
                    'pos' => $pos++,
                    'prev' => $prev_cid,
                    'cat_count' => $cat_count,
                    'name' => $ident . $subcat['name'],
                    'nb_albums' => $nbAlbums,
                    'nb_albums_in_subcategories' => 0
                    );
                $CAT_LIST[$last_index]['next'] = $subcat['cid'];
            } else {
                $CAT_LIST[] = array(
					'cid' => $subcat['cid'],
                    'parent' => $parent,
                    'pos' => $pos++,
                    'cat_count' => $cat_count,
                    'name' => $ident . $subcat['name'],
                    'nb_albums' => $nbAlbums,
                    'nb_albums_in_subcategories' => 0
                    );
            }
            $prev_cid = $subcat['cid'];
            $last_index = count($CAT_LIST) -1;
            $CAT_LIST[$last_index]['nb_albums_in_subcategories'] =
            	j_get_subcat_data($subcat['cid'], $ident . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
            $return += $CAT_LIST[$last_index]['nb_albums'] + $CAT_LIST[$last_index]['nb_albums_in_subcategories']; 
        }//foreach
    }//if
    
    return $return;
}//j_get_subcat_data


/**
 * The following function is taken from the cat_list_box function, and adpated to Jupload.
 * The main differences are:
 * <DIR>
 * <LI>Removing of code that is useless for JUpload
 * <LI>The value is the category id.
 * </DIR> 
 */
function j_cat_list_box()
{
    global $CAT_LIST, $USER_DATA, $lang_albmgr_php, $lang_groupmgr_php, $category;
    global $lang_list_users, $albumsCountPerCategory;

	//Response to onChange: now in Ajax.    
	//First possibility: submit the form. Works Ok. To be removed 
	//$onChange="form_category.submit();";
	//Second possibility: loads the album list for this category in an ajax call.
	//To be validated in all language configurations.
	$onChange="ajax_load_a_category();";

	//Let's construct the list box, with the 'no category' for all.
	$lb = <<<EOT

        <select name="category" class="listbox" onchange="$onChange">
EOT;


	//If the $category is not found in the category list, we switch it
	//to the first displayed category, so that the album list is correctly displayed.
	//$currentCategoryIsDisplayed will indicate if we found the current category.
	$firstDisplayedCategory = -1;
	$currentCategoryIsDisplayed = false;
	
	//If the user may upload pictures to at least one album in 'no category', we display this link.
	$nbAlbumsInNoCategory = isset($albumsCountPerCategory[0]) ? $albumsCountPerCategory[0] : 0;	
	if (GALLERY_ADMIN_MODE || $nbAlbumsInNoCategory > 0) {
		$rootValue = 0;
		$firstDisplayedCategory = 0;
		
		if ($category == 0) {
			$selected = ' selected';
			$currentCategoryIsDisplayed = true;
		} else {
			$selected = '';
		}
			
    	$nbAlbumsTxt = sprintf($lang_list_users['n_albums'], $nbAlbumsInNoCategory);
		$rootText  = "{$lang_albmgr_php['no_category']} ($nbAlbumsTxt)";
		$lb .= <<<EOT

        	<option value="0" $selected>$rootText</option>
EOT;
	}

	//If the user may have its own galery, let's display the 'personal galery' category.	
	if ($USER_DATA['can_create_albums']) {
		$rootValue = FIRST_USER_CAT + USER_ID;
		if ($category == $rootValue) {
			$selected = ' selected';
			$currentCategoryIsDisplayed = true;
		} else {
			$selected = '';
		}
    	$nbAlbumsTxt = sprintf(
    						$lang_list_users['n_albums'], 
    						isset($albumsCountPerCategory[FIRST_USER_CAT + USER_ID]) ? $albumsCountPerCategory[FIRST_USER_CAT + USER_ID] : 0
    					);
		$rootText  = "{$lang_groupmgr_php['personal_gallery']} ($nbAlbumsTxt)";
		$lb .= <<<EOT

        	<option value="$rootValue" $selected>$rootText</option>
EOT;
	}

	//Let's go through all existing categories, and display:
	// If the use is the admin:
	//   All categories.
	// Otherwise:
	//   Only categories that contains:
	//     - albums where the user may upload,
	//     - subcategories that contains albums where the user may upload.
    foreach($CAT_LIST as $cat) {
    	//echo("[j_cat_list_box] Categorie trouvée: " . $cat['cid'] . "<BR>");
    	
    	if (!GALLERY_ADMIN_MODE) {
    		if ($cat['nb_albums'] == 0 && $cat['nb_albums_in_subcategories'] == 0) {
    			//No albums in this category, nor in sub-categories, where the user may upload pictures
    			continue;
    		} 
    	}
    	$nbAlbumsTxt = sprintf(
    						$lang_list_users['n_albums'], 
    						isset($albumsCountPerCategory[$cat['cid']]) ? $albumsCountPerCategory[$cat['cid']] : 0
    					);
    	if ($cat['cid'] != 1) {
    		if ($firstDisplayedCategory < 0) {
    			$firstDisplayedCategory = $cat['cid'];
    		}
    		if ($category == $cat['cid']) {
    			$selected = ' selected';
				$currentCategoryIsDisplayed = true;
			} else {
				$selected = '';
    		}
	       	$lb .= <<<EOT

	    	<option value="${cat['cid']}" $selected>${cat['name']} ($nbAlbumsTxt)</option>
EOT;
    	}
    }

    $lb .= <<<EOT
        </select>

EOT;

	//If the $category has not been found, then $firstDisplayedCategory contains the category that is actually 
	//selected (the first of the list). We then switch $category to it.
	if (!$currentCategoryIsDisplayed) {
		logDebug("Category $category is not displayed. category is switched to $firstDisplayedCategory");
		$category = $firstDisplayedCategory;
	}
	
    return $lb;
}



/**
 * This functions generate the javascript instructions to fill the album list, for a given category and the 
 * current user.
 * Used by: upload_page, to fill the selected category, and by ajax_list_album_of_a_category, to fill the 
 * album list for the newly selected category.
 */
function jsFillAlbumList($category, $localAlbumId) {
	global $lang_upload_php, $CONFIG;

	//First: empty the album list
	echo ("document.form_album.album.length = 0;\n");
	echo ("document.form_album.album.options[0]=new Option('" 
			. prepare_js_string($lang_upload_php['select_album'])
			. "', '');\n");
	
	//Then: fill it.
	
	//jupload.php already checked that the $category is correct.
	if (GALLERY_ADMIN_MODE) {
		$result = cpg_db_query("
				SELECT aid, title, description
				FROM {$CONFIG['TABLE_ALBUMS']}
				WHERE category = $category
				ORDER BY UPPER(title)
				");
	} else if ($category == FIRST_USER_CAT+USER_ID) {
		//The user may see all albums of his/her own gallery!
		$result = cpg_db_query("
				SELECT aid, title, description
				FROM {$CONFIG['TABLE_ALBUMS']}
				WHERE category = $category
				ORDER BY UPPER(title)
				");
	} else {
		$result = cpg_db_query("
				SELECT aid, title, description
				FROM {$CONFIG['TABLE_ALBUMS']}
				WHERE category = $category
				AND uploads='YES'
				AND (visibility = '0' OR visibility IN ".USER_GROUP_SET.")
				ORDER BY UPPER(title)
				");
	}

	$i=0;
	while ($row = mysql_fetch_array($result)) {
		$i = $i + 1;
		$selected = ($localAlbumId == $row['aid']) ? 'true' : 'false';
		echo ("document.form_album.album.options[$i]=new Option('"
			. prepare_js_string($row['title']) 
			. "', '"
			. $row['aid'] 
			. "', $selected);\n");
		echo ("description['"
			. $row['aid'] 
			. "'] = '"
			. prepare_js_string($row['description']) 
			. "'; /*$localAlbumId*/\n");
	}
}//jsFillAlbumList

