<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

/*
 * This include is meant to add additional functions, for script that need to manage pictures.
 * 
 * It is based on the folowing facts:
 * 1) A lot of scripts have specific internal functions to manage the incoming file. 
 *   At least these scripts: db_input, upload, jupload, addpic, xp_publish.
 * 2) Each are slightly different, which means: it's not possible to directly reuse them in another script
 * 3) As these scripts also do input (mix between code that produce output and code that should be included), it's
 *   not possible to include them in another one to reuse code.
 * 4) If a bug exists (especially if it involve security), it's possible that several correction have to be done.
 * 5) Changing anything in the picture management system may become difficult, because many functions can have to be
 * modified.
 * 
 * 
 * This picmgmt.inc.php script contains two _new_ functions:
 * a) add_picture. Used in all other script.
 *   It contains :
 *    - Filetype checks. The xp_publish script also tests this. But, for sure, there must be differences between
 *     these two scripts. 
 *    - Quota management: to insure that the user respects his quota.
 *    - Big, thumb and normal picture calculation (by calls to jupload_resize_image)
 *    - Insert into the database  
 *   But, as I understand it, it lacks :
 *    - Right management. This function assumes that the caller checks if the current user may upload into this
 *     album.
 *    - Moving file to the right directory
 *    - Characters filename control. It also assumes that the file contains only valid characters. For instance, 
 *     filename containing '/', '\' or '.' characters should be carefully managed (also done in xp_publish). Also, 
 *     from
 *     my test, coppermine seems to badly managed spaces, and non-ascii characters (like accents).
 *   
 * b) jupload_resize_image. No trouble: it allows construction of target file, thumn and normal pictures, of the good size, 
 * according to the current gallery configuration. This function should only be called by the add_picture function.
 * 
 * 
 * 
 * This picmgmt.inc.php lacks these functions, that should be centralized and reused in all other scripts:
 * a) handle_one_uploaded_file()
 *   There are at least three scripts that manage uploaded pictures. By upload, I mean sent by an HTTP upload request.
 * b) add_physical_file()
 *   Should be called by handle_one_uploaded_file(), or, for instance, by a script that would unzip an incoming zip file. This 
 *   script should manage strange characters, and make any checks that lacks in add_picture, then call add_picture.
 * c) after_upload()
 *   This function should be called after each successful upload. Currently, it only send a mail if the gallery
 *   is configured to do it.
 * 
 *   The aim of this script is to provide these additional functions. Perhaps it will be incorporated into the
 * picmgmt.inc.php file ...
 *  
 */

logDebug("In j_picmgmt.inc.php (10)");

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

logDebug("In j_picmgmt.inc.php (20)");
include_once("include/iptc.inc.php");
logDebug("In j_picmgmt.inc.php (30)");



define("GIS_GIF", 1);
define("GIS_JPG", 2);
define("GIS_PNG", 3);

// Add 'edit' directory if it doesn't exist
// Set access to read+write only
if (!is_dir($CONFIG['fullpath'].'edit')) {
    $cpg_umask = umask(0);
    @mkdir($CONFIG['fullpath'].'edit',0777);
    umask($cpg_umask);
    unset($cpg_umask);
}

logDebug("In j_picmgmt.inc.php (100) (bis)");

/*

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


//Include language files.
define('UPLOAD_PHP', true);
define('DB_INPUT_PHP', true);
define('ADMIN_PHP', true);

// We load the chosen language file
require "lang/{$CONFIG['lang']}.php";

// Include and process fallback here if lang <> english
if($CONFIG['lang'] != 'english' && $CONFIG['language_fallback']==1 ){
        require "include/langfallback.inc.php";
}
*/
logDebug("In j_picmgmt.inc.php (110)");


/*
 * POSSIBLE BUG FOUND, WHILE LOOKING INTO THE CODE :
 * 
 * 1) upload.php, line 1267: $uploaded_pic seems to be initialized nowhere. It should be null. 
 * 2) picmgmt.inc.php, line 170, function: jupload_resize_image. Mix of $imginfo and $imageinfo.
 * 
 */

/**
 * jupload_cpg_die supersedes the cpg_die functions, for the next functions in this package. It allows
 * to just return a value, or create an HTML error page, depending on the value of the $callCpgDie global var.
 * 
 */
function jupload_cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer = false) {
	global $callCpgDie, $ERROR;

	//If we forgot to initialize $callCpgDie, or if it's true, we do it the standard way.	
	if (!isset($callCpgDie)) {
		$callCpgDie = true;
	}
	
	$ERROR = "($msg_code) $msg_text\n";
	//Removes line feeds
	$ERROR = str_replace('<br />', ' ', $ERROR);
	//Encode properly, so that 'strange' characters display normally, once in the applet.
	$ERROR = 'ERROR: ' . strip_tags($ERROR);
	if (function_exists('mb_convert_encoding')) {
			$ERROR = mb_convert_encoding($ERROR, "UTF-8");
	}				
	
	if ($callCpgDie) {
		return cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer);
	} else {
		//In an upload controled by the applet, we just want the error text in the output. The applet will then 
		//interpret this string, which sould be 'SUCCESS' or 'ERROR: msg'.
		die($ERROR);
	}
}

 
 
logDebug("In j_picmgmt.inc.php (110)");

/*
 * POSSIBLE BUG FOUND, WHILE LOOKING INTO THE CODE :
 * 
 * 1) upload.php, line 1267: $uploaded_pic seems to be initialized nowhere. It should be null. 
 * 2) picmgmt.inc.php, line 170, function: jupload_resize_image. Mix of $imginfo and $imageinfo.
 * 
 */

/**
 * Handle a file received by upload. This function directly manages the _FILES php array that contains uploaded files.
 * It should be called once for each uploaded file. If several files may be uploaded,  it's up to the caller to call
 * this function once for each uploaded file.
 * 
 * This functions does:
 * - Extraction of the file from the $_FILES[$upload_name]
 * - Checks for authorized characters
 * - Calls add_physical_file() to manage the  
 * 
 * Parameters:
 * $aid: the album where the picture should be uploaded. This method will check that the user may add pictures to
 *   this album.
 * $upload_name: The name of the file within the upload. The method will try to add the file contained in the
 *   $_FILES[$upload_name] array. See the php doc for more details. 
 * $picture_attributes: Any attribute that should be inserted into the database, associated to this file. These
 *   attribute are those that can be stored into the global $CURRENT_PIC_DATA array. See picmgmt.inc.php for
 *   a full list.
 * 
 * Returns:
 *   returns an array containing these keys (exactly the same as $escrow_array of upload.php):
 *     'actual_name'    : the target name for the picture.
 *     'temporary_name' : the current temporary filename.
 *    The path is not present in this array (only the filenames), for security reasons.
 */
function handle_uploaded_files($upload_name) {
	global $uploaded_pic;
	
	/*
	 * These lines are mainly a copy/paste from the upload.php script.
	 * 
	 * All lines of the upload.php script rev3275, between 1038 and 1289 'should' be replaced by the 
	 * unique line below:
	 *     handle_uploaded_files('file_upload_array');
	 * 
	 ****************************** 
	 * Here is the list of the modifications I've done:
	 * 
	 * Major modifications:
	 *  - Replace all $_FILES['file_upload_array'] by $_FILES[$upload_name], where $upload_name is a function
	 *   parameter. This make this function generic: it can be called whatever the upload array name. For instance,
	 *   the xp_publish.php script uses user_picture instead of file_upload_array. 
	 * - Remplacements below. They are necessary, as the upload.php script uses input as array, intead of standard
	 *  input name (<input name="file_upload_array[]" size="40" class="listbox" type="file">). So the function below
	 *  is generic nd can be user for upload.php script, and any other standard file upload. 
	 *    $_FILES[$upload_name]['name'][$counter]      replaced by $file_name
	 *    $_FILES[$upload_name]['size'][$counter]      replaced by $file_size
	 *    $_FILES[$upload_name]['tmp_name'][$counter]  replaced by $file_tmp_name
	 *    $_FILES[$upload_name]['type'][$counter]      replaced by $file_type
	 *    $_FILES[$upload_name]['error'][$counter]     replaced by $file_error
	 * 
	 * Minor modifications:
	 * - Remove of most blank lines. My opinion is, as you see less code lines, it's harder to see and
	 *  understand its structure. I let only the blanck line between two logical code bloc, to make the code
	 *  structure more visible.
	 * - Correct some erroneous tabulation (perhaps my tab configuration is just not the same as the one of
	 *  the original developper)
	 */ 

	// Globalize $CONFIG.
	global $CONFIG, $lang_upload_php, $escrow_array, $file_failure_array, $jupload_original_file_name;
	
	// Assign maximum file size for browser crontrols.
	$max_file_size = $CONFIG['max_upl_size'] << 10;
	
	
	//Start of upload.php copy/paste: line 1038, upload.php(rev 3275), after the test :
	//          if ((isset($_POST['control'])) and ($_POST['control'] == 'phase_1'))
	
	
    // $_FILES[$upload_name]['name'][$counter]
    // $_FILES[$upload_name]['size'][$counter]
    // $_FILES[$upload_name]['tmp_name'][$counter]
    // $_FILES[$upload_name]['type'][$counter]
    // $_FILES[$upload_name]['error'][$counter]
    //
    // Error values:
    // 0 - No error
    // 1 - Exceeded filesize allowed in php.ini
    // 2 - Exceeded filesize allowed by HTML MAX_FILE_SIZE
    // 3 - Only a partial upload
    // 4 - No upload occurred.

    $file_upload_count = count($_FILES[$upload_name]['name']);

    if ($file_upload_count > 0) {
    	
        // Check for error code support. Set the error code.
        if (count($_FILES[$upload_name]['error']) == 0) {
            // This version of PHP does not support error codes (PHP < 4.2.0).  Create our own error code.
            $error_code = 'default';
        } else {
            // We have error support.
            $error_support = 'TRUE';
        }

        for ($counter = 0; $counter < $file_upload_count; $counter++) {
        	//////////////////////////////////////////////////////////////////////////////////:
        	//  Add of a local specific test (doesn't exist in upload.php). This allow this function to be
        	//called for standard upload, or from upload.php, which uses arrays.
		    if (is_array($_FILES[$upload_name]['name'])) {
				//echo("DEBUG(j_picmgmt.inc.php): upload as an array\n");    
		    	//The upload was done by using an array like the one below:
		    	//<input name="file_upload_array[]" size="40" class="listbox" type="file">
		    	//(from ./upload.php).
				$file_name		= $_FILES[$upload_name]['name'][$counter];
				$file_size		= $_FILES[$upload_name]['size'][$counter]; 
				$file_tmp_name	= $_FILES[$upload_name]['tmp_name'][$counter];
				$file_type		= $_FILES[$upload_name]['type'][$counter];
				$file_error     = $_FILES[$upload_name]['error'][$counter];
		    } else { 
				//echo("DEBUG(j_picmgmt.inc.php): upload with standard http variable\n");    
				$file_name		= $_FILES[$upload_name]['name'];
				$file_size		= $_FILES[$upload_name]['size']; 
				$file_tmp_name	= $_FILES[$upload_name]['tmp_name'];
				$file_type		= $_FILES[$upload_name]['type'];
				$file_error     = $_FILES[$upload_name]['error'];
			}
			echo("[DEBUG] j_picmgmt.inc.php: receiving the '$file_name' file.\n");

			//We must return to ASCII characters, in order to have UTF-8 encoded, and not the
			//corresponding characters. This is necessary to make the replace_forbidden Coppermine 
			//function detect unallowed characters.
			$jupload_original_file_name = $file_name; 
			if (function_exists('mb_convert_encoding')) {
					$file_name = mb_convert_encoding($file_name, "US-ASCII", "UTF-8");
			}			
			
			//End of this specific test: back to the upload.php script.
        	//////////////////////////////////////////////////////////////////////////////////:

            // Check for error code support. Set the error code.
            if ($error_support) {
                $error_code = $file_error;
            }
            
        	//////////////////////////////////////////////////////////////////////////////////:
        	//  Add of a local specific test (doesn't exist in upload.php). This controls if
        	// error occured, and 'display' its code.
        	if ($error_code > 0 && !is_array($error_code)) {
        		//Too bad, an error occured.
				//echo("ERROR(j_picmgmt.inc.php): an error occured during upload. Error code was $error_code (file counter: $counter, file name:$file_name)\n");
				continue;
        	}
			//End of this specific test: back to the upload.php script.
        	//////////////////////////////////////////////////////////////////////////////////:
            
            
            // Create the failure ordinal for ordering the report of failed uploads.
            $failure_cardinal = $counter + 1;
            $failure_ordinal = ''.$failure_cardinal.'. ';
            
            // If there is no file name, make a dummy name for the error reporting system.
            if (($file_name == '')) {
                $file_name = 'filename_unavailable';
				echo("WARNING(j_picmgmt.inc.php): filename_unavailable\n");    
            } else {
                $file_name = $file_name;
            }

            // Test for a blank file upload box.
            if (empty($file_tmp_name)) {
                // There is no need for further tests or action as there was no uploaded file,
                //so skip the remainder of the iteration.
				//echo("WARNING(j_picmgmt.inc.php): empty(file_tmp_name), error was $file_error\n");    
                continue;
            }
            //echo("DEBUG(j_picmgmt.inc.php): non empty(file_tmp_name) $file_tmp_name<BR>\n");

            // Check to make sure the file was uploaded via POST.
            if (!is_uploaded_file($file_tmp_name)) {
                // We reject the file, and make a note of the error.
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['no_post']);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;
            }

            // Check filename and extension:

            // Check that the file uploaded has a valid name and extension, and replace forbidden chars with underscores.

            // Initialise the $matches array.
            $matches = array();

            // If magic quotes is on, remove the slashes it added to the file name.
            if (get_magic_quotes_gpc()) { 
            	$file_name = stripslashes($file_name);
            }

            // Create the holder $picture_name by translating the file name. Translate any forbidden character into an underscore.
            $picture_name = replace_forbidden($file_name);

            // Analyze the file extension using regular expressions.
            if (!preg_match("/(.+)\.(.*?)\Z/", $picture_name, $matches)) {
                // The file name is invalid.
                $matches[1] = 'invalid_fname';
                // Make a bogus file extension to trigger Coppermine's defenses.
                $matches[2] = 'xxx';
            }

            // If there is no extension, or if the extension is unknown/not permitted by Coppermine, zap the intruder.
            if ($matches[2] == '' || !is_known_filetype($matches)) {
                // We reject the file, and make a note of the error.
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['forb_ext']);
                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;
            }


            // Check for upload errors.

            if (!($error_code == '0') and !($error_code == 'default')) {
                // PHP has detected a file upload error.
                if ($error_code == '1') {
                    $error_message = $lang_upload_php['exc_php_ini'];
                } elseif ($error_code == '2') {
                    $error_message = $lang_upload_php['exc_file_size'];
                } elseif ($error_code == '3') {
                    $error_message = $lang_upload_php['partial_upload'];
                } elseif ($error_code == '4') {
                    $error_message = $lang_upload_php['no_upload'];
                } else {
                    $error_message = $lang_upload_php['unknown_code'];
                }

                //Make a note in the error array.
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$error_message);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;

            } elseif ($file_tmp_name == '') {
                // There is no temporary file, so the file did not upload. Make a note of it in the file_failure_arrray and flip 
                //the failure switch to generate the ordinal. 
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['no_temp_name']);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;

            } elseif ($file_size <= 0) {
                // The file contains no data or was corrupted. Make a note of it in the error array.
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['no_file_size']);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;

            } elseif ($file_size > $max_file_size) {
                // The file exceeds the amount specified by the max upload directive. Either the browser is stupid, or 
                //somebody isn't playing nice. (Ancient browser - MAX_UPLOAD forgery)
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['exc_file_size']);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;
            }

            // Now we need to move the file into the /edit directory.

            // We need specify the path for the transitory file.

            // Create a prefix for easier human recognition.
            $prefix = "mHTTP_temp_";

            //Set the correct file extension.
            $suffix = $matches[2];

            // Generate the unique name. Keep generating new names until one that is not in use is found.
            do {
                // Create a random seed by taking the first 8 characters of an MD5 hash of a concatenation of the current UNIX epoch time and the current server process ID.
                $seed = substr(md5(uniqid("")), 0, 8);

                // Assemble the file path.
                $path_to_image = './'.$CONFIG['fullpath'].'edit/'. $prefix . $seed . '.' . $suffix;
            } while (file_exists($path_to_image));

            // Create a holder called $tempname.
            $tempname = $prefix . $seed . '.' . $suffix;

            //Now we upload the file.
            if (!(move_uploaded_file($file_tmp_name, $path_to_image))) {
                // The file upload has failed.
                $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['impossible']);

                // There is no need for further tests or action, so skip the remainder of the iteration.
                continue;
            }

            // Change file permission
            @chmod($path_to_image, octdec($CONFIG['default_file_mode'])); //silence the output in case chmod is disabled

            // Create a testing alias.
            $picture_alias = $matches[1].".".$matches[2];
            
			//////////////////////////////////////////////////////////////////////////////////////////
			// JUpload modification start: if it's a chunk, we concatenate it with the any previously chunk
			// for this picture.
			global $chunkedUpload, $jupart, $jufinal, $USER;
			if ($chunkedUpload) {
				//We are in chunk mode.
				 
				//Here is a upload filename unique, and stable for our upload. This suppose that files are
				//uploaded one by one (otherwise, two files with the same name could be uploaded in one step, 
				//for instance if they come from two different directory on the source computer).
				$finalFilename = $USER['ID'] . '_' . $picture_alias;				
				$path_to_reconstructed_file =  './'.$CONFIG['fullpath'].'edit/' . $finalFilename; 
				
				if ($jupart == 1) {
					//This is the first chunk: we just move this first chunk to our final temp file. Its filename
					//must be stable and unique, so that we can find it in the next upload.
					//First: we remove the file, if it alredy exist from a previous try.
					if (file_exists($path_to_reconstructed_file)) {
						unlink($path_to_reconstructed_file);
					}
					rename($path_to_image, $path_to_reconstructed_file);
				} else {
					//The first chunk is managed by the standard code available above. For next chunks, we have
					//to concatenate the current chunk, with the already uploaded part(s).
					$fwrite = fopen($path_to_reconstructed_file, 'a');
					$fread = fopen($path_to_image, 'r');
					
					while (  ($buff=fread($fread, 1000)) != '') {
						fwrite($fwrite, $buff);
					}
					fclose($fread);
					fclose($fwrite);
				}
				//The following of this function should use the new path_to_image:
				//This is really useful only when we receive the last chunk.
				$path_to_image = $path_to_reconstructed_file;
				
				if ($jufinal) {
					//Ok, let's indicate the reconstructed file
					$tempname = $finalFilename;
				} else {
					//If we've not read the last chunk, the is_image must return wrong, otherwise, it will
					//try to work on a partial file.
					$picture_alias = "this file is chunked and.is_not_a_picture_yet";
				}
			}//if($chunkedUpload)
			// JUpload modification end.
			//////////////////////////////////////////////////////////////////////////////////////////
            // Check to see if the filename is consistent with that of a picture.
            if (is_image($picture_alias)) {
                // If it is, get the picture information
                $imginfo = getimagesize($path_to_image);

                // If getimagesize does not recognize the file as a picture, delete the picture.
                if ($imginfo === 'FALSE') {
                    @unlink($path_to_image);
                    
                    // The file upload has failed -- the image is not an image or it is corrupt.
                    $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['not_image']);

                    // There is no need for further tests or action, so skip the remainder of the iteration.
                    continue;

                // JPEG and PNG only are allowed with GD. If the image is not allowed for GD,delete it.
                //} elseif ($imginfo[2] != GIS_JPG && $imginfo[2] != GIS_PNG && ($CONFIG['thumb_method'] == 'gd1' || $CONFIG['thumb_method'] == 'gd2')) {
                } elseif ($imginfo[2] != GIS_JPG && $imginfo[2] != GIS_PNG && $CONFIG['GIF_support'] == 0) {
                    @unlink($path_to_image);

                    // The file upload has failed -- the image is not allowed with GD.
                    $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['not_GD']);

                    // There is no need for further tests or action, so skip the remainder of the iteration.
                    continue;

                // Check that picture size (in pixels) is lower than the maximum allowed. If not, delete it.
                } elseif (max($imginfo[0], $imginfo[1]) > $CONFIG['max_upl_width_height']) {
                  if ((USER_IS_ADMIN && $CONFIG['auto_resize'] == 1) || (!USER_IS_ADMIN && $CONFIG['auto_resize'] > 0)) //($CONFIG['auto_resize']==1)
                  {
                  	//It seems like $uploaded_pic is defined nowhere. Let's trace it:
                  	if (!isset($uploaded_pic)) {
                  		log_write('Bug in j_picmgmt.inc.php (so there is also a bug in upload.php, line 1267): $uploaded_pic is not defined');
                  		//Let's go on, and like if everything is Ok. It will probably work ... ??    ;-)
                  	}
                  	
                    //jupload_resize_image($uploaded_pic, $uploaded_pic, $CONFIG['max_upl_width_height'], $CONFIG['thumb_method'], $imginfo[0] > $CONFIG['max_upl_width_height'] ? 'wd' : 'ht');
                    jupload_resize_image($uploaded_pic, $uploaded_pic, $CONFIG['max_upl_width_height'], $CONFIG['thumb_method'], $CONFIG['thumb_use']);
                  }
                  else
                  {
                    @unlink($path_to_image);

                    // The file upload has failed -- the image dimensions exceed the allowed amount.
                    $file_failure_array[] = array( 'failure_ordinal'=>$failure_ordinal, 'file_name'=> $file_name, 'error_code'=>$lang_upload_php['pixel_allowance']);

                    // There is no need for further tests or action, so skip the remainder of the iteration.
                    continue;
                  }
                }

            // Image is ok
            }

            // Put array info for a successful upload in $escrow_array. Hold the actual file name and the name of 
            //the temporary image. We do not use the path for security reasons.
            $escrow_array[] = array('actual_name'=>$picture_alias, 'temporary_name'=>$tempname);
        } // end for loop
    }//if ($file_upload_count > 0) {
    	
	//End of upload.php copy/paste: line 1289, upload.php (rev 3275), before :
	//         
	//             // Count the number of items in the URI array.
	//             $URI_upload_count = count($_POST['URI_array']);
	//         
	//             if ($URI_upload_count > 0) {
}

logDebug("In j_picmgmt.inc.php (120)");


/*
 * 
 */
function jupload_add_physical_file($album, $pic_filename, $tmp_file, $title='', $caption='', $keywords='', $user1='', $user2='', $user3='', $user4='', $category='', $raw_ip='', $hdr_ip='', $movie_wd='', $movie_ht='') {
	/*
	 * These lines are mainly a copy/paste from the upload.php script.
	 * 
	 * All lines of the upload.php script rev3275, between 2206 and 2290 'should' be replaced by the 
	 * unique line below:
	 *     $file_placement = add_physical_file($album, $file_set[0], $file_set[1], $title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $movie_wd, $movie_ht);
	 * 
	 ******************************
	 *
	 ****************************** 
	 * Here is the list of the modifications I've done:
	 * 
	 * Major modifications:
	 *  - Replace all $_FILES['file_upload_array'] by $_FILES[$upload_name], where $upload_name is a function
	 *   parameter. This make this function generic: it can be called whatever the upload array name. For instance,
	 *   the xp_publish.php script uses user_picture instead of file_upload_array. 
	 * - Replace all calls to cpg_die by 'return jupload_cpg_die'. This new function calls return jupload_cpg_die or just return an error, 
	 *   depending on the value of $callCpgDie.
	 * 
	 * Minor modifications:
	 * - Remove of most blank lines. My opinion is, as you see less code lines, it's harder to see and
	 *  understand its structure. I let only the blanck line between two logical code bloc, to make the code
	 *  structure more visible.
	 * - Correct some erroneous tabulation (perhaps my tab configuration is just not the same as the one of
	 *  the original developper)
	 */ 

	//Start of upload.php copy/paste: line 2206, upload.php(rev 3275), after the end of the test :
	//          if(isset($_POST['movie_ht'])) {
	//              ..
	//			} else {
	//              ..
	//          } 	

	// Globalize $CONFIG.
	global $CONFIG, $lang_upload_php, $lang_db_input_php;

        // Check if the album id provided is valid
        if (!GALLERY_ADMIN_MODE) {
            $result = cpg_db_query(
            		"
            		SELECT category 
            		FROM {$CONFIG['TABLE_ALBUMS']} 
            		WHERE aid='$album' 
            		AND (
            				uploads = 'YES' 
            			OR	category = '" . (USER_ID + FIRST_USER_CAT) . "'
            			)
					");
            if (mysql_num_rows($result) == 0) return jupload_cpg_die(ERROR, $lang_db_input_php['unknown_album'], __FILE__, __LINE__);
            $row = mysql_fetch_array($result);
            mysql_free_result($result);
            $category = $row['category'];
        } else {
            $result = cpg_db_query("SELECT category FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid='$album'");
            if (mysql_num_rows($result) == 0)  {
            	return jupload_cpg_die(ERROR, $lang_db_input_php['unknown_album'], __FILE__, __LINE__);
            }
            $row = mysql_fetch_array($result);
            mysql_free_result($result);
            $category = $row['category'];
        }

        // Pictures are moved in a directory named 10000 + USER_ID
        if (USER_ID && !defined('SILLY_SAFE_MODE')) {
            $filepath = $CONFIG['userpics'] . (USER_ID + FIRST_USER_CAT);
            $dest_dir = $CONFIG['fullpath'] . $filepath;
            if (!is_dir($dest_dir)) {
                mkdir($dest_dir, octdec($CONFIG['default_dir_mode']));
                if (!is_dir($dest_dir)) {
	            	return jupload_cpg_die(CRITICAL_ERROR, sprintf($lang_db_input_php['err_mkdir'], $dest_dir), __FILE__, __LINE__, true);
	            }
                @chmod($dest_dir, octdec($CONFIG['default_dir_mode'])); //silence the output in case chmod is disabled
                $fp = fopen($dest_dir . '/index.html', 'w');
                fwrite($fp, ' ');
                fclose($fp);
            }
            $dest_dir .= '/';
            $filepath .= '/';
        } else {
            $filepath = $CONFIG['userpics'];
            $dest_dir = $CONFIG['fullpath'] . $filepath;
        }

		//////////////////////////////////////////////////////////////////////////////////////////
		// JUpload modification start: We store all uploaded files in a subdirectory. The 
		//objective is to be sure that the number of files in a subdirectory is not too big. If
		//it becomes too big (ex: the admin uploads thousands of pictures of hundred albums in the
		//same directory), the time finding a picture file in a directory becomes a bottleneck.
		//
		//So, we try creating a subbdirectory for this album. If it doesn't work, we fail silently.
		//We force $album as an int as a try to avoid internet attack.
		$filepath_jupload = $filepath . ((int)$album) . '/';
		$dest_dir_jupload = $dest_dir . ((int)$album) . '/';
		
		//If the directory doesn't exist, we try to create it.
		if (!is_dir($dest_dir_jupload)) {
        	echo ("[DEBUG] j_picmgmt.inc.php: the directory does't exist. We create it.\n");
			@mkdir($dest_dir_jupload, octdec($CONFIG['default_dir_mode']));
		} 
		
		//If it still doesn't exist, nothing to do: we use the default Coppermine behaviour: all files
		//in one directory. Not efficient ... but it works!  :-)		  
        if (is_dir($dest_dir_jupload)) {
        	// Can we write in it ?
        	if (! is_writable($dest_dir_jupload)) {
            	echo ("[DEBUG] j_picmgmt.inc.php: the directory can not be written in. We try chmod.\n");
	            @chmod($dest_dir_jupload, octdec($CONFIG['default_dir_mode'])); //silence the output in case chmod is disabled
        	}

			// Can we now write in this directory ?
        	if (is_writable($dest_dir_jupload)) {
        		// If yes, we use it. Otherwise, we use default Coppermine behaviour.
        		$index_file = $dest_dir_jupload . 'index.html';
        		if (!file_exists($index_file)) {
	        		//We create a default index.html file, to hide the directory content.        		
		            $fp = fopen($index_file, 'w');
		            fwrite($fp, ' ');
		            fclose($fp);
		            echo ("[DEBUG] j_picmgmt.inc.php: the index.html has been created.\n");
        		} 
        		
        		//A last check.
        		if (file_exists($index_file)) {
		        	// Ok, we created the index.html. So, the directory exists and is writable. 
		        	// Let's use it !
		        	$dest_dir = $dest_dir_jupload;
		        	$filepath = $filepath_jupload;
        		}
        	}
        }
		//////////////////////////////////////////////////////////////////////////////////////////
        
        // Check that target dir is writable
        if (!is_writable($dest_dir)) {
        	return jupload_cpg_die(CRITICAL_ERROR, sprintf($lang_db_input_php['dest_dir_ro'], $dest_dir), __FILE__, __LINE__, true);
        }

        //Add the Perl regex to break the actual name.
        preg_match("/(.+)\.(.*?)\Z/", $pic_filename, $matches);

        // Create a unique name for the uploaded file
        $nr = 0;
        $picture_name = $matches[1] . '.' . $matches[2];
        while (file_exists($dest_dir . $picture_name)) {
            $picture_name = $matches[1] . '~' . $nr++ . '.' . $matches[2];
        }

        // Create path for final location.
        $uploaded_pic = $dest_dir . $picture_name;

        // Form path to temporary image.
        $path_to_image = './'.$CONFIG['fullpath'].'edit/'.$tmp_file;

        // prevent moving the edit directory...
        if (is_dir($path_to_image)) {
        	return jupload_cpg_die(CRITICAL_ERROR, $lang_upload_php['failure'] . " - '$path_to_image'", __FILE__, __LINE__, true);
        }

        // Move the picture into its final location
        if (rename($path_to_image, $uploaded_pic)) {
            // Change file permission
            @chmod($uploaded_pic, octdec($CONFIG['default_file_mode'])); //silence the output in case chmod is disabled
            // Create thumbnail and internediate image and add the image into the DB
            $result = jupload_add_picture($album, $filepath, $picture_name, 0,$title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $movie_wd, $movie_ht);
            //
            if (!$result) {
                // The file could not be placed.
				echo("[debug] $path_to_image => $uploaded_pic\n");
                $file_placement = 'no1';
            } else {
                // The file was placed successfully.
                $file_placement = 'yes';
            }
        } else {
            // The file was not placed successfully.
			echo("[debug] $path_to_image => $uploaded_pic\n");
            $file_placement = 'no2';
        }

	//End of upload.php copy/paste: line 2290, upload.php (rev 3275), before :
	//         
	//             // Time for garbage cleanup.
	
	
	return $file_placement;
}


logDebug("In j_picmgmt.inc.php (130)");



/**
 * after_upload execute any global required action after a successfull upload. Currently, one action can be done:
 * - Send a notification to the admin, depending on the current upload (see $PIC_NEED_APPROVAL) and on the 
 *   configuration status (see $CONFIG['upl_notify_admin_email']).
 * 
 * A call to this method should be added in the following scripts:
 * - xp_publish.php (no mail is sent after a successful upload)
 * - db_input.php (a mail is sent after a successful upload)    
 */
function after_upload() {
	global $CONFIG, $PIC_NEED_APPROVAL;
	
	//The lines below are a copy/paste of lines 2334 to 2346 from the upload.php

	if (  ($CONFIG['upl_notify_admin_email']) and ($PIC_NEED_APPROVAL)  ) {
	    // Encapsulate so included lang file doesn't interfere with global one
	    //etienne_sf: this could propably be simplified, now that it's in  specific function.
	    function cpg_send_upload_notification() {
	        global $CONFIG;
	        $lang_db_input_php = cpg_get_default_lang_var('lang_db_input_php');
	        // Get the mail files.
	        include_once('include/mailer.inc.php');
	
	        // Send the message.
	        cpg_mail('admin', sprintf($lang_db_input_php['notify_admin_email_subject'], $CONFIG['gallery_name']), sprintf($lang_db_input_php['notify_admin_email_body'], USER_NAME,  $CONFIG['ecards_more_pic_target']. (substr( $CONFIG["ecards_more_pic_target"], -1) == '/' ? '' : '/') .'editpics.php?mode=upload_approval' ));
	    }
	    
	    
	    
	    cpg_send_upload_notification();
	}
}



logDebug("In j_picmgmt.inc.php (140)");





// Add a picture to an album
function jupload_add_picture($aid, $filepath, $filename, $position = 0, $title = '', $caption = '', $keywords = '', $user1 = '', $user2 = '', $user3 = '', $user4 = '', $category = 0, $raw_ip = '', $hdr_ip = '', $iwidth = 0, $iheight = 0)
{
    global $CONFIG, $ERROR, $USER_DATA, $PIC_NEED_APPROVAL, $JUPLOAD_CONFIG;
    global $lang_errors;

	echo("[DEBUG]    (start of jupload_add_picture) title: " . $title . "\r\n");
	
    $image = $CONFIG['fullpath'] . $filepath . $filename;
    $normal = $CONFIG['fullpath'] . $filepath . $CONFIG['normal_pfx'] . $filename;
    $thumb = $CONFIG['fullpath'] . $filepath . $CONFIG['thumb_pfx'] . $filename;

    if (!is_known_filetype($image)) {
    	echo("ERROR: unknown filetype for $image (see jupload_add_picture)");
        return false;
    } elseif (is_image($filename)) {
        $imagesize = getimagesize($image);

        if ($CONFIG['read_iptc_data']) {
           $iptc = get_IPTC($image);
           if (is_array($iptc) && !$title && !$caption && !$keywords) {  //if any of those 3 are filled out we don't want to override them, they may be blank on purpose.
               $title = (isset($iptc['Title'])) ? $iptc['Title'] : $title;
               $caption = (isset($iptc['Caption'])) ? $iptc['Caption'] : $caption;
               $keywords = (isset($iptc['Keywords'])) ? implode(' ',$iptc['Keywords']) : $keywords;
           		echo("[DEBUG] picture properties set from IPTC data:\r\n");
           		echo("[DEBUG]    title: " . $title . "\r\n");
           		echo("[DEBUG]    caption: $caption\r\n");
           		echo("[DEBUG]    keywords: $ti$keywordstle\r\n");
           }
        }
////////////////////////////////////////////////////////////////////////////////
//JUpload add: if title is empty, we take the  filename (without the extension)
//as the default title.
//This must be here, and not in the caller of this function, as title may be read from IPTC data.
//TODO this should probably be in the 'add_file_data' Coppermine hook.
/*
		if ($title == '' && $JUPLOAD_CONFIG['generateDefaultPictureTitle']) {
		    // Analyze the file extension using regular expressions.
		    if (!preg_match("/(.+)\.(.*?)\Z/", $filename, $fmatches)) {
		    	//The regular expression is taken from the previously called Coppermine function.
		    	//So, how can it be, that we got here ????????
		    	return jupload_cpg_die(ERROR, "internal error while reading the extension, for file '$filename'", __FILE__, __LINE__);
		    }
			$title = str_replace("_", " ", rawurldecode($fmatches[1]));
		}
*/
//End of Jupload add.
////////////////////////////////////////////////////////////////////////////////
        if (((USER_IS_ADMIN && $CONFIG['auto_resize'] == 1) || (!USER_IS_ADMIN && $CONFIG['auto_resize'] > 0)) && max($imagesize[0], $imagesize[1]) > $CONFIG['max_upl_width_height']) //$CONFIG['auto_resize']==1
        {
          //jupload_resize_image($image, $image, $CONFIG['max_upl_width_height'], $CONFIG['thumb_method'], $imagesize[0] > $CONFIG['max_upl_width_height'] ? 'wd' : 'ht');
          jupload_resize_image($image, $image, $CONFIG['max_upl_width_height'], $CONFIG['thumb_method'], $CONFIG['thumb_use']);
          $imagesize = getimagesize($image);
        }
        if (!file_exists($thumb)) {
            if (!jupload_resize_image($image, $thumb, $CONFIG['thumb_width'], $CONFIG['thumb_method'], $CONFIG['thumb_use']))
                return false;
        }
        if (max($imagesize[0], $imagesize[1]) > $CONFIG['picture_width'] && $CONFIG['make_intermediate'] && !file_exists($normal)) {
            if (!jupload_resize_image($image, $normal, $CONFIG['picture_width'], $CONFIG['thumb_method'], $CONFIG['thumb_use']))
                return false;
        }
    } else {
        $imagesize[0] = $iwidth;
        $imagesize[1] = $iheight;
    }

    $image_filesize = filesize($image);
    $total_filesize = is_image($filename) ? ($image_filesize + (file_exists($normal) ? filesize($normal) : 0) + filesize($thumb)) : ($image_filesize);


    // Test if disk quota exceeded
    if (!GALLERY_ADMIN_MODE && $USER_DATA['group_quota']) {
        $result = cpg_db_query("SELECT sum(total_filesize) FROM {$CONFIG['TABLE_PICTURES']}, {$CONFIG['TABLE_ALBUMS']} WHERE  {$CONFIG['TABLE_PICTURES']}.aid = {$CONFIG['TABLE_ALBUMS']}.aid AND category = '" . (FIRST_USER_CAT + USER_ID) . "'");
        $record = mysql_fetch_array($result);
        $total_space_used = $record[0];
        mysql_free_result($result);

        if ((($total_space_used + $total_filesize)>>10) > $USER_DATA['group_quota'] ) {
            @unlink($image);
            if (is_image($image)) {
                @unlink($normal);
                @unlink($thumb);
            }
            $msg = strtr($lang_errors['quota_exceeded'], array('[quota]' => ($USER_DATA['group_quota']),
                '[space]' => ($total_space_used >> 10)));
            return jupload_cpg_die(ERROR, $msg, __FILE__, __LINE__);
        }
    }
    // Test if picture requires approval
    if (GALLERY_ADMIN_MODE) {
        $approved = 'YES';
    } elseif (!$USER_DATA['priv_upl_need_approval'] && $category == FIRST_USER_CAT + USER_ID) {
        $approved = 'YES';
    } elseif (!$USER_DATA['pub_upl_need_approval'] && $category < FIRST_USER_CAT) {
        $approved = 'YES';
    } else {
        $approved = 'NO';
    }
    $PIC_NEED_APPROVAL = ($approved == 'NO');

    // User ID is now recorded when in admin mode (casper)
    $user_id = USER_ID;
    $username= USER_NAME;
    // Populate Array to pass to plugins, then to SQL.
    $CURRENT_PIC_DATA['aid'] = $aid;
    $CURRENT_PIC_DATA['filepath'] = $filepath;
    $CURRENT_PIC_DATA['filename'] = $filename;
    $CURRENT_PIC_DATA['filesize'] = $image_filesize;
    $CURRENT_PIC_DATA['total_filesize'] = $total_filesize;
    $CURRENT_PIC_DATA['pwidth'] = $imagesize[0];
    $CURRENT_PIC_DATA['pheight'] = $imagesize[1];
    $CURRENT_PIC_DATA['owner_id'] = $user_id;
    $CURRENT_PIC_DATA['owner_name'] = $username;
    $CURRENT_PIC_DATA['title'] = $title;
    $CURRENT_PIC_DATA['caption'] = $caption;
    $CURRENT_PIC_DATA['keywords'] = $keywords;
    $CURRENT_PIC_DATA['approved'] = $approved;
    $CURRENT_PIC_DATA['user1'] = $user1;
    $CURRENT_PIC_DATA['user2'] = $user2;
    $CURRENT_PIC_DATA['user3'] = $user3;
    $CURRENT_PIC_DATA['user4'] = $user4;
    $CURRENT_PIC_DATA['pic_raw_ip'] = $raw_ip;
    $CURRENT_PIC_DATA['pic_hdr_ip'] = $hdr_ip;
    $CURRENT_PIC_DATA['position'] = $position;
    $CURRENT_PIC_DATA = CPGPluginAPI::filter('add_file_data',$CURRENT_PIC_DATA);

    $query = " 
    	INSERT INTO {$CONFIG['TABLE_PICTURES']} 
    	(aid, 				filepath, 
    	filename, 			filesize, 
    	total_filesize, 	pwidth, 
    	pheight, 			ctime, 
    	owner_id, 			owner_name, 
    	title, 				caption, 
    	keywords, 			approved, 
    	user1, 				user2, 
    	user3, 				user4, 
    	pic_raw_ip, 		pic_hdr_ip, 
    	position
    	) VALUES (
		'{$CURRENT_PIC_DATA['aid']}', 							'" . addslashes($CURRENT_PIC_DATA['filepath']) . "', 
		'" . addslashes($CURRENT_PIC_DATA['filename']) . "', 	'{$CURRENT_PIC_DATA['filesize']}', 
		'{$CURRENT_PIC_DATA['total_filesize']}', 				'{$CURRENT_PIC_DATA['pwidth']}', 
		'{$CURRENT_PIC_DATA['pheight']}', 						'" . time() . "', 
		'{$CURRENT_PIC_DATA['owner_id']}', 						'{$CURRENT_PIC_DATA['owner_name']}',
		'{$CURRENT_PIC_DATA['title']}', 						'{$CURRENT_PIC_DATA['caption']}', 
		'{$CURRENT_PIC_DATA['keywords']}', 						'{$CURRENT_PIC_DATA['approved']}', 
		'{$CURRENT_PIC_DATA['user1']}', 						'{$CURRENT_PIC_DATA['user2']}', 
		'{$CURRENT_PIC_DATA['user3']}', 						'{$CURRENT_PIC_DATA['user4']}', 
		'{$CURRENT_PIC_DATA['pic_raw_ip']}', 					'{$CURRENT_PIC_DATA['pic_hdr_ip']}', 
		'{$CURRENT_PIC_DATA['position']}')
	";

	//echo("[DEBUG]    (before query) title: " . $title . "\r\n");
	//echo("[DEBUG]    (before query) CURRENT_PIC_DATA['title']: " . $CURRENT_PIC_DATA['title'] . "\r\n");

    $result = cpg_db_query($query);

    return $result;
}

logDebug("In j_picmgmt.inc.php (150)");


/**
* jupload_resize_image()
*
* Create a file containing a resized image
*
* @param  $src_file the source file
* @param  $dest_file the destination file
* @param  $new_size the size of the square within which the new image must fit
* @param  $method the method used for image resizing
* @return 'true' in case of success
*/
function jupload_resize_image($src_file, $dest_file, $new_size, $method, $thumb_use)
{
    global $CONFIG, $ERROR;
    global $lang_errors;

    $imginfo = getimagesize($src_file);
    if ($imginfo == null)
        return false;
        // GD can only handle JPG & PNG images
    //if ($imginfo[2] != GIS_JPG && $imginfo[2] != GIS_PNG && ($method == 'gd1' || $method == 'gd2')) {
    //EGR : wrong ! if ($imginfo[2] != GIS_JPG && $imageinfo[2] != GIS_PNG && $CONFIG['GIF_support'] == 0) {
    if ($imginfo[2] != GIS_JPG && $imginfo[2] != GIS_PNG && $CONFIG['GIF_support'] == 0) {
        $ERROR = $lang_errors['gd_file_type_err'];
        return false;
    }
    // height/width
    $srcWidth = $imginfo[0];
    $srcHeight = $imginfo[1];
    if ($thumb_use == 'ht') {
        $ratio = $srcHeight / $new_size;
    } elseif ($thumb_use == 'wd') {
        $ratio = $srcWidth / $new_size;
    } else {
        $ratio = max($srcWidth, $srcHeight) / $new_size;
    }
    $ratio = max($ratio, 1.0);
    $destWidth = (int)($srcWidth / $ratio);
    $destHeight = (int)($srcHeight / $ratio);
    // Method for thumbnails creation
    switch ($method) {
        case "im" :
            if (preg_match("#[A-Z]:|\\\\#Ai", __FILE__)) {
                // get the basedir, remove '/include'
                $cur_dir = substr(dirname(__FILE__), 0, -8);
                $src_file = '"' . $cur_dir . '\\' . strtr($src_file, '/', '\\') . '"';
                $im_dest_file = str_replace('%', '%%', ('"' . $cur_dir . '\\' . strtr($dest_file, '/', '\\') . '"'));
            } else {
                $src_file = escapeshellarg($src_file);
                $im_dest_file = str_replace('%', '%%', escapeshellarg($dest_file));
            }

            $output = array();
            /*
             * Hack for working with ImageMagick on WIndows even if IM is installed in C:\Program Files.
             * By Aditya Mooley <aditya@sanisoft.com>
             */
             $retval = 0;
            if (eregi("win",$_ENV['OS'])) {
                $cmd = "\"".str_replace("\\","/", $CONFIG['impath'])."convert\" -quality {$CONFIG['jpeg_qual']} {$CONFIG['im_options']} -geometry {$destWidth}x{$destHeight} ".str_replace("\\","/" ,$src_file )." ".str_replace("\\","/" ,$im_dest_file );
                exec ("\"$cmd\"", $output, $retval);
            } else {
                $cmd = "{$CONFIG['impath']}convert -quality {$CONFIG['jpeg_qual']} {$CONFIG['im_options']} -geometry {$destWidth}x{$destHeight} $src_file $im_dest_file";
                exec ($cmd, $output, $retval);
            }


            if ($retval) {
                $ERROR = "Error executing ImageMagick - Return value: $retval";
                if ($CONFIG['debug_mode']) {
                    // Re-execute the command with the backtick operator in order to get all outputs
                    // will not work is safe mode is enabled
                    $output = `$cmd 2>&1`;
                    $ERROR .= "<br /><br /><div align=\"left\">Cmd line : <br /><span style=\"font-size:120%\">" . nl2br(htmlspecialchars($cmd)) . "</span></div>";
                    $ERROR .= "<br /><br /><div align=\"left\">The convert program said:<br /><span style=\"font-size:120%\">";
                    $ERROR .= nl2br(htmlspecialchars($output));
                    $ERROR .= "</span></div>";
                }
                @unlink($dest_file);
                return false;
            }
            break;

        case "gd1" :
            if (!function_exists('imagecreatefromjpeg')) {
                $ERROR = jupload_cpg_die(CRITICAL_ERROR, 'PHP running on your server does not support the GD image library, check with your webhost if ImageMagick is installed', __FILE__, __LINE__);
                return false;
            }
            if ($imginfo[2] == GIS_JPG)
                $src_img = imagecreatefromjpeg($src_file);
            else
                $src_img = imagecreatefrompng($src_file);
            if (!$src_img) {
                $ERROR = $lang_errors['invalid_image'];
                return false;
            }
            $dst_img = imagecreate($destWidth, $destHeight);
            imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
                        touch($dest_file);
            $fh=fopen($dest_file,'w');
            fclose($fh);
            imagejpeg($dst_img, $dest_file, $CONFIG['jpeg_qual']);
            imagedestroy($src_img);
            imagedestroy($dst_img);
            break;

        case "gd2" :
            if (!function_exists('imagecreatefromjpeg')) {
                return jupload_cpg_die(CRITICAL_ERROR, 'PHP running on your server does not support the GD image library, check with your webhost if ImageMagick is installed', __FILE__, __LINE__);
            }
            if (!function_exists('imagecreatetruecolor')) {
                return jupload_cpg_die(CRITICAL_ERROR, 'PHP running on your server does not support GD version 2.x, please switch to GD version 1.x on the admin page', __FILE__, __LINE__);
            }
            if ($imginfo[2] == GIS_GIF && $CONFIG['GIF_support'] == 1)
                $src_img = imagecreatefromgif($src_file);
            elseif ($imginfo[2] == GIS_JPG)
                $src_img = imagecreatefromjpeg($src_file);
            else
                $src_img = imagecreatefrompng($src_file);
            if (!$src_img) {
                $ERROR = $lang_errors['invalid_image'];
                return false;
            }
            if ($imginfo[2] == GIS_GIF)
              $dst_img = imagecreate($destWidth, $destHeight);
            else
              $dst_img = imagecreatetruecolor($destWidth, $destHeight);
            imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
                        touch($dest_file);
            $fh=fopen($dest_file,'w');
            fclose($fh);
            imagejpeg($dst_img, $dest_file, $CONFIG['jpeg_qual']);
            imagedestroy($src_img);
            imagedestroy($dst_img);
            break;
    }
    // Set mode of uploaded picture
    @chmod($dest_file, octdec($CONFIG['default_file_mode'])); //silence the output in case chmod is disabled
    // We check that the image is valid
    $imginfo = getimagesize($dest_file);
    if ($imginfo == null) {
        $ERROR = $lang_errors['resize_failed'];
        echo("[DEBUG] dest_file(after resize_failed): $dest_file\r\n");
        @unlink($dest_file);
        return false;
    } else {
        return true;
    }
}

logDebug("End of j_picmgmt.inc.php");
