<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


//This file is included within a function (see codebase.php: jupload_plugin_wakeup)
//So, we need to declare all variables that must be global, as such:
global $USER, $CONFIG, $JUPLOAD_CONFIG, $lang_jupload_php, $bJuploadTranslactionExist, $juploadRootDirectory;
global $userLang, $userLangFile, $juploadParameterPrefix;



// The $juploadParameterPrefix string will be added at the beginning of each parameter name, before insertion
//into the Coppermine configuration table. 
$juploadParameterPrefix = "jupload_";

$juploadRootDirectory = 'plugins/jupload/';
$juploadIncludeDirectory = 'plugins/jupload/include/';

require_once($juploadIncludeDirectory . 'config.inc.php');
//require_once($juploadIncludeDirectory . 'session.inc.php');
 

//####################################################################################################
//#################################  GLOBAL FUNCTIONS  ###############################################
//####################################################################################################



//####################################################################################################
//#################################    RIGHT CONTROL  ################################################
//####################################################################################################

// Check to see if user can upload pictures.  Quit with an error if he cannot.
//The rules are described on the JUpload configuration page. You can see their text explanation
//in the plugins/jupload/include/config.inc.php page.
global $jupload_may_see_jupload_link, $jupload_user_may_use_jupload, $USER_DATA;

//Default to no access. Initialization should be useless. Just to be sure.
$jupload_may_see_jupload_link = false;
$jupload_user_may_use_jupload = false;

//USER_CAN_CREATE_ALBUMS: means that the user may have its own gallery (and is not an admin)
//USER_CAN_UPLOAD_PICTURES: means that the user may upload picture to public albums (to be confirmed)
if (USER_IS_ADMIN) {
	$jupload_may_see_jupload_link = true;
	$jupload_user_may_use_jupload = true;	
} else {
	switch ($JUPLOAD_CONFIG['alwaysVisible']) {
		case '0':
			$jupload_may_see_jupload_link = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			$jupload_user_may_use_jupload = $jupload_may_see_jupload_link;
			break;
		case '1':
			$jupload_may_see_jupload_link = true;
			$jupload_user_may_use_jupload = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			break;
		case '2':
			$jupload_may_see_jupload_link = false;
			$jupload_user_may_use_jupload = false;
			break;
		default:
			if ($JUPLOAD_CONFIG['alwaysVisible'] == $USER_DATA['group_name']) {
				$jupload_may_see_jupload_link = true;
				$jupload_user_may_use_jupload = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			} else {
				$jupload_may_see_jupload_link = false;
				$jupload_user_may_use_jupload = false;
			}
	}
}


//####################################################################################################
//##############################     LANGUAGE       ##################################################
//####################################################################################################



//Localisation. Handled from specific files, to make upgrade of coppermine easier:
//First: we load the default text (english)
$lang_jupload_php = array();
require("$juploadRootDirectory/lang/english.php");

//Then, you overload with the choosen language, for existing translations.
//$bJuploadTranslactionExist is used later, in page_upload.php, to display a message indicating that
//the translation for the current language doesn't exist ... and to give the link to the page where all
//the text to translate is written (part of text is in the applet, not in the php code).

//$CONFIG is not set, when called from ./plugins/jupload/configuration.php
$userLang = (isset($CONFIG)) ? $CONFIG['lang'] : '';
if (isset($USER['lang'])) {
	$userLang = $USER['lang'];
}
$userLangFile = "$juploadRootDirectory/lang/$userLang.php";


$bJuploadTranslactionExist = file_exists($userLangFile);

if ($userLang == 'english'  ||  $userLang == 'english_gb') {
	//We already included (required) the jupload english.php file
	$bJuploadTranslactionExist = true;  //Was not true for english_gb, one line before ...   ;-)
} else if ($bJuploadTranslactionExist) {
    include($userLangFile);
}


//Let's create a 'default' version number, for my internal tests
$JUPLOAD_CONFIG['version']='[not packaged]'; 
//This internal version number should be replaced by the next line, added during packaging
//Ok, this could be better. But it works, that's a point !    ;-)

$JUPLOAD_CONFIG['version']='3.5.1';

		