<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


/*
 * Created on 30 janv. 07
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


if (!GALLERY_ADMIN_MODE) {
	$msg = str_replace('$1', 'login.php?referer=plugins/jupload/jupload.php', $lang_jupload_php['perm_denied']);

	cpg_die(ERROR, $msg, __FILE__, __LINE__);
}



//This page must not be cached by the navigator.
//Let's suppos we are in HTTP/1.1:
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);





$hint = <<<EOS
<HR>
<B><a name="Behaviour">Plugin behaviour description</a></B>
<BR><BR>
When a picture to upload is bigger than Coppermine main configuration parameter (maximum width and height), the picture 
will be resized <B>according to Coppermine main configuration</B>. This can happen at two places: please take a look
at the <a href="#Hints">configuration hints</a> for some ideas to help you to choose.
<DIR>
	<LI>Before upload, in the applet. See below for criteria on this point. 
	<LI>After upload, in the server. In this case the behaviour is exactly the same as in standard upload.
</DIR>
<BR>
To determine if the picture must be transformed before upload, the applet do the following checks. If one is 
positive, a picture file is created, according to the parameters precised below. If none of the following criteria
are met, the picture file is transmitted as is.
<DIR>
	<LI>The picture must be rotated (the user clicked at least once on one of the rotate left or rotate right buttons)
	<LI>The picture width and height are checked against the JUpload
	<a href="#maxNonTransformedPictureSize">maxNonTransformedPictureSize</a> config parameter. If the picture is bigger,
	a new picture file must be created.
	<LI>If JUpload <a href="#pictureTransmitMetadata">pictureTransmitMetadata</a> config parameter is set to true. (this
	should change ... in the future, to avoid unnecessary picture transformation on client side).
</DIR>
Here is the list of config parameters that determine how to construct the picture file to create:
<DIR>
	<LI>Coppermine max Width/Height for pictures (in pixels): defines the size of picture after rotation
	<LI>JUpload <a href="#pictureCompressionQuality">pictureCompressionQuality</a>: defines the jpeg compression 
	(used only for jpg and jpeg files)
	<LI>JUpload <a href="#pictureTransmitMetadata">pictureTransmitMetadata</a>: defines if metadata are copied in 
	the picture file to upload, or not.
</DIR>
Once this is done, the applet checks the file to upload against the JUpload <a href="#maxFileSize">maxFileSize</a>	 
to accept or not to upload the picture file to the server. Then, the picture is uploaded to the server. The
<a href="#maxChunkSize">maxChunkSize</a> JUpload config parameter allows to override the max file size configured on
your server.  
<HR>
<B><a name="Hints">Configuration hints</a></B>
<BR><BR>
You will find below the list of all JUpload configuration parameters, with a detailled explanation of each one. 
These parameters are stored in the coppermine config table, in the database. So, your configuration is kept when 
you upgrade to a new JUpload  version, through the plugin management page, or with FTP.
<BR><BR>
You will find below <B>two typical configurations</B>:
<DIR
	<LI><B>Configuration to speed up the upload.</B> This configuration is a good replacement for <U>batch upload</U>, 
	and can <U>replace easily the xp_publish script</U>, that is no more available for Vista. The maximum 
	picture/file size is controled only by the maxPictureSize Coppermine configuration parameters. 
		<DIR>
			<LI>In Coppermine configuration, put in the maximum file size a value big enough to allow upload of 
			your bigger files, even if they are bigger than your server maxUploadSize. To upload files bigger than 
			the server maxUploadSize, you will have to use JUpload (and its chunk function, see below).
			<LI>In Jupload configuration:
			<DIR>
				<LI>maxChunkSize: put your server maxUploadSize (typically: 2Mb).
				<LI>maxFileSize: leave it empty.
				<LI>maxNonTransformedPictureSize: put a value larger than your picture max width and height (for 
				instance 4000) to prevent the applet to work on pictures that you want to upload 'as is'. Pictures 
				bigger than this limit will still be resized, before upload, to the maxPictureSize (in pixels) 
				defined in your gallery. 				 
			</DIR>
		</DIR>
	<LI><B>Standard configuration</B>. This configuration is the standard one, as it is compatible with all 
	existing configurations. It good enough for small upload (e.g.: less than 10 to 20 pictures). 
	<BR>Here is a descripion of what will happen if you do not update any
	JUpload parameters, relevant to the way upload works. The maximum picture/file size is controled these two  
	Coppermine configuration parameters: maxFileSize and maxPictureSize. 
		<DIR>
			<LI>In Coppermine configuration, put a value representative of the real maxFileSize you want to 
			allow.
			<LI>In Jupload configuration:
			<DIR>
				<LI>maxChunkSize: empty. All files are uploaded in one piece.
				<LI>maxFileSize: empty. Respects the Coppermine maxFileSize configuration.
				<LI>maxNonTransformedPictureSize: empty. Pictures bigger than the Coppermine maxPictureSize are 
				resized before upload. This can take time, when you upload a lot of pictures, as Java is not as 
				good as native librairies (as GD) for heavy CPU work.		 
			</DIR>
		</DIR>
	<LI><B>To avoid any change in pictures, by the plugin</B>. This configuration forces direct transfert
	of picture to the server. It prevents any manipulation of pictures by the applet. May be useful if your 
	pictures are already prepared for your convenience, and you do not want the applet to interfer. 
		<DIR>
			<LI>In Jupload configuration:
			<DIR>
				<LI>maxNonTransformedPictureSize: put a high value. All files of a size smaller than it will not be updated by the plugin.
				<LI>maxFileSize: can be empty. Respects the Coppermine maxFileSize configuration.
				<LI>pictureTransmitMetadata: must be set to true. Otherwise the plugin touch pictures to remove metadata.
			</DIR>
			<LI>When using the upload: do not rotate pictures. Otherwise, the applet 'has to' modify your pictures.
		</DIR>
</DIR>
<U>Note: if you prepare your pictures before upload</U> and your pictures are already resized to your gallery
maximum width and height, then the above parameters should work the same way... Let the default parameters...

<HR>

EOS
;


/////////////////////////////////////////////////////////////////////////////////////////////////
//            CONFIGURATION STORAGE MIGRATION: config.inc.php -> Coppermine database
/////////////////////////////////////////////////////////////////////////////////////////////////
//This code is to be removed, when I can suppose that nobody still use 2.5.x or older version.
//Until JUpload v2.5.x, the configuration was stored in plugins/jupload/user/config/inc.php
//Since 2.6.0, the JUpload configuration is stored in the Coppermine database. The following
//lines check if this file exists. If yes, the configuration it contains is migrated toward the
//database. This will happen only once, as the file is then deleted.
$config_inc = "$juploadRootDirectory/user/config.inc.php";
if (file_exists($config_inc)) {
	//The file exists.
	//Let's migrate the config parameters to the config table
	migrateConfigFileToConfigTable();
}
/////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////
//            CONFIGURATION STORAGE MIGRATION: config.inc.php -> Coppermine database
/////////////////////////////////////////////////////////////////////////////////////////////////
//Since 3.0.0, there is a JUpload specific session management, that can be activated by using the
//sessionManagement configuration parameter.
//The following function creates this table, if it doesn't already exist.
//createJUploadSessionTable();


//####################################################################################################
//#################################    FUNCTIONS    ##################################################
//####################################################################################################



///////////////////////////////////////////////////////////////////////
/////////////////   MANAGEMENT OF POST DATA        ////////////////////
///////////////////////////////////////////////////////////////////////

if ($action == 'store_config') {

	//No more save in the php config file: we store the JUpload configuration in the config table.
	//$htmlWriteConfigResult = writeJuploadConfigFile();
	saveJuploadConfigParamInCoppermineDatabase($_POST);
	
	//Saved: we say this good news to the user !  ;-)
    pageheader('JUpload configuration');
    msg_box($lang_admin_php['info'], $lang_admin_php['upd_success'], $lang_continue, $JUPLOAD_VAR['SELF'] . "&action=config");
    pagefooter();
    
    //Let's stop here
    exit;
}

///////////////////////////////////////////////////////////////////////
///   RELOAD DATA, TO DISTINGUISH REAL VALUES FROM DEFAULT VALUES    //
///////////////////////////////////////////////////////////////////////
//We clear the calculated config
unset($JUPLOAD_CONFIG);
//Recalculate the JUPLOAD_CONFIG array, without the default values.
initJuploadConfig(false);

/*
 * Next code is Ok when managing the configuration into a php file.

//Then, we load exactly the content of the config file (or nothing, if it doesn't exist)
$config_inc = $juploadRootDirectory . 'user/config.inc.php';
if (file_exists($config_inc)) { 
	require($config_inc);
}
*/


///////////////////////////////////////////////////////////////////////
///////////////   GENERATION OF THE HTML CONTENT    ///////////////////
///////////////////////////////////////////////////////////////////////

pageheader('JUpload configuration');

echo ('<form method="post" name="form_album" enctype="multipart/form-data" action="index.php?file=jupload/jupload&action=store_config">');
	starttable('100%', 'JUpload configuration', 2);
		if (isset($htmlPostResult)) {
			form_statement ("<FONT color=red>An error occured: $htmlPostResult</FONT>");
		}
		if (isset($htmlWriteConfigResult) && $htmlWriteConfigResult != '') {
			form_statement ("<FONT color=red>An error occured: $htmlWriteConfigResult</FONT>");
		}
		
		//First: the table of content, to access directly to each parameters
		form_statement (getTableOfContent());
		
		//Let's display some help.		
		form_statement ($hint);		
		
		//Then, the list of parameters, with: name, description, 
		foreach ($JUploadParamList as $paramName=>$param) {			
			form_statement ("<B><a name='$paramName'>$paramName</a></B>");		
			form_statement ($param['desc']);		
			form_statement ("Default value is '${param['default']}'");
			if ($param['type'] == 'list') {
				//allowedValues must be an array
				if (!isset($param['allowedValues']) || !is_array($param['allowedValues'])) {
					cpg_die("Internal error in JUpload: allowedValues not defined for $paramName");
				}
				//Let's display the list (select input)
				select_input (	$paramName, 
								$paramName,
								isset($JUPLOAD_CONFIG[$paramName]) ? $JUPLOAD_CONFIG[$paramName] : '',
								$param['allowedValues']
								); 
			} else {		
				text_box_input(	$paramName, 
								$paramName, 
								255, 
								1, 
								isset($JUPLOAD_CONFIG[$paramName]) ? $JUPLOAD_CONFIG[$paramName] : ''
								); 
			}
			form_statement ('<BR>');		
		}
	
		$submit_buttons = array (
			    array('value' => 'Store configuration'),
		    );
		submit_button($submit_buttons);
	endtable();
echo ("</form>");
pagefooter();
//ob_end_flush();
