<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2007 Coppermine Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  ********************************************
  Coppermine version: 1.4.11
  $Source$
  $Revision: 3406 $
  $Author: gaugau $
  $Date: 2006-12-27 10:12:12 +0100 (Wed, 27 Dec 2006) $
**********************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');


$thisplugin->add_action('plugin_install','opensearch_install');
$thisplugin->add_action('plugin_configure','opensearch_configure');

$thisplugin->add_filter('page_meta','opensearch_meta');

function opensearch_meta(){
	
	global $CONFIG;

	return '<link rel="search" href="plugins/opensearch/osd.xml" type="application/opensearchdescription+xml" title="Search ' . $CONFIG['gallery_name'] . '" />';
}

function opensearch_install() {

	global $CONFIG;
	
	$osd = 'plugins/opensearch/osd.xml';
	
	$handle = fopen($osd, "r+");
	
	if (!$handle) {
		echo '<p style="color: red; text-align: center">Failed to open file "'. $osd . '" - check permissions.</p>';
		return 1;
	}
	
	if (empty($_POST['os_submit'])) return 1;
	
	$content = fread($handle, filesize($osd));

	$data = array(
		'{SHORT_NAME}' => substr($_POST['os_name'], 0, 16),
		'{DESCRIPTION}' => substr($_POST['os_desc'], 0, 1024),
		'{SITE_URL}' => $_POST['os_url'],
	);
	
	$content = str_replace(array_keys($data), array_values($data), $content);
	
	rewind($handle);

	$written = fwrite($handle, $content);

	if (!$written) {
		echo '<p style="color: red; text-align: center">Failed to write to file "'. $osd . '" - check permissions</p>';
		fclose($handle);
		return 1;
	}
	
	fclose($handle);
	
	return true;
}

function opensearch_configure() {

	global $CONFIG;
	
    echo <<< EOT
    <h3>Enter the details to be used for the description file</h3><br />
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
    	<p>Gallery url (must be correct): 
    		<input type="text" class="textinput" name="os_url" value="{$CONFIG['site_url']}" size="50%" />
    	</p>
        <p>Name as displayed in browser: 
        	<input type="text" class="textinput" name="os_name" maxlength="16" size="16" value="{$CONFIG['gallery_name']}"/> (16 character limit)
        </p>
        <p>Description: 
        	<input type="text" class="textinput" name="os_desc" maxlength="1024" size="50%" value="{$CONFIG['gallery_description']}" /> (1024 character limit)
        </p>
        <br />
        <input type="submit" name="os_submit" class="button"  value="Create" />
    </form>
EOT;
}
?>
