<?php

// -----------------------------------------------------------------------------------------
// DEFAULT PART - ONLY FOR INSTALL & UNINSTALL PLUGIN
// -----------------------------------------------------------------------------------------

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...'); 

require_once('plugins/cpgmart/include/init.inc.php');

// install action
$thisplugin->add_action('plugin_install' ,'cpgmart_install');
// configure action
$thisplugin->add_action('plugin_configure', 'cpgmart_configure');
// uninstall action
$thisplugin->add_action('plugin_uninstall', 'cpgmart_uninstall');
// cleanup action 
$thisplugin->add_action('plugin_cleanup', 'cpgmart_cleanup');

function cpgmart_sql($title, $sqlFile) {
	global $CONFIG;	
	require ('include/sql_parse.php');  	
	$sql_query = fread(fopen($sqlFile, 'r'), filesize($sqlFile));
	$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';'); 			
    echo <<<EOT
    	<h2>$title</h2>
        <table class="maintable" border="0" cellspacing="0" cellpadding="0">        
EOT;
	foreach($sql_query as $q) {
		echo "<tr><td class='debug_text' style='color: black;'>$q</td>";
		if (mysql_query($q)) {
        	echo "<td class='debug_text' style='color: green;'>OK</td></tr>";
        } else {
        	echo "<td class='debug_text' style='color: black;'>Already Done</td></tr>";
        }
	}
	echo '</table>';
}

function cpgmart_install() {
    // install
    if (isset($_REQUEST['submit']) && $_REQUEST['submit'] == 'GO!') {
        return true;
    } else {
        return 1;
    }
}

function cpgmart_configure($stop=true) {
    global $errors, $CONFIG;    
    cpgmart_sql('Performing database updates','plugins/cpgmart/sql/install.sql');
    if ($stop) {
        echo <<< EOT
        <form action="{$_SERVER['REQUEST_URI']}" method="post">
            <input type="submit" value="GO!" name="submit" />
        </form>
EOT;
    }
}

function cpgmart_cleanup($action) {
    if ($action === 1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            Do you want to drop the plugin's current database ?
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="1" /></td>
                <td>YES</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" value="0" /></td>
                <td>NO</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="Submit" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="Cancel" />
        </span>
    </form>
EOT;
    }
}

function cpgmart_uninstall() {
	global $CONFIG;
    if (!isset($_POST['drop'])) return 1;
    if ($_POST['drop']) {    	    	
		cpgmart_sql('Drop the database', 'plugins/cpgmart/sql/uninstall.sql');		
    }		   
    return true;
}

// -----------------------------------------------------------------------------------------
// SUB PART - FOR FUNCTION THAT MAKE ADMIN|USER BUTTON, REDIRECT ...
// -----------------------------------------------------------------------------------------

function cpgmart_admin_button($href, $title, $target, $link, $before='documentation') {
	global $template_gallery_admin_menu;
	$newTemplate = $template_gallery_admin_menu;
	$button = template_extract_block($newTemplate, $before);
	$beforeU = strtoupper($before);
	$params = array(
      "{{$beforeU}_HREF}" => $href,
      "{{$beforeU}_TITLE}" => $title,
      "target=\"cpg_$before\"" => $target,
      "{{$beforeU}_LNK}" => $link,
   	);
	$newButton="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";	
	template_extract_block($template_gallery_admin_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $newButton);	
}

function cpgmart_user_button($href, $title, $target, $link, $before='documentation') {

}

if (function_exists('cpgmart_redirect')) {
	function cpgmart_redirect($link, $type='php') {	
		// PHP redirect
		if ($type == 'php') {
        	header("Location: $link");
		} else {
		// HTML redirect
			echo "<html><head><meta http-equive=\"refresh\" content=\"2; URL=$link\"></head></html>";
		}
	}
}
// -----------------------------------------------------------------------------------------
// MAIN PART - EVERYTHING START HERE
// ----------------------------------------------------------------------------------------- 

// page start action
$thisplugin->add_action('page_start', 'cpgmart_start');

function cpgmart_start() {
	global $CONFIG;
	// this page
	global $lang_cm_codebase;
	// common
	global $lang_cm_common;
	// admin
	global $lang_cm_mainpage;
	global $lang_cm_config;
	global $lang_cm_price, $lang_cm_priceset;
	global $lang_cm_option, $lang_cm_optionset;
	global $lang_cm_order;
	// cart
	global $lang_cm_cart;
	// edit pics
	global $lang_cm_edit_pic; 	
	// error
	global $lang_cm_error;	
	// other	
	global $currency_symbol;
	// lang
	if (!file_exists(CPGMART_PLUGIN_DIR."lang/{$CONFIG['lang']}.php")) $CONFIG['lang'] = 'english';
	require_once(CPGMART_PLUGIN_DIR."lang/{$CONFIG['lang']}.php");		
	// administator button
	cpgmart_admin_button('index.php?file=cpgmart/cpgmart_config', $lang_cm_codebase['cpgmart_mgr'],'',$lang_cm_codebase['cpgmart_mgr']);
	// cart status - joomla style ? 
}

// Add file data data filter
$thisplugin->add_filter('file_data','cpgmart_file_data');
 
function cpgmart_file_data($CURRENT_PIC_DATA) {
 	global $CONFIG; 
 	global $template_display_media;
 	global $lang_cm_codebase;
 	global $currency_symbol;
 	$template_display_media .= cpgHTML::add_to_cart($CURRENT_PIC_DATA);
 	// edit one pic
 	if (GALLERY_ADMIN_MODE)
 		$CURRENT_PIC_DATA['menu'] .= "&nbsp;<a href=\"index.php?file=cpgmart/cpgmart_edit_pic&pid={$CURRENT_PIC_DATA['pid']}\" class=\"admin_menu\">{$lang_cm_codebase['edit_pic']}</a>"; 	
 	return $CURRENT_PIC_DATA;	 
}

// theme thing
$thisplugin->add_filter('gallery_header', 'cpgmart_gallery_header');

function cpgmart_gallery_header() {
	global $CONFIG;
	global $template_header;
	global $template_album_admin_menu;
	global $lang_cm_codebase;  
	global $cpgmart;        
	if (!is_object($cpgmart)) $cpgmart = new cpgMart();	 
	if (GALLERY_ADMIN_MODE) {	
		$link = "</a>
		</td>
		<td align=\"center\" valign=\"middle\" class=\"admin_menu\">		
			<a href=\"index.php?file=cpgmart/cpgmart_edit_pic&aid={ALBUM_ID}\">{$lang_cm_codebase['edit_album']}";
		$template_album_admin_menu = str_replace('{EDIT_PICS}', '{EDIT_PICS}'.$link, $template_album_admin_menu);
	}
	// global cart
	$item_in_cart = count($cpgmart->cart);
	if ($item_in_cart > -1) {
		$tpl_cm_gb = "<div align=\"center\">
		<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\">
	    	<tr>
				<td class=\"admin_menu\" valign=\"middle\">
					<a href=\"index.php?file=cpgmart/cpgmart_cart&page=view_cart\">{$lang_cm_codebase['view_cart']} ($item_in_cart)</a>
				</td>	
				<td class=\"admin_menu\" valign=\"middle\">
					<a href=\"index.php?file=cpgmart/cpgmart_cart&page=preview_cart\">{$lang_cm_codebase['check_out']}</a>
				</td>	
			</tr>
		</table></div>";		
		$template_header = str_replace('{ADMIN_MENU}', $tpl_cm_gb.'{ADMIN_MENU}', $template_header);
	}
}
 
// I make all part of this great plugin -> why I don't have a little credit ?
$thisplugin->add_filter('gallery_footer', 'cpgmart_gallery_footer');

function cpgmart_gallery_footer($template_footer) {	
   	return $template_footer; 
}
 
?>