<?php

class cpgTool { 
	// _REQUEST VAR
	function request_var($var_name) {
		return $_REQUEST[$var_name];	
	}                                   	
	// _GET VAR
	function get_var($var_name) {
		return $_GET[$var_name];	
	}
	// _POST VAR
	function post_var($var_name) {
		return $_POST[$var_name];	
	}	
	// format to cool format 
	function price_format($price) { 
		return number_format($price, 2, '.', '');	
	}
	// exchange price beetween different currecy
	function currency_exchange($price, $from, $to) {
		global $CONFIG;				
		return $price*(self::currency_rate($to)/self::currency_rate($from));		
	}
	// to config currency
	function to_config_currency($price, $currency) {
		global $CONFIG;		
		return self::currency_exchange($price, $currency, $CONFIG['cpgmart_currency']);		
	}	
	// check if this pic is shopable || not
	function is_shopable($pic_data) {
		global $CONFIG;	
		// pid || pic_data
		if (!is_array($pic_data)) $pic_data = array('pid'=>$pic_data);		
		// empty -> get from DB ^^
		if (!isset($pic_data['price']))
			$pic_data['price'] = cpgDB::fetchVar("SELECT price FROM `{$CONFIG['TABLE_PICTURES']}` WHERE pid = '{$pic_data['pid']}' LIMIT 1;");		
		// check & return
		if ((int)$pic_data['price'] == 0) return false; else return true;
	
	}                 	   
	// encode
	function encode_data($data) {
		return base64_encode(serialize($data));		
	}
	// decode
	function decode_data($data) {
		return unserialize(base64_decode($data));		
	}
	function add_js($file_or_content) {
		global $CONFIG;
		global $template_header;
		// file || content
		if (is_file($fileORcontent))
			$js_include = "<script type=\"text/javascript\" src=\"$file_or_content\"></script>";       
		else
			$js_include = $file_or_content;
		// add
		$template_header = str_replace("</head>",$js_include."\n</head>",$template_header);
	}
	function error($errorString) {
		echo $errorString;
		exit;		
	}
	function in_string($string, $search_string) {
		if (strpos($string, $search_string) !== false) return true;
		else return false;	
	}
	function get_pic_data($pid) {
		global $CONFIG;
		return cpgDB::fetchRow("SELECT pid, url_prefix, filepath, filename, `price`, `option` FROM `{$CONFIG['TABLE_PICTURES']}` WHERE pid='$pid' LIMIT 1;");		
	}
	function price_each($item_data) {
		global $CONFIG;		
		$total = 0;
		// get price value
		$current_price_data = cpgDB::fetchRow("SELECT value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid='{$item_data['price']}' LIMIT 1;");
		$total += self::to_config_currency($current_price_data['value'], $current_price_data['currency']);
		// get option value	
		foreach ($item_data['option'] as $option_id => $option_value) {
		 	$option_data = cpgDB::fetchRow("SELECT title_array, value_array, currency FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid='{$option_id}' LIMIT 1;");
		 	$option_data['title_array']	= cpgTool::decode_data($option_data['title_array']);
			$option_data['value_array']	= cpgTool::decode_data($option_data['value_array']);			
		 	foreach ($option_data['title_array'] as $title_key => $title_value) {
				$option_combine[] = array($option_data['value_array'][$title_key], $option_data['title_array'][$title_key]);			
			}
		 	$total += self::to_config_currency($option_combine[$option_value][0], $option_data['currency']);		 	
		}		
		return $total;
	}
	function get_option_array_from_pid($pid) {
		global $CONFIG; 	
		$option_set_id = cpgDB::fetchVar("SELECT `option` FROM `{$CONFIG['TABLE_PICTURES']}` WHERE pid='$pid' LIMIT 1;");		
		$option_array = cpgDB::fetchVar("SELECT option_array FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` WHERE oid='$option_set_id' LIMIT 1;");
		return self::decode_data($option_array);
	}
	function currency_rate($currency) {
		$exc_rate = array(		
			'USD' => 1,
			'CAD' => 0.99597997037873,
			'GBP' => 0.4914309894915,
			'EUR' => 0.70526835460893,
			'JPY' => 115.34663939629,
		);
		return $exc_rate[$currency];
	} 
}

?>