<?php
/**************************************************
  Coppermine 1.4.x Plugin - Right Click Menu
  *************************************************
  Copyright (c) 2006 Borzoo Mossavari
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************
  This is a simple Advertisement plugin without statistics
  or any kind of log.
  this will give you flash/picture/HTML banner
  By using FRAME technology
  ***************************************************/
  
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add an install & configure & uninstall actions
$thisplugin->add_action('plugin_install','rcmenu_install');
$thisplugin->add_action('plugin_configure','rcmenu_configure');
$thisplugin->add_action('plugin_uninstall','rcmenu_uninstall');
$thisplugin->add_action('plugin_cleanup','rcmenu_cleanup');

// Add the main filter - Add Menu to the page
$thisplugin->add_filter('page_html','rc_menu');

// Add actions
$thisplugin->add_action('page_start','rcmenu_page_start');

// Install Plugin
function rcmenu_install() 
{
	global $CONFIG, $lang_plugin_rcmenu, $lang_plugin_rcmenu_config, $lang_plugin_rcmenumgr, $thisplugin;
	require ('plugins/rcmenu/include/init.inc.php');
	if ($_POST['submit']==$lang_plugin_rcmenu_config['button_install']) {
		require 'include/sql_parse.php';
		// create table	
		$db_schema = $thisplugin->fullpath . '/schema.sql';
		$sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
		$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

		$sql_query = remove_remarks($sql_query);
		$sql_query = split_sql_file($sql_query, ';');
		
		foreach($sql_query as $q) { 
			cpg_db_query($q);
		}
		return true;
	} else {
		return 1;
	}
}

// Configure Plugin
function rcmenu_configure() 
{
	global $CONFIG, $lang_plugin_rcmenu, $lang_plugin_copperad_rcmenu,$lang_plugin_rcmenumgr;
	require ('plugins/rcmenu/include/init.inc.php');

	echo <<< EOT
		<h2>{$lang_plugin_rcmenu['install_click']}</h2>
		{$lang_plugin_rcmenu['install_note']}<br />
		<br />
		<form action="{$_SERVER['REQUEST_URI']}" method="post">
		<input type="submit" value="{$lang_plugin_rcmenu_config['button_install']}" name="submit" />
		</form>
EOT;
}

// Uninstall (ask admin about dropping table)
function rcmenu_uninstall()
{
	global $CONFIG, $thisplugin;
	
	if (!isset($_POST['drop'])) return 1;
	
	if ($_POST['drop']) {
		cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PLUGIN_RCMENU']}");
   	}

	return true;
}

// Ask if admin wants to drop the table
function rcmenu_cleanup($action) 
{
    global $lang_plugin_rcmenu_config;
    require ('plugins/rcmenu/include/init.inc.php');

    if ($action===1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            {$lang_plugin_rcmenu_config['cleanup_question']}
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" value="1" /></td>
                <td>Yes</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="0" /></td>
                <td>No</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="{$lang_plugin_rcmenu_config['button_submit']}" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="{$lang_plugin_rcmenu_config['button_cancel']}" />
        </span>
    </form>
EOT;
    }
}

// add config button
function rcmenu_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// add admin button to start of each page
function rcmenu_page_start()
{
	global $CONFIG, $lang_plugin_rcmenu, $lang_plugin_rcmenu_config, $lang_plugin_rcmenumgr, $RCMENU;
	require ('plugins/rcmenu/include/init.inc.php');
	$RCMENU = cpg_db_query("SELECT * FROM {$CONFIG['TABLE_PREFIX']}plugin_rcmenu order by id");
	$CONFIG['TABLE_PLUGIN_RCMENU'] = $CONFIG['TABLE_PREFIX'].'plugin_rcmenu';

	if (GALLERY_ADMIN_MODE) {
		rcmenu_add_config_button('index.php?file=rcmenu/rcmenumgr',$lang_plugin_rcmenu['config_title'],'',$lang_plugin_rcmenu['config_button']);
	}
}

// Add Righ Click Menu
function rc_menu($html) 
{
	global $CONFIG, $RCMENU;
	$premenu='</title>
	<link rel="stylesheet" type="text/css" href="plugins/rcmenu/css/xwebmenu.css" />
	<script type="text/javascript" src="plugins/rcmenu/js/XWebMenuClass.js"></script>
	<script type="text/javascript">
	function init() {
	linkContext = new XWebMenu.Context(document);';
	$menu='';
	while ($row=mysql_fetch_assoc($RCMENU)){
		if($row['hrnext']=='1'&& $row['admin']==0) {
			$menu=$menu.'linkContext.Add("'.$row['title'].'","'.$row['url'].'",0);
			linkContext.Add();';
		} else if($row['hrnext']=='0'&& $row['admin']==0){
					$menu=$menu.'linkContext.Add("'.$row['title'].'","'.$row['url'].'",0);';
		} else if (GALLERY_ADMIN_MODE && $row['admin']==1 && $row['hrnext']=='1') {
					$menu=$menu.'linkContext.Add("'.$row['title'].'","'.$row['url'].'",0);
			linkContext.Add();';
		} else if (GALLERY_ADMIN_MODE && $row['admin']==1 && $row['hrnext']=='0') {
						$menu=$menu.'linkContext.Add("'.$row['title'].'","'.$row['url'].'",0);';
		}
	}
	
	$postmenu='	
    var links = document.getElementsByTagName("A");
	for ( var i = 0; i < links.length; i++ ) {
	    linkContext.Attach(links[i]);
		}
	}
	</script>';
	if(ereg('table { border:0; height:100%; width:100%; border-collapse:collapse}',$html))
	{
		$html=ereg_replace('table { border:0; height:100%; width:100%; border-collapse:collapse}','#fulltb { border:0; height:100%; width:100%; border-collapse:collapse}',$html);
		$html=ereg_replace('<table>','<table id="fulltb">',$html);
	}
	$mainmenu=$premenu.$menu.$postmenu;
	$newonload='';
	if(ereg('onload = hideall;',$html)){
		$html = ereg_replace('onload = hideall;',$newonload,$html);
		$newbody='<body onload="init();hideall()">';
		$html = ereg_replace('<body>',$newbody,$html);
	} else if(!ereg('onload=change;',$html)){
		$html = ereg_replace('<body>','<body onload="init();">',$html);
	}
	if(ereg('onload=change;',$html)){
		$html = ereg_replace('onload=change;',$newonload,$html);
		$newbody='<body onload="init();change()">';
		$html = ereg_replace('<body>',$newbody,$html);
	}
	$html = ereg_replace('</title>',$mainmenu,$html);
	return $html;
	}
?>