<?php

function settings() {
	global $CONFIG;
	global $lang_fr_settings, $lang_fr_manageboards, $lang_fr_admin_data, $lang_continue;
	global $template_fr_manageboards, $template_fr_simple_data;
    $template_admin_panel = template_extract_block($template_fr_manageboards, "admin_panel");
    // display a panel
    HTMLelement::spacer();
    starttable($CONFIG['picture_table_width']);
    $vars = array(
    	'{LANG_HOME}'			=> $lang_fr_manageboards['fr_admin_home'],	
    	'{LANG_NEW_CAT}'		=> $lang_fr_manageboards['new_cat'],
    	'{LANG_BADWORD_FILTER}' => $lang_fr_manageboards['badword_filter'],
    	'{LANG_CONFIG}'			=> $lang_fr_manageboards['config'],   
    );
    echo template_eval($template_admin_panel, $vars);
    endtable();
    HTMLelement::spacer();
    // update
    if (count($_POST) > 0) { 
    	if (isset($_POST['update_config'])) {	    		
    		foreach($lang_fr_admin_data as $element) {    			
    	    	if ((is_array($element))) {
    		        if (!isset($_POST[$element[1]])) continue; 
    		        $value = addslashes($_POST[$element[1]]);     	            
    				if ($CONFIG[$element[1]] !== stripslashes($value)) {
    					cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$value' WHERE name = '{$element[1]}'");
					}
				}	
			}
		}
	msg_box($lang_fr_settings['info'], $lang_fr_settings['upd_success'], $lang_continue, 'forum.admin.php');
	return "";
	}    
    // display
    ?>
	<script type="text/javascript">
		onload = hideall;
	</script>
	<?php	
	
	echo "<form action=\"".$_SERVER['PHP_SELF']."?action=settings\" method=\"post\">";
	starttable('100%', HTMLelement::apply_bold($lang_fr_settings['title']), 3);
	echo <<<EOT
    <tr>
        <td class="tableh2" colspan="3">
            <a href="javascript:expand();" class="admin_menu">{$lang_fr_settings['expand_all']}&nbsp;&nbsp;<img src="images/descending.gif" width="9" height="9" border="0" alt="" title="{$lang_fr_settings['expand_all']}" /></a>
        </td>
    </tr>
EOT;
	
	create_form($lang_fr_admin_data);
	
	if ($sn1) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice1"></a>'.$lang_fr_settings['notice1'].'</td></tr>';
    if ($sn2) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice2"></a>'.$lang_fr_settings['notice2'].'</td></tr>';
    if ($sn3) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice3"></a>'.$lang_fr_settings['notice3'].'</td></tr>';
    
    echo '</table></td></tr>';

	echo <<<EOT
                <tr>
                        <td align="left" class="tablef">
                            <table border="0" cellspacing="0" cellpadding="0" width="100%">
                                <tr>
                                    <td width="33%">
                                        <a href="javascript:expand();" class="admin_menu">{$lang_fr_settings['expand_all']}<img src="images/ascending.gif" width="9" height="9" border="0" alt="" title="{$lang_fr_settings['expand_all']}" /></a>
                                    </td>
                                    <td width="67%" align="center">
                                        <input type="submit" class="button" name="update_config" value="{$lang_fr_settings['save_cfg']}" />
                                    </td>
                                </tr>
                            </table>
                        </td>
                </tr>
EOT;
	endtable();
	echo '</form>';	
}

// FORM FUNCTION

function form_label($text)
{
        global $lang_admin_php;
        global $sn1,$sn2,$sn3;

        static $cmi = 0;
        static $open = false;

        if ($sn1) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice1"></a>'.$lang_admin_php['notice1'].'</td></tr>';
        if ($sn2) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice2"></a>'.$lang_admin_php['notice2'].'</td></tr>';
        if ($sn3) echo '<tr><td colspan ="3" class="tableb_compact"><a name="notice3"></a>'.$lang_admin_php['notice3'].'</td></tr>';

        $sn1 = $sn2 = $sn3 = 0;

        if ($open){
        echo <<< EOT
                                </table>
                        </td>
                </tr>
EOT;
        }
        echo <<< EOT
                <tr>
                        <td class="tableh2" colspan="3" onclick="show_section('section{$cmi}')">
                                <span style="cursor:pointer"><img src="images/descending.gif" border="0" width="9" height="9" alt="" title="{$lang_admin_php['click_expand']}" /> <b>$text</b></span>
                        </td>
                </tr>
                <tr>
                        <td>
                                <table align="center" width="100%" cellspacing="1" cellpadding="0" class="maintable" id="section{$cmi}" border="0">
EOT;

        $open = true;
        $cmi++;
}

function form_input($text, $name, $help = '')
{
    global $CONFIG;

    $value = $CONFIG[$name];
    $help = cpg_display_help($help);

    $type = ($name == 'smtp_password') ? 'password' : 'text';


    echo <<<EOT
                <tr>
                        <td width="60%" class="tableb">
                                $text
                        </td>
                        <td width="50%" class="tableb" valign="top">
                            <input type="$type" class="textinput" maxlength="255" style="width: 100%" name="$name" value="$value"/>
                        </td>
                        <td class="tableb" width="10%">
                                $help
                        </td>
        </tr>

EOT;
}

function form_yes_no($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no;
    $help = cpg_display_help($help);

    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
                        <td class="tableb" width="60%">
                                $text
                        </td>
                        <td class="tableb" valign="top" width="50%">
                                <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected/><label for="{$name}1" class="clickable_option">$lang_yes</label>
                                &nbsp;&nbsp;
                                <input type="radio" id="{$name}0" name="$name" value="0" $no_selected/><label for="{$name}0" class="clickable_option">$lang_no</label>
                        </td>
                        <td class="tableb" width="10%">
                                $help
                        </td>
        </tr>

EOT;
}

function form_img_pkg($text, $name, $help = '')
{
    global $CONFIG;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $im_selected = ($value == 'im') ? 'selected="selected"' : '';
    $gd1_selected = ($value == 'gd1') ? 'selected="selected"' : '';
    $gd2_selected = ($value == 'gd2') ? 'selected="selected"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                $text
            </td>
            <td class="tableb" valign="top" width="50%">
                <select name="$name" class="listbox">
                    <option value="im" $im_selected>Image Magick</option>
                    <option value="gd1" $gd1_selected>GD version 1.x</option>
                    <option value="gd2" $gd2_selected>GD version 2.x</option>
                </select>
            </td>
            <td class="tableb" width="10%">
                $help
            </td>
        </tr>

EOT;
}

function form_sort_order($text, $name, $help = '')
{
    global $CONFIG, $lang_admin_php;

    $help = cpg_display_help($help);

    $value = $CONFIG[$name];
    $ta_selected = ($value == 'ta') ? 'selected="selected"' : '';
    $td_selected = ($value == 'td') ? 'selected="selected"' : '';
    $na_selected = ($value == 'na') ? 'selected="selected"' : '';
    $nd_selected = ($value == 'nd') ? 'selected="selected"' : '';
    $da_selected = ($value == 'da') ? 'selected="selected"' : '';
    $dd_selected = ($value == 'dd') ? 'selected="selected"' : '';
    $pa_selected = ($value == 'pa') ? 'selected="selected"' : '';
    $pd_selected = ($value == 'pd') ? 'selected="selected"' : '';


    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">
                                <option value="ta" $ta_selected>{$lang_admin_php['title_a']}</option>
                                <option value="td" $td_selected>{$lang_admin_php['title_d']}</option>
                                <option value="na" $na_selected>{$lang_admin_php['name_a']}</option>
                                <option value="nd" $nd_selected>{$lang_admin_php['name_d']}</option>
                                <option value="da" $da_selected>{$lang_admin_php['date_a']}</option>
                                <option value="dd" $dd_selected>{$lang_admin_php['date_d']}</option>
                                <option value="pa" $pa_selected>{$lang_admin_php['pos_a']}</option>
                                <option value="pd" $pd_selected>{$lang_admin_php['pos_d']}</option>
                        </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_charset($text, $name, $help = '')
{
    global $CONFIG;

    $help = cpg_display_help($help);

    $charsets = array('Default (not recommended)' => 'language file',
        'Arabic' => 'iso-8859-6',
        'Baltic' => 'iso-8859-4',
        'Central European' => 'iso-8859-2',
        'Chinese Simplified' => 'euc-cn',
        'Chinese Traditional' => 'big5',
        'Cyrillic' => 'koi8-r',
        'Greek' => 'iso-8859-7',
        'Hebrew' => 'iso-8859-8-i',
        'Icelandic' => 'x-mac-icelandic',
        'Japanese' => 'euc-jp',
        'Korean' => 'euc-kr',
        'Maltese' => 'iso-8859-3',
        'Thai' => 'windows-874 ',
        'Turkish' => 'iso-8859-9',
        'Unicode (recommended)' => 'utf-8',
        'Vietnamese' => 'windows-1258',
        'Western' => 'iso-8859-1'
        );

    $value = strtolower($CONFIG[$name]);

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">

EOT;
    foreach ($charsets as $country => $charset) {
        echo "                                <option value=\"$charset\" " . ($value == $charset ? 'selected="selected"' : '') . ">$country ($charset)</option>\n";
    }
    echo <<<EOT
                        </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_language($text, $name, $help = '')
{
    global $CONFIG;

    $help = cpg_display_help($help);
    $value = strtolower($CONFIG[$name]);
    $lang_dir = 'lang/';

    $dir = opendir($lang_dir);
    while ($file = readdir($dir)) {
        if (is_file($lang_dir . $file) && strtolower(substr($file, -4)) == '.php') {
            $lang_array[] = strtolower(substr($file, 0 , -4));
        }
    }
    closedir($dir);

    natcasesort($lang_array);

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">

EOT;
    foreach ($lang_array as $language) {
        echo "                                <option value=\"$language\" " . ($value == $language ? 'selected="selected"' : '') . ">" . ucfirst($language) . "</option>\n";
    }
    echo <<<EOT
                        </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_theme($text, $name, $help = '')
{
    global $CONFIG;
    $help = cpg_display_help($help);


    $result = cpg_db_query("SELECT value FROM {$CONFIG['TABLE_CONFIG']} WHERE name = 'theme'");
    list($value) = mysql_fetch_row($result);
    mysql_free_result($result);
    $theme_dir = 'themes/';

    $dir = opendir($theme_dir);
    while ($file = readdir($dir)) {
        if (is_dir($theme_dir . $file) && $file != "." && $file != ".." && $file != 'CVS' && $file != 'sample') {
            $theme_array[] = $file;
        }
    }
    closedir($dir);

    natcasesort($theme_array);

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">

EOT;
    foreach ($theme_array as $theme) {
        echo "                                <option value=\"$theme\" " . ($value == $theme ? 'selected="selected"' : '') . ">" . strtr(ucfirst($theme), '_', ' ') . "</option>\n";
    }
    echo <<<EOT
                        </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}
// Added for allowing user to select which aspect of thumbnails to scale
function form_scale($text, $name, $help = '')
{
   global $CONFIG, $lang_admin_php ;

           $help = cpg_display_help($help);

    $value = $CONFIG[$name];
    $any_selected = ($value == 'max') ? 'selected="selected"' : '';
    $ht_selected = ($value == 'ht') ? 'selected="selected"' : '';
    $wd_selected = ($value == 'wd') ? 'selected="selected"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">
                                <option value="any" $any_selected>{$lang_admin_php['th_any']}</option>
                                <option value="ht" $ht_selected>{$lang_admin_php['th_ht']}</option>
                                <option value="wd" $wd_selected>{$lang_admin_php['th_wd']}</option>
                        </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_lang_theme($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no, $lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $no_selected = ($value == '0') ? 'checked="checked"' : '';
    $yes_1_selected = ($value == '1') ? 'checked="checked"' : '';
    $yes_2_selected = ($value == '2') ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <input type="radio" id="{$name}1" name="$name" value="1" $yes_1_selected /><label for="{$name}1" class="clickable_option">$lang_yes:{$lang_admin_php['item']}</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}2" name="$name" value="2" $yes_2_selected /><label for="{$name}2" class="clickable_option">$lang_yes:{$lang_admin_php['label']}+{$lang_admin_php['item']}</label>
                &nbsp;&nbsp;
                <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
        </td>
        <td class="tableb" width="10%">
        $help
        </td>
        </tr>

EOT;
}

function form_lang_debug($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no, $lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $no_selected = ($value == '0') ? 'checked="checked"' : '';
    $yes_1_selected = ($value == '1') ? 'checked="checked"' : '';
    $yes_2_selected = ($value == '2') ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                                $text
                </td>
                <td class="tableb" valign="top" width="50%">
                                <input type="radio" id="{$name}1" name="$name" value="1" $yes_1_selected /><label for="{$name}1" class="clickable_option">$lang_yes:{$lang_admin_php['debug_everyone']}</label>
                                &nbsp;&nbsp;
                                <input type="radio" id="{$name}2" name="$name" value="2" $yes_2_selected /><label for="{$name}2" class="clickable_option">$lang_yes:{$lang_admin_php['debug_admin']}</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>

                </td>
                <td class="tableb" width="10%">
                        $help
                </td>
        </tr>

EOT;
}

function form_number_dropdown($text, $name, $help = '')
{
   global $CONFIG, $lang_admin_php ;
   $help = cpg_display_help($help);


    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <select name="$name" class="listbox">
EOT;
        for ($i = 5; $i <= 25; $i++) {
        echo "<option value=\"".$i."\"";
        if ($i == $CONFIG[$name]) { echo " selected=\"selected\"";}
        echo ">".$i."</option>\n";
        }
     echo <<<EOT
     </select>
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>
EOT;
}

function form_lang_logmode($text, $name, $help = '')
{
    global $CONFIG, $lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $off_selected = ($value == '0') ? 'checked="checked"' : '';
    $normal_selected = ($value == '1') ? 'checked="checked"' : '';
    $all_selected = ($value == '2') ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                         <input type="radio" id="{$name}1" name="$name" value="1" $normal_selected /><label for="{$name}1" class="clickable_option">{$lang_admin_php['log_normal']}</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}2" name="$name" value="2" $all_selected /><label for="{$name}2" class="clickable_option">{$lang_admin_php['log_all']}</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $off_selected /><label for="{$name}0" class="clickable_option">{$lang_admin_php['no_logs']}</label>
                        &nbsp;&nbsp;
                        ( <a href="viewlog.php">{$lang_admin_php['view_logs']}</a> )
        </td>
        <td class="tableb" width="10%">
        $help
        </td>
        </tr>

EOT;
}


function form_plugin_yes_no($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no,$lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected /><label for="{$name}1" class="clickable_option">$lang_yes</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
                        ( <a href="pluginmgr.php">{$lang_admin_php['manage_plugins']}</a> )
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_exif_yes_no($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no,$lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected /><label for="{$name}1" class="clickable_option">$lang_yes</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
                        ( <a href="exifmgr.php">{$lang_admin_php['manage_exif']}</a> )
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_keywords_yes_no($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no,$lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected /><label for="{$name}1" class="clickable_option">$lang_yes</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
                        ( <a href="keywordmgr.php">{$lang_admin_php['manage_keyword']}</a> )
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
}

function form_disabled($text, $name, $help = '')
{
  global $lang_admin_php;
  $help = cpg_display_help($help);

    echo <<<EOT
                <tr>
                    <td width="60%" class="tableb">
                        $text
                    </td>
                    <td width="50%" class="tableb" valign="top">
                        {$lang_admin_php['bbs_disabled']}
                    </td>
                    <td class="tableb" width="10%">
                        $help
                    </td>
                </tr>

EOT;
}

function form_auto_resize($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no, $lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $no_selected = ($value == '0') ? 'checked="checked"' : '';
    $yes_1_selected = ($value == '1') ? 'checked="checked"' : '';
    $yes_2_selected = ($value == '2') ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                $text
            </td>
            <td class="tableb" valign="top" width="50%">
                <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
                &nbsp;&nbsp;
                <input type="radio" id="{$name}1" name="$name" value="1" $yes_1_selected /><label for="{$name}1" class="clickable_option">$lang_yes:{$lang_admin_php['auto_resize_everyone']}</label>
                &nbsp;&nbsp;
                <input type="radio" id="{$name}2" name="$name" value="2" $yes_2_selected /><label for="{$name}2" class="clickable_option">$lang_yes:{$lang_admin_php['auto_resize_user']}</label>
            </td>
            <td class="tableb" width="10%">
                $help
            </td>
        </tr>

EOT;
}

function form_asc_desc($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no, $lang_admin_php;
    $help = cpg_display_help($help);

    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
                        <td class="tableb" width="60%">
                                $text
                        </td>
                        <td class="tableb" valign="top" width="50%">
                                <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">{$lang_admin_php['ascending']}</label>
                                &nbsp;&nbsp;
                                <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected /><label for="{$name}1" class="clickable_option">{$lang_admin_php['descending']}</label>
                        </td>
                        <td class="tableb" width="10%">
                                $help
                        </td>
        </tr>

EOT;
}


function form_report_post_yes_no($text, $name, $help = '')
{
    global $CONFIG, $lang_yes, $lang_no,$lang_admin_php;
    $help = cpg_display_help($help);


    $value = $CONFIG[$name];
    $yes_selected = $value ? 'checked="checked"' : '';
    $no_selected = !$value ? 'checked="checked"' : '';

    echo <<<EOT
        <tr>
            <td class="tableb" width="60%">
                        $text
        </td>
        <td class="tableb" valign="top" width="50%">
                        <input type="radio" id="{$name}1" name="$name" value="1" $yes_selected /><label for="{$name}1" class="clickable_option">$lang_yes</label>
                        &nbsp;&nbsp;
                        <input type="radio" id="{$name}0" name="$name" value="0" $no_selected /><label for="{$name}0" class="clickable_option">$lang_no</label>
                        ( <a href="keywordmgr.php">{$lang_admin_php['report_post']}</a> )
                </td>
                <td class="tableb" width="10%">
                $help
                </td>
        </tr>

EOT;
} 

function create_form(&$data)
{
        global $sn1, $sn2, $sn3, $options_to_disable, $CONFIG;

    foreach($data as $element) {
        if ((is_array($element))) {
                $element[3] = (isset($element[3])) ? $element[3] : '';
                $sn1 = max($sn1,(strpos($element[0],'<a href="#notice1"')));
                $sn2 = max($sn2,(strpos($element[0],'<a href="#notice2"')));
                $sn3 = max($sn3,(strpos($element[0],'<a href="#notice3"')));
            switch ($element[2]) {
                case 0 :
                    form_input($element[0], $element[1], $element[3]);
                    break;
                case 1 :
                    if (($element[1] == 'enable_encrypted_passwords' && !$CONFIG['enable_encrypted_passwords']) || $element[1] != 'enable_encrypted_passwords') {
                        form_yes_no($element[0], $element[1], $element[3]);
                    }
                    break;
                case 2 :
                    form_img_pkg($element[0], $element[1], $element[3]);
                    break;
                case 3 :
                    form_sort_order($element[0], $element[1], $element[3]);
                    break;
                case 4 :
                    form_charset($element[0], $element[1], $element[3]);
                    break;
                case 5 :
                    form_language($element[0], $element[1], $element[3]);
                    break;
                case 6 :
                    form_theme($element[0], $element[1], $element[3]);
                    break;
                // Thumbnail scaling
                case 7 :
                    form_scale($element[0], $element[1], $element[3]);
                    break;
                // Language + Theme selection
                case 8 :
                    form_lang_theme($element[0], $element[1], $element[3]);
                    break;
                // debug mode selection
                case 9 :
                    form_lang_debug($element[0], $element[1], $element[3]);
                    break;
                // tabbed display fix
                case 10 :
                    form_number_dropdown($element[0], $element[1], $element[3]);
                    break;
                case 11 :
                    form_lang_logmode($element[0], $element[1], $element[3]);
                    break;
                case 12 :
                    form_plugin_yes_no($element[0], $element[1], $element[3]);
                    break;
                case 13 :
                    form_exif_yes_no($element[0], $element[1], $element[3]);
                    break;
                case 14 :
                    form_keywords_yes_no($element[0], $element[1], $element[3]);
                    break;
                    case 15 :
                    form_disabled($element[0], $element[1], $element[3]);
                    break;
                case 16 :
                    form_auto_resize($element[0], $element[1], $element[3]);
                    break;
                // ascending or descending
                case 17 :
                    form_asc_desc($element[0], $element[1], $element[3]);
                    break;
                default:
                    die('Invalid action');
            } // switch
        } else {
                form_label($element);
        }
    }
}
	
?>