<?php
/*
 * $RCSfile: $
 *
 * Digibug4CPG - a plugin for Coppermine gallery to create photo prints, and print product gift items
 * Copyright (C) 2006 Digibug Express, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @version $Revision: $ $Date: $
 * @package Digibug4CPG
 * @author James Andrews <jandrews@digibug.com> for Digibug Express, Inc. http://www.digibug.com/
 */

$digibugPluginHome = dirname(__FILE__);

@session_start();

require_once($digibugPluginHome.'/libs/DigibugAPI.php');

// Check that we are in coppermin and if we aren't then die.
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add plugin_install action
 $thisplugin->add_action('plugin_install','digibugInstall');

// Add plugin_uninstall action
 $thisplugin->add_action('plugin_uninstall','digibugUninstall');

// Filter to add javascript to the album
$thisplugin->add_filter('page_meta','digibugControlHeader');

// Filter to add the checkout menu
$thisplugin->add_filter('template_html','digibugCheckoutMenuAndOnloadInit');


// Filter to add the shopping cart view to all pages.
$thisplugin->add_filter('gallery_header','digibugAddCartAndView');

// Add plugin_install action
$thisplugin->add_filter('thumb_data','digibugImageButtons');


/** **********************************************************
 *  Functions that are used by the filters to make site changes.
 *************************************************************/

function digibugInstall(){
  return true;
}

function digibugUninstall(){
  return true;
}

function digibugAddCartAndView(){
  return digibugCartAndViewDivElements();
} // end: function digibugAddCartAndView() 

function digibugControlHeader(){
  return digibugCSSandJavascriptIncludes();
} // end: function digibugControlHeader()

function digibugCheckoutMenuAndOnloadInit(&$html){
    global $template_sys_menu_spacer;
    $html = str_replace('{SUB_MENU}','{SUB_MENU} <br /> {CART_MENU}',$html);
    $cart_menu = "<a id=\"digibug-menu-cart\" class=\"digibug-sub-menu\" href=\"javascript:digibugOpenViewCart();\"><span id=\"digibug-cart-total\">".count($_SESSION['digibug']['cart'])." images</span> in the cart</a> <span class=\"digibug-sub-menu-delimit\">".$template_sys_menu_spacer."</span> <a href=\"javascript:digibugCheckout();\" id=\"digibug-menu-checkout\" class=\"digibug-sub-menu\">Checkout</a>";
    $html = str_replace('{CART_MENU}',$cart_menu,$html);

    $initScript = '<script language="javascript"> digibugInitializeCart(); </script>';

    $html = preg_replace("/\<\/body>/",$initScript.'</body>',$html);



    return $html;
} // end: function digibugCheckoutMenu()

function digibugImageButtons(&$imageDataArray){

    global $CONFIG;

    // Assume the image is not in the cart.
    $cartStatus = false;

    // We need to calculate the width and height of the thumbnail
    if($imageDataArray['pwidth'] > $imageDataArray['pheight']){
        $thumbwidth = $CONFIG['thumb_width'];
        $ratio = $imageDataArray['pwidth']/$thumbwidth;
        $thumbheight = ceil($imageDataArray['pheight']/$ratio);
    }else{
        $thumbheight = $CONFIG['thumb_width'];
        $ratio = $imageDataArray['pheight']/$thumbheight;
        $thumbwidth = ceil($imageDataArray['pwidth']/$ratio);
    }

    // Check to see if the image is in the cart if it is then we change the $cartStatus to true
    if($_SESSION['digibug'] && array_key_exists('cart',$_SESSION['digibug'])){
      if(array_key_exists('test',$_SESSION['digibug']['cart'])){
        $cartStatus=true;
      }
    }


    $imageDataArray['caption_text'].=digibugViewAddRemoveButtons($CONFIG['site_url'].$imageDataArray['url'],$thumbwidth,$thumbheight,$CONFIG['site_url'].'albums/'.$imageDataArray['filepath'].$imageDataArray['filename'],$imageDataArray['pwidth'],$imageDataArray['pheight'],$cartStatus);


    return $imageDataArray;
}

function digibugOnloadScript(&$html){
  print 'test';
  $html.="hello world";
  return $html;
}



?>
