<?php
/**************************************************
  Coppermine Plugin - Random Select
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

// ------------------------------------------------------------------------------------------------
// Configuration Options - only modify the lines in this block
// ------------------------------------------------------------------------------------------------

   define('RANDSEL_ALBUMS','');    // '' is the default and will allow use of the config panel.
                                   // Any non-blank setting here will replace the config setting.
                                   // Use comma-separated list of AIDs (album IDs).
                                   // For example, '1,5,12' will select albums 1,5, and 12.

   define('RANDSEL_CONFIG',true);  // true: Show config button on the admin toolbar.
                                   // false: Don't show config button (if you set albums above)

// ------------------------------------------------------------------------------------------------
// End of configuration options
// ------------------------------------------------------------------------------------------------

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// ------------------------------------------------------------------------------------------------
// Add filters
// ------------------------------------------------------------------------------------------------
$thisplugin->add_filter('plugin_block','random_select');

// ------------------------------------------------------------------------------------------------
// Add actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('plugin_install','randsel_install');
$thisplugin->add_action('plugin_configure','randsel_configure');
$thisplugin->add_action('plugin_uninstall','randsel_uninstall');
$thisplugin->add_action('page_start','randsel_pagestart');

// ------------------------------------------------------------------------------------------------
// Install Plugin
// ------------------------------------------------------------------------------------------------
function randsel_install() 
{
	global $CONFIG, $lang_plugin_randsel_config;
	require ('plugins/random_select/include/init.inc.php');
	
	if ($_POST['submit']==$lang_plugin_randsel_config['button_done']) {
		return true;
	} else {
		return 1;
	}
}

// ------------------------------------------------------------------------------------------------
// Configure Plugin
// ------------------------------------------------------------------------------------------------
function randsel_configure() 
{
	global $CONFIG, $lang_plugin_randsel, $lang_plugin_randsel_config;
	require ('plugins/random_select/include/init.inc.php');

	// delete previous plugin config options if necessary (just in case)
	cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_randsel_'");

	// insert default parameters into configuration table
	$sql = "INSERT INTO {$CONFIG['TABLE_CONFIG']} (name, value)"
		." VALUES"
		." ('plugin_randsel_album','')"
                .",('plugin_randsel_meta_flag',false)"
                .",('plugin_randsel_meta_preset','')";
	cpg_db_query($sql);

	echo <<< EOT
		<h2>{$lang_plugin_randsel['install_done']}</h2>
		{$lang_plugin_randsel['install_note']}<br />
		<br />
		<form action="{$_SERVER['REQUEST_URI']}" method="post">
		<input type="submit" value="{$lang_plugin_randsel_config['button_done']}" name="submit"/>
		</form>
EOT;
}

// ------------------------------------------------------------------------------------------------
// Uninstall Plugin
// ------------------------------------------------------------------------------------------------
function randsel_uninstall() 
{
	global $CONFIG;
	cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_randsel_'");
	return true;
}

// ------------------------------------------------------------------------------------------------
// add config button
// ------------------------------------------------------------------------------------------------
function randsel_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// ------------------------------------------------------------------------------------------------
// add admin button to start of each page
// ------------------------------------------------------------------------------------------------
function randsel_pagestart()
{
	global $CONFIG, $lang_plugin_randsel;
	require ('plugins/random_select/include/init.inc.php');

	if (GALLERY_ADMIN_MODE && RANDSEL_CONFIG) {
		randsel_add_config_button('index.php?file=random_select/plugin_config',$lang_plugin_randsel['config_title'],'',$lang_plugin_randsel['config_button']);
	}
}

// ------------------------------------------------------------------------------------------------
// Main Code: for the random block, set META_ALBUM_SET to chosen album
// ------------------------------------------------------------------------------------------------
function random_select($matches) {
    global $META_ALBUM_SET, $CONFIG;
    if (is_array($matches)) {
        switch ($matches[1]) {
            case 'random':
                $sel_album = RANDSEL_ALBUMS ? RANDSEL_ALBUMS : $CONFIG['plugin_randsel_album'];
                $CONFIG['plugin_randsel_meta_flag'] = true;
                $CONFIG['plugin_randsel_meta_preset'] = $META_ALBUM_SET;
                $META_ALBUM_SET = $sel_album ? 'AND aid IN ('.$sel_album.')' : '';
                break;
            default:
                if ($CONFIG['plugin_randsel_meta_flag']) {
                    $META_ALBUM_SET = $CONFIG['plugin_randsel_meta_preset'];
                    $CONFIG['plugin_randsel_meta_flag'] = false;
                }
                break;
        }
    }
    return $matches;
}

// ------------------------------------------------------------------------------------------------
// End of plugin code
// ------------------------------------------------------------------------------------------------

?>