<?php

/**
*------------------------------------------------ 
* Code base helper 
*------------------------------------------------ 
*/

/**
* @desc codebase query - for install & uninstall
*/
function codebase_query($title, $sql_file) {
	global $CONFIG;	
	require ('include/sql_parse.php');  	
	$sql_query = fread(fopen($sql_file, 'r'), filesize($sql_file));
	$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';'); 			
    echo <<<EOT
        <table class="maintable" width="100%" border="0" cellspacing="1" cellpadding="0">
        	<tr><td class="tableh1" colspan="2"><b>{$title}</b></td></tr>
EOT;
	foreach($sql_query as $q) {
		echo "<tr><td class='tableb' style='color: black;'>{$q}</td>";
		if (mysql_query($q)) {
        	echo "<td class='tableb' style='color: green;'>OK</td></tr>";
        } else {
        	echo "<td class='tableb' style='color: black;'>Already Done</td></tr>";
        }
	}
	echo '</table>';
}

//------------------------------------------------

/**
* @desc codebase install
*/
function codebase_install() {
    // install
    if (isset($_REQUEST['submit']) && $_REQUEST['submit'] == 'GO!') {
        return true;
    } else {
        return 1;
    }
}

//------------------------------------------------

/** 
* @desc codebase configure
*/
function codebase_configure($stop = TRUE) {
    global $errors, $CONFIG;
    $plugin_name = $_GET['p'];
    $install_sql_file = 'plugins/'.$plugin_name.'/sql/install.sql';
    codebase_query('Performing database updates', $install_sql_file);
    if ($stop) {
        echo <<< EOT
        <form action="{$_SERVER['REQUEST_URI']}" method="post">
            <input class="button" type="submit" value="GO!" name="submit" />
        </form>
EOT;
    }
}

//------------------------------------------------ 

/** 
* @desc codebase cleanup
*/
function codebase_cleanup($action) {
    if ($action === 1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
    	<table class="maintable" width="100%" border="0" cellspacing="1" cellpadding="0">
    		<tr><td class="tableh1"><b>Do you want to drop the plugin's current database ?</b></td></tr>
    	    <tr><td class="tableb">
    	    	<table border="0" cellspacing="0" cellpadding="0">
    	        	<tr>
                		<td><input type="radio" name="drop" checked="checked" value="1" /></td>
                		<td>YES</td>
            		</tr>
            		<tr>
                		<td><input type="radio" name="drop" value="0" /></td>
                		<td>NO</td>
            		</tr>    	
    			</table>
    		</td></tr>
    		<tr>
    			<td class="tableb">
    				<input class="button" type="submit" name="submit" value="Submit" />
            		<input class="button" type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="Cancel" />
    			</td>
    		</tr>
    </form>
EOT;
    }
}

//------------------------------------------------

/** 
* @desc codebase uninstall
*/
function codebase_uninstall() {
	global $CONFIG;
    if (!isset($_POST['drop'])) return 1;
    if ($_POST['drop']) {
    	$plugin_id = $_GET['p'];
    	$result = cpg_db_query("SELECT path FROM `{$CONFIG['TABLE_PREFIX']}plugins` WHERE plugin_id='{$plugin_id}';");
    	$row = cpg_db_fetch_row($result);    
    	$plugin_name = $row['path'];
    	$uninstall_sql_file = 'plugins/'.$plugin_name.'/sql/uninstall.sql';
		codebase_query('Drop the database', $uninstall_sql_file);
    }		   
    return true;
}

//------------------------------------------------

/** 
* @desc codebase admin button
*/
function codebase_admin_button($href, $title, $target, $link, $before = 'documentation') {
	global $template_gallery_admin_menu;
	$new_emplate = $template_gallery_admin_menu;
	$button = template_extract_block($new_emplate, $before);
	$uc_before = strtoupper($before);
	$params = array(
      "{{$uc_before}_HREF}"    => $href,
      "{{$uc_before}_TITLE}"   => $title,
      "target=\"cpg_$before\"" => $target,
      "{{$uc_before}_LNK}"     => $link,
   	);
	$new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";	
	template_extract_block($template_gallery_admin_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);	
}

//------------------------------------------------ 

/** 
* @desc codebase sub user button
*/
function codebase_sub_user_button($href, $title, $target, $link, $before = 'custom_link') {
	global $template_sub_menu;	
	$new_template = $template_sub_menu;
    $button = template_extract_block($new_template, $before);
    switch ($before) {
    	case 'custom_link':	
    		$uc_before = 'CUSTOM_LNK';
    		break;
    	case 'album_list':
    		$uc_before = 'ALB_LIST';
    		break;
    	case 'favpics':
    		$uc_before = 'FAV';
    		break;
    	default:
    	    $uc_before = strtoupper($before);    	
	}
    $params = array(      
      "{{$uc_before}_LNK}"   => $link,
      "{{$uc_before}_TITLE}" => $title,      
      "{{$uc_before}_TGT}"   => $href,
   	);
    $new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
    template_extract_block($template_sub_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);
}

//------------------------------------------------ 

/** 
* @desc codebase sys user button
*/
function codebase_sys_user_button($href, $title, $target, $link, $before = 'custom_link') {
	global $template_sys_menu;	
	$new_template = $template_sys_menu;
    $button = template_extract_block($new_template, $before);
    switch ($before) {
    	case 'my_gallery':	
    		$uc_before = 'MY_GAL';
    		break;
    	case 'allow_memberlist':
    		$uc_before = 'MEMBERLIST';
    		break;
    	case 'enter_admin_mode':
    		$uc_before = 'ADM_MODE';
    		break;
    	case 'leave_admin_mode':
    		$uc_before = 'USR_MODE';
    		break;
    	case 'upload_pic':
    		$uc_before = 'UPL_PIC';
    		break;    		
    	default:
    	    $uc_before = strtoupper($before);    	
	}
    $params = array(      
      "{{$uc_before}_LNK}"   => $link,
      "{{$uc_before}_TITLE}" => $title,      
      "{{$uc_before}_TGT}"   => $href,
   	);
    $new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
    template_extract_block($template_sys_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);
}

//------------------------------------------------

/** 
* @desc codebase redirect
*/
function codebase_redirect($link, $type='js') {	
	// PHP redirect
	if ($type == 'php') {
    	header("Location: $link");
	} elseif ($type == 'js') {
    	echo "<script language=\"javascript\" type=\"text/javascript\">window.location='$link';</script>";
	} else {
		// HTML redirect
		echo "<html><head><meta http-equive=\"refresh\" content=\"2; URL=$link\"></head></html>";			
	}
}

//------------------------------------------------ 

/* end of codebase helper */

?>