<?php

class form {
	function open($action, $name = '', $method = 'post') {
		if ($name != '') {
			return "<form name=\"{$name}\" id=\"{$name}\" action=\"{$action}\" method=\"{$method}\">"."\n";
		} else {
			return "<form action=\"{$action}\" method=\"{$method}\">"."\n";
		}
	}
    function close() {
    	return '</form>'."\n";
	}
    function text($name, $value = '', $is_100 = TRUE) {
    	if ($is_100) {
        	return "<input class=\"textinput\" type=\"text\" name=\"{$name}\" style=\"width: 100%\" value=\"{$value}\" />"."\n";
    	} else {
        	return "<input class=\"textinput\" type=\"text\" name=\"{$name}\" value=\"{$value}\" />"."\n";        
    	}
	}
	function radio($name, $value = '', $text = '') {
		return "<input type=\"radio\" name=\"{$name}\" id=\"{$name}\" value=\"{$value}\" />{$text}"."\n";
	}
	function hidden($name, $value) {
    	return "<input type=\"hidden\" name=\"{$name}\" id=\"{$name}\" value=\"{$value}\" />\n";
	}
    function textarea($name, $value = '', $rows = '8') {
    	return "<textarea class=\"textinput\" id=\"{$name}\" name=\"{$name}\" style=\"width: 100%;\" rows=\"{$rows}\">{$value}</textarea>\n";
	}
	function select($name, $values, $default = '', $is_100 = TRUE) {
		$html = "";
	    if ($is_100) {
        	$html .= "<select name=\"{$name}\" id=\"{$name}\" class=\"listbox\" style=\"width: 100%;\">\n";
    	} else {
        	$html .= "<select name=\"{$name}\" id=\"{$name}\" class=\"listbox\">\n";
    	}
	    foreach ($values as $key => $title) {
        	if ($key == $default) {
            	$html .= "<option value=\"{$key}\" selected=\"selected\">{$title}</option>\n";
        	} else {
            	$html .= "<option value=\"{$key}\">{$title}</option>\n";
        	}
    	}
	    $html .= "</select>\n";
    	return $html;
	}
	function checkbox($name, $checked = TRUE) {
		if ($checked) {
        	return "<input type=\"checkbox\" name=\"$name\" checked>\n";
    	} else {
        	return "<input type=\"checkbox\" name=\"$name\">\n";
    	}
	}
	function submit($value, $name = '') {
		if ($name) {
		 	return "<input class=\"button\" type=\"submit\" value=\"{$value}\" name=\"{$name}\" id=\"{$name}\" />"."\n";
		} else {
		    return "<input class=\"button\" type=\"submit\" value=\"{$value}\" />"."\n";
		}	
	}
	function reset($value, $name = '') {
		if ($name) {
		 	return "<input class=\"button\" type=\"reset\" value=\"{$value}\" name=\"{$name}\" id=\"{$name}\" />"."\n";
		} else {
		    return "<input class=\"button\" type=\"reset\" value=\"{$value}\" />"."\n";
		}	
	}	
}

?>