<?php

class html {
	function button($link, $title, $params = array()) {
		return "<button class=\"button\" onclick=\"window.location.href='{$link}';\" ".html::params($params).">{$title}</button>";
	}
	function img($src, $size = 1, $params = array()) {
		global $CONFIG;
    	$image_info    = getimagesize($src);         
    	$image_info[0] = round($image_info[0] * $size);
    	$image_info[1] = round($image_info[1] * $size);
    	if ((int)$image_info[0] == 0) $image_info[0] = $CONFIG['thumb_width'] * $size;
    	if ((int)$image_info[1] == 0) $image_info[1] = $CONFIG['thumb_width'] * $size;                
    	return "<img border=\"0\" src=\"{$src}\" width=\"{$image_info[0]}\" height=\"{$image_info[1]}\" ".html::params($params)."/>\n";		
	}
	function anchor($href, $title, $params = array()) {
    	return "<a href=\"{$href}\" title=\"{$title}\" ".html::params($params).">{$title}</a>"."\n";
	}
	function spacer() {
		return "<img src=\"images/spacer.gif\" height=\"10\" style=\"width: 100%;\"><br />";
	}
	function params($params = array()) {
    	$html = "";    
    	if (count($params) > 0) {
        	foreach ($params as $k => $v) {
            	$html .= $k.'="'.$v.'" ';
        	}
    	}
    	return $html;
	}
	function paging($paging = array()) {
		$html = "";
		if ($paging['total'] != 0) {
			$number_of_page = ceil($paging['total'] / $paging['limit']);
			if ($paging['page'] > $paging['total']) $paging['page'] = $paging['total'];
			if ($paging['page'] == 0) $current_page = 1;			
			for ($i=1;$i<=$number_of_page;$i++) {				
				if ($paging['page'] == $i) {
					$html .= "[<b>{$i}</b>]" . '&nbsp;&nbsp;';
				} else {
					$html .= "<a href=\"{$paging['pattern']}&page={$i}\">{$i}</a>" . '&nbsp;&nbsp;';
				} 
			}
			return $html;	
    	} else return TRUE;
	}
}

?>