<?php

class Paypal {	

	var $ipn_response;
	var $ipn_data = array();
	var $last_error;	
	
	function Paypal ($sandbox = FALSE) {
		if ($sandbox === TRUE)	 {
    		$this->paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
		} else {
		    $this->paypal_url = "https://www.paypal.com/cgi-bin/webscr";
		}
		$this->add_field('rm','2');
      	$this->add_field('cmd','_xclick');
	}
	
	function add_field ($field, $value) {
      	$this->fields["$field"] = $value;
   	}
   	
   	function submit_paypal_post () {
      	echo "<html>\n";
      	echo "<head><title>Processing Payment...</title></head>\n";
      	echo "<body onLoad=\"document.form.submit();\">\n";
      	echo "<center><h3>Please wait, your order is being processed...</h3></center>\n";
      	echo "<form method=\"post\" name=\"form\" action=\"".$this->paypal_url."\">\n";
      	foreach ($this->fields as $name => $value) {
        	echo "<input type=\"hidden\" name=\"$name\" value=\"$value\">";
      	} 
      	echo "</form>\n";
      	echo "</body></html>\n";
	}	
	
	function process () { 
    	// parse the paypal URL
      	$url_parsed = parse_url($this->paypal_url);
      	// generate the post string from the _POST vars aswell as load the
      	// _POST vars into an arry so we can play with them from the calling
      	// script.
      	$post_string = '';    
      	foreach ($_POST as $field => $value) { 
        	$this->ipn_data["$field"] = $value;
         	$post_string .= $field.'='.urlencode(stripslashes($value)).'&';
      	}
      	$post_string .= "cmd=_notify-validate"; // append ipn command
      	// open the connection to paypal
      	$fp = fsockopen($url_parsed[host], '80', $err_num, $err_str, 30); 
      	if (!$fp) {          
        	// could not open the connection.  If loggin is on, the error message
         	// will be in the log.
         	$this->last_error = "fsockopen error no. $errnum: $errstr";         	
         	return FALSE;
      	} else { 
         	// Post the data back to paypal
         	fputs($fp, "POST {$url_parsed[path]} HTTP/1.1\r\n"); 
         	fputs($fp, "Host: {$url_parsed[host]}\r\n"); 
         	fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n"); 
         	fputs($fp, "Content-length: ".strlen($post_string)."\r\n"); 
         	fputs($fp, "Connection: close\r\n\r\n"); 
         	fputs($fp, $post_string . "\r\n\r\n"); 
         	// loop through the response from the server and append to variable
         	while(!feof($fp)) { 
            	$this->ipn_response .= fgets($fp, 1024); 
         	} 
         	fclose($fp); // close connection
      	}      
      	if (strpos($this->ipn_response, "VERIFIED") !== FALSE) {
      	// if (eregi("VERIFIED", $this->ipn_response)) {  
      		// Valid IPN transaction.         	
      		return TRUE;                
      	} else {  
         	// Invalid IPN transaction.  Check the log for details.
         	$this->last_error = 'IPN Validation Failed.';         	
         	return FALSE;
      	}      
	}
}