<?php
require_once('plugins/framework/initialize.php');
require_once('include/smilies.inc.php');
load_library('User');
$database = Database::getInstance();
$user = User::getInstance();
load_helper(array('table','form','html'));
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;
if ($pid == 0) cpg_die(ERROR, $lang_guessgame_php['err_wrong_pid'], __FILE__, __LINE__);
$database->where('pid', $pid);
$query = $database->get($CONFIG['TABLE_PICTURES']);
if ($query->num_rows() == 0) cpg_die(ERROR, $lang_guessgame_php['err_wrong_pid'], __FILE__, __LINE__);
$CURRENT_PIC_DATA = $query->row_array();
if ($CURRENT_PIC_DATA['owner_id'] != USER_ID) cpg_die(ERROR, $lang_guessgame_php['err_not_owner'], __FILE__, __LINE__); 
$albums = explode(',', $CONFIG['gg_album_id']);
foreach ($albums as $key => $ablum) {
    if ((int)$ablum == 0) unset($albums[$key]);
    else $albums[$key] = (int)$ablum;
}
if (!in_array($CURRENT_PIC_DATA['aid'], $albums)) cpg_die(ERROR, $lang_guessgame_php['err_album_pid'], __FILE__, __LINE__);
$database->select('COUNT(*) as count');
$database->where('pid', $CURRENT_PIC_DATA['pid']);
$query = $database->get($CONFIG['TABLE_PREFIX'].'point');
$row = $query->row_array();
if ((int)$row['count'] != 0) cpg_die(ERROR, $lang_guessgame_php['err_one_time'], __FILE__, __LINE__);
// process
if (count($_POST) > 0) {
    $data = array(
        'pid'        => $pid,
        'aid'        => $CURRENT_PIC_DATA['aid'],
        'award_id'   => (int)$_POST['uid'],
        'award_name' => get_username((int)$_POST['uid']),
        'is_admin'   => 'NO',
        'point'      => (int)$CONFIG['gg_award_point'],
        'time'       => time(),
        'note'       => '',
    );
    $database->insert($CONFIG['TABLE_PREFIX'].'point', $data);
    // add point to user table    
    $data = array('user_point' => "user_point+{$CONFIG['gg_award_point']}",);
    $user->set_user_data((int)$_POST['uid'], $data);
    // message + redirect    
    $referer = 'displayimage.php?pos=-'.$pid;
    pageheader($lang_guessgame_php['award_title'], "<META http-equiv=\"refresh\" content=\"3;url=$referer\">");
    msg_box($lang_guessgame_php['award_title'], sprintf($lang_guessgame_php['award_success'], $data['award_name'], $data['point']), $lang_continue, $referer);
    pagefooter();
    exit();
}
// find who will have a change
$database->select('author_id,msg_author');
$database->where('pid', $pid);
$query = $database->get($CONFIG['TABLE_COMMENTS']);
if ($query->num_rows() == 0) cpg_die(ERROR, $lang_guessgame_php['err_no_uid'], __FILE__, __LINE__);
$users = array();
foreach ($query->result_array() as $row) {
    if ($row['author_id'] && $row['author_id'] != USER_ID) $users[$row['author_id']] = $row['msg_author'];
}
// display
pageheader($lang_guessgame_php['award_title']);
echo table::open();
echo form::open('index.php?file=guessgame/award&pid='.$pid);
echo table::td($lang_guessgame_php['award_title'], 2);
echo table::tds(array(
    array('class'=>'tableb', 'width'=>'30%', 'text'=>$lang_guessgame_php['image']),
    array('class'=>'tableb', 'width'=>'70%', 'text'=>html::anchor('displayimage.php?pos=-'.$pid,$CURRENT_PIC_DATA['filename'])),
));
echo table::tds(array(
    array('class'=>'tableb', 'text'=>$lang_guessgame_php['point']),
    array('class'=>'tableb', 'text'=>(int)$CONFIG['gg_award_point']),
));
echo table::tds(array(
    array('class'=>'tableb', 'text'=>$lang_guessgame_php['choose']),
    array('class'=>'tableb', 'text'=>form::select('uid', $users)),
));
echo table::tds(array(
    array('class'=>'tableb', 'colspan'=>2, 'align'=>'center','text'=>
        form::submit($lang_guessgame_php['submit'], 'submit').
        html::button('displayimage.php?pos=-'.$pid, $lang_guessgame_php['back']),
    ),   
));
echo form::close();
echo table::close();
echo html::spacer();
// find all comment & display
$database->select('author_id,msg_author,msg_body,msg_date');
$database->where('pid', $pid);
$database->where('author_id!=0');
$query = $database->get($CONFIG['TABLE_COMMENTS']);
echo "<center>Comments</center>";
foreach ($query->result_array() as $row) {
    echo table::open();
    echo table::tds(array(
        array('class'=>'tableh1','text'=>html::anchor('profile.php?uid='.$row['author_id'], $row['msg_author'])),
    ));
    echo table::tds(array(
        array('class'=>'tableb','text'=>process_smilies(bb_decode($row['msg_body']))),    
    ));
    echo table::close();
}
pagefooter();
?>