<?php
#**************************************************
#  CPG PMS Plugin for Coppermine Photo Gallery
#  *************************************************
#  Copyright (c) 2006 Thomas Lange <stramm@gmx.net>
#  *************************************************
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  *************************************************
#  Coppermine version: 1.4.13
#  CPG PMS version: 1.1
#  $Revision: 1.0 $
#  $Author: stramm $
#***************************************************

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Init
	$thisplugin->add_action('page_start','pms_start');

// Add plugin_install action
	$thisplugin->add_action('plugin_install','pms_install');

// Add plugin_uninstall action
	$thisplugin->add_action('plugin_uninstall','pms_uninstall');

// Add plugin_cleanup action
	$thisplugin->add_action('plugin_cleanup','pms_cleanup');

// Add plugin_configure action
	$thisplugin->add_action('plugin_configure','pms_configure');

// User menus
// $thisplugin->add_filter('template_html','pms_user_menu');

// Some filters
	$thisplugin->add_filter('thumb_caption','pms_add_link_thumb');
	$thisplugin->add_filter('file_data','pms_add_link_normal');
	$thisplugin->add_filter('template_html','pms_loginform_start');
// new filter for profile
	$thisplugin->add_filter('profile_add_data','pms_profile_edit');

//functions

//install
function pms_install(){
    // Install
    if ($_REQUEST['submit']=='Go!') {
        return true;
    } else {
        return 1;
    }
}

//create tables
function pms_configure($stop=true)
{
    global $errors, $CONFIG;
    require ('include/sql_parse.php');

    $db_update = 'plugins/cpg_pms/sql/basic.sql';
    $sql_query = fread(fopen($db_update, 'r'), filesize($db_update));
    // Update table prefix
    $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';');

    ?>
        <h2>Performing Database Updates<h2>
        <table class="maintable">

    <?php

    foreach($sql_query as $q) {
        echo "<tr><td class='debug_text' style='color: black;'>
		{$q}
		</td>";
        if (mysql_query($q)) {
            echo "<td class='debug_text' style='color: green;'>OK</td></tr>";
        } else {
            echo "<td class='debug_text' style='color: black;'>Already Done</td></tr>";
        }
    }

    echo "</table>";

    if ($stop) {
        echo <<< EOT

        <form action="{$_SERVER['REQUEST_URI']}" method="post">
            <input type="submit" value="Go!" name="submit" />
        </form>
EOT;
    }

}
//uninstall
function pms_uninstall(){
        global $CONFIG;

        if (!isset($_POST['drop'])) return 1;

        if ($_POST['drop']) {
        		//table
                cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PMS']}");
                //additional column in user table
				cpg_db_query("ALTER TABLE {$CONFIG['TABLE_USERS']} DROP user_pmsmail");
				//config entries
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_enabled'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_messages'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_enable_email'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_make_links'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_date_format'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_time_format'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_smilies'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_post_flood'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_message_bbcode'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='pms_message_img_tag'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='display_pms_status'");
				cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='enable_loginform'");
           }

        return true;
}

//cleanup, ask if we want to drop the table
function pms_cleanup($action) {

	global $lang_pms;

    if ($action===1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            {$lang_pms['uninstall']}
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" value="1" /></td>
                <td>Yes</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="0" /></td>
                <td>No</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="Submit" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="Cancel" />
        </span>
    </form>
EOT;
    }
}

//Init
function pms_start()
{
  global $CONFIG, $BRIDGE, $REFERER, $lang_pms_sys, $lang_pms, $loginFormHtml, $lang_pms_notify_email;

  require 'plugins/cpg_pms/include/init.inc.php';

  //add admin button
  pms_add_admin_button('index.php?file=cpg_pms/pms_admin',$lang_pms_sys['admin_title'],'',$lang_pms_sys['admin_title']);
}

//PMS admin button
function pms_add_admin_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template=$template_gallery_admin_menu;
  $button=template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

function pms_add_link_thumb($caption_data)
{
	global $CONFIG, $THEME_DIR;

	if(!$CONFIG['pms_enabled']) return $caption_data;
    foreach ($caption_data as $key => $value) {
    	$link =
		$caption_data[$key]['caption_text'] = ereg_replace('</a></span>',' </a> <a href="'. PM_LINK . $caption_data[$key]['owner_id'] .'"><img src="'.$THEME_DIR.'images/pm.gif" border="0" alt="Send PM" /></a></span>', $caption_data[$key]['caption_text']);
	}
	return $caption_data;
}

function pms_add_link_normal($pic_data)
{
	global $CONFIG, $THEME_DIR, $lang_pms_sys;

	//is a title set
	($pic_data['title']) ? $title = $pic_data['title'] : $title = $lang_pms_sys['noname'];

	//PM feature enabled then add a send PM link
	$pm_link = '<a href="'. PM_LINK . $pic_data['owner_id'] .'"><img src="'.$THEME_DIR.'images/pm.gif" border="0" alt="Send PM" /></a>';

	$pic_data['html'] = $title." ".$lang_pms_sys['from']." <a href=\"profile.php?uid=".$pic_data['owner_id']."\"><strong>".$pic_data['owner_name']."</strong></a>$online $pm_link <br>".$pic_data['html'];
	return $pic_data;
}

function pms_loginform_start(&$html)
{
	global $loginFormHtml;

    if (!strpos($html,'{LOGIN_FORM}')) {
		$html = str_replace('{SUB_MENU}','{SUB_MENU} <br /> {LOGIN_FORM}',$html);
	}
    $html = str_replace('{LOGIN_FORM}',$loginFormHtml,$html);

    return $html;
}

function pms_loginform($logged=1) {
	global $CONFIG, $REFERER, $lang_pms_sys;


global $CONFIG, $lang_loginform, $REFERER, $loginform;

//if (!$CONFIG['enable_loginform']) return $loginFormHtml = "";

if (!USER_ID && $CONFIG['enable_loginform']) {
  $loginFormHtml = <<<EOT
<ins>
    	<form action="login.php?referer=$REFERER" method="post" name="loginbox" style="margin:0; padding:0;">
        <table cellpadding="0" cellspacing="3" border="0">
        <tr>
            <td><input type="text" class="textinput" name="username" size="10" /></td>
            <td><input type="password" class="textinput" name="password" size="10" /></td>
            <td><input name="submitted" type="submit" value="Login" />
            <input name="remember_me" type="hidden" class="checkbox" value="1" checked="checked" /></td>
        </tr>
        <tr>
        <td class="smallfont">$lang_pms_sys[user]</td>
        <td class="smallfont">$lang_pms_sys[pass]</td>
        <td></td>
		</tr>
        </table>
        </form>
</ins>
EOT;
}

if (USER_ID) {

	$loginFormHtml = "<div align=\"right\" class=\"smallfont\">".$lang_pms_sys['welcome']." <strong>".(USER_NAME)."</strong><br />";

	if ($CONFIG['display_pms_status']){
		$result = cpg_db_query("SELECT count(*) FROM  {$CONFIG['TABLE_PMS']} WHERE owner=".(USER_ID));
		list($tot_all_messages) = @mysql_fetch_array($result);
		mysql_free_result($result);
		$result = cpg_db_query("SELECT count(*) FROM  {$CONFIG['TABLE_PMS']} WHERE owner=".(USER_ID)." AND showed='0'");
		list($tot_new_messages) = @mysql_fetch_array($result);
		mysql_free_result($result);

		if ($CONFIG['pms_enabled']) {
			$loginFormHtml .= "<a href='index.php?file=cpg_pms/pms'>".$lang_pms_sys['pms']."</a> ".$tot_new_messages.$lang_pms_sys['unread_total'].$tot_all_messages."</div>";
		}
	}

}
  return $loginFormHtml;
}


function pms_profile_edit($profile_data)
{
	global $CONFIG, $THEME_DIR, $user_data, $lang_register_php, $register_date_fmt, $quick_jump, $pic_count;

		if ($CONFIG['pms_enabled']==1) $PMS_link .= "<span style='float: right;'><a href='".(PM_LINK).$user_data['user_id']."'><img src=\"".$THEME_DIR."images/pm_send_small.gif\" border=0></a></span>";

		//we want the send pm image on top --> unshift, then add to display_form_parameters
		array_unshift($profile_data[0], array('thumb', 'PMS' ));
		//add to the form_data
        $profile_data[1]['PMS'] =  $PMS_link;

    return $profile_data;
}

?>