<?php
#**************************************************
#  CPG PMS Plugin for Coppermine Photo Gallery
#  *************************************************
#  Copyright (c) 2006 Thomas Lange <stramm@gmx.net>
#  *************************************************
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  *************************************************
#  Coppermine version: 1.4.13
#  CPG PMS version: 1.1
#  $Revision: 1.0 $
#  $Author: stramm $
#***************************************************

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

//language detection
$lang = isset($USER['lang']) ? $USER['lang'] : $CONFIG['lang'];
if (!file_exists("plugins/cpg_pms/lang/{$lang}.php"))
  $lang = 'english';
require "plugins/cpg_pms/lang/{$lang}.php";

//pms table prefix
$CONFIG['TABLE_PMS'] = $CONFIG['TABLE_PREFIX'] . "pms";


//bridge compatibility
$udb_var = get_object_vars($cpg_udb);
class cpg_pms_udb extends core_udb {

	function cpg_pms_fetch_pms($db_user_id, $uid, $db_table){
		global $CONFIG, $BRIDGE, $udb_var, $db_prefix;
		$pms_table = $db_prefix.$db_table;
		$sql = "SELECT 1 FROM {$pms_table} WHERE $db_user_id=".$uid."";

		$result = cpg_db_query($sql, $this->link_id);
		$total = mysql_num_rows($result);
        mysql_free_result($result);
		return $total;
	}
	function cpg_pms_fetch_pms_read($db_user_id, $uid, $db_table, $db_read1, $db_read2){
		global $CONFIG, $BRIDGE, $udb_var, $db_prefix;
		$pms_table = $db_prefix.$db_table;
		$sql = "SELECT 1 FROM {$pms_table} WHERE $db_user_id=".$uid." AND $db_read1=".$db_read2."";

		$result = cpg_db_query($sql, $this->link_id);
		$total = mysql_num_rows($result);
        mysql_free_result($result);
		return $total;
	}
}
$cpg_udb = new cpg_pms_udb;

//bridge support incl. loginbox
switch($BRIDGE['short_name']){
	case 'smf10':
		//vars for grabbing pms stats from db
		$db_user_id = 'ID_MEMBER';
		$db_table = 'pm_recipients';
		$db_read1 = 'is_read';
		$db_read2 = '0';
		//pms send link
		define('PM_LINK', $BRIDGE['relative_path_to_config_file'].'index.php?action=pm;sa=send;u=');
		define('PM_LINK_INBOX', $BRIDGE['relative_path_to_config_file'].'index.php?action=pm');
		//loginform data
		if (!USER_ID && $CONFIG['enable_loginform']) {
		$loginFormHtml = <<<EOT
		<div align="right" class="smallfont">
		<ins>

				<form action="{$BRIDGE['relative_path_to_config_file']}index.php?action=login2&referer={$REFERER}" method="post" accept-charset="UTF-8" class="middletext" style="margin: 3px 1ex 1px 0pt;"">
		        <table cellpadding="0" cellspacing="3" border="0">
		        <tr>
		            <td><input type="text" class="textinput" name="user" size="10" /></td>
		            <td><input type="password" class="textinput" name="passwrd" size="10" /></td>
		            <td><input name="submitted" type="submit" value="Login" />
		            	<input type="hidden" name="cookielength" value="-1">
		            	<input name="hash_passwrd" value="" type="hidden">
					</td>
		        </tr>
		        <tr>
		        <td class="smallfont">$lang_pms_sys[user]</td>
		        <td class="smallfont">$lang_pms_sys[pass]</td>
		        <td></td>
				</tr>
		        </table>
				</form>
		</ins>
		</div>
EOT;
		}
		break;
	default: // unbridged coppermine
		//vars for grabbing pms stats from db
		$db_user_id = 'owner';
		$db_table = $CONFIG['TABLE_PMS'];
		$db_read1 = 'showed';
		$db_read2 = '0';
		//pms send link
		define('PM_LINK', 'index.php?file=cpg_pms/pms_send&id=');
		define('PM_LINK_INBOX', $BRIDGE['relative_path_to_config_file'].'index.php?file=cpg_pms/pms');
		//loginform data
		if (!USER_ID && $CONFIG['enable_loginform']) {
		$loginFormHtml = <<<EOT
		<div align="right" class="smallfont">
		<ins>
		    	<form action="login.php?referer=$REFERER" method="post" name="loginbox" style="margin:0; padding:0;">
		        <table cellpadding="0" cellspacing="3" border="0">
		        <tr>
		            <td><input type="text" class="textinput" name="username" size="10" /></td>
		            <td><input type="password" class="textinput" name="password" size="10" /></td>
		            <td><input name="submitted" type="submit" value="Login" />
		            <input name="remember_me" type="hidden" class="checkbox" value="1" checked="checked" /></td>
		        </tr>
		        <tr>
		        <td class="smallfont">$lang_pms_sys[user]</td>
		        <td class="smallfont">$lang_pms_sys[pass]</td>
		        <td></td>
				</tr>
		        </table>
		        </form>
		</ins>
		</div>
EOT;
		}
} // switch


//loginForm data ... the statistics, pms status
if (USER_ID) {
	$loginFormHtml = "<div align=\"right\" class=\"smallfont\">".$lang_pms_sys['welcome']." <strong>".(USER_NAME)."</strong><br />";

	if ($CONFIG['display_pms_status']){
		$tot_all_messages = $cpg_udb->cpg_pms_fetch_pms($db_user_id, USER_ID, $db_table);
		$tot_new_messages = $cpg_udb->cpg_pms_fetch_pms_read($db_user_id, USER_ID, $db_table, $db_read1, $db_read2);
		if ($CONFIG['pms_enabled']) {
			$loginFormHtml .= "<a href='{$BRIDGE['relative_path_to_config_file']}". PM_LINK_INBOX ."'>".$lang_pms_sys['pms']."</a> ".$tot_new_messages.$lang_pms_sys['unread_total'].$tot_all_messages."</div>";
		}
	}

}


?>